/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record.metadata;

import com.apple.foundationdb.annotation.API;
import com.apple.foundationdb.annotation.SpotBugsSuppressWarnings;
import com.apple.foundationdb.record.expressions.RecordKeyExpressionProto;
import com.apple.foundationdb.record.logging.LogMessageKeys;
import com.apple.foundationdb.record.metadata.TupleTypeUtil;
import com.apple.foundationdb.record.metadata.expressions.EmptyKeyExpression;
import com.apple.foundationdb.record.metadata.expressions.FieldKeyExpression;
import com.apple.foundationdb.record.metadata.expressions.FunctionKeyExpression;
import com.apple.foundationdb.record.metadata.expressions.GroupingKeyExpression;
import com.apple.foundationdb.record.metadata.expressions.KeyExpression;
import com.apple.foundationdb.record.metadata.expressions.KeyWithValueExpression;
import com.apple.foundationdb.record.metadata.expressions.ListKeyExpression;
import com.apple.foundationdb.record.metadata.expressions.LiteralKeyExpression;
import com.apple.foundationdb.record.metadata.expressions.NestingKeyExpression;
import com.apple.foundationdb.record.metadata.expressions.RecordTypeKeyExpression;
import com.apple.foundationdb.record.metadata.expressions.ThenKeyExpression;
import com.apple.foundationdb.record.metadata.expressions.VersionKeyExpression;
import com.apple.foundationdb.tuple.Tuple;
import com.google.protobuf.Descriptors;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@API(value=API.Status.UNSTABLE)
public class Key {
    private Key() {
    }

    public static class Evaluated {
        public static final Evaluated EMPTY = new Evaluated(Collections.emptyList());
        public static final Evaluated NULL = new Evaluated(Collections.singletonList(NullStandin.NULL));
        @Nonnull
        private List<Object> values;
        @Nullable
        private List<Object> tupleAppropriateList = null;
        @Nullable
        private Tuple tuple = null;

        @Nonnull
        public static Evaluated scalar(@Nullable Object object) {
            return new Evaluated(Collections.singletonList(object));
        }

        @Nonnull
        public static List<Evaluated> fan(@Nonnull List<Object> valuesToAdd) {
            ArrayList<Evaluated> newValues = new ArrayList<Evaluated>(valuesToAdd.size());
            for (Object object : valuesToAdd) {
                newValues.add(Evaluated.scalar(object));
            }
            return newValues;
        }

        @Nonnull
        public static Evaluated concatenate(@Nonnull List<Object> values) {
            return new Evaluated(values);
        }

        @Nonnull
        public static Evaluated concatenate(@Nullable Object first, Object ... rest) {
            ArrayList<Object> values = new ArrayList<Object>(rest.length + 1);
            values.add(first);
            Collections.addAll(values, rest);
            return new Evaluated(values);
        }

        @Nonnull
        public static Evaluated fromTuple(@Nonnull Tuple tuple) {
            return new Evaluated(tuple.getItems());
        }

        @Nonnull
        public Tuple toTuple() {
            if (this.tuple == null) {
                this.tuple = Tuple.fromList(this.toTupleAppropriateList());
            }
            return this.tuple;
        }

        Evaluated(@Nonnull List<Object> values) {
            this.values = values;
        }

        @SpotBugsSuppressWarnings(value={"RCN_REDUNDANT_NULLCHECK_OF_NONNULL_VALUE"})
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Evaluated evaluated = (Evaluated)o;
            return !(this.values == null ? evaluated.values != null : !this.values.equals(evaluated.values));
        }

        @SpotBugsSuppressWarnings(value={"RCN_REDUNDANT_NULLCHECK_OF_NONNULL_VALUE"})
        public int hashCode() {
            return this.values != null ? this.values.hashCode() : 0;
        }

        public String toString() {
            return this.values.toString();
        }

        @Nullable
        public Object getObject(int idx) {
            return TupleTypeUtil.toTupleAppropriateValue(this.values.get(idx));
        }

        @Nullable
        public <T> T getObject(int idx, Class<T> clazz) {
            Object result = TupleTypeUtil.toTupleAppropriateValue(this.values.get(idx));
            try {
                return clazz.cast(result);
            }
            catch (ClassCastException e) {
                throw new KeyExpression.InvalidResultException("Invalid type in value").addLogInfo(new Object[]{"index", idx, LogMessageKeys.EXPECTED_TYPE, clazz.getName(), LogMessageKeys.ACTUAL_TYPE, result.getClass().getName()});
            }
        }

        @Nonnull
        private <T> T notNull(int idx, @Nullable T value) {
            if (value == null) {
                throw new KeyExpression.InvalidResultException("Unexpected null value").addLogInfo("index", (Object)idx);
            }
            return value;
        }

        public long getLong(int idx) {
            return this.notNull(idx, this.getObject(idx, Number.class)).longValue();
        }

        @Nullable
        public Long getNullableLong(int idx) {
            Number value = this.getObject(idx, Number.class);
            return value == null ? null : Long.valueOf(value instanceof Long ? ((Long)value).longValue() : value.longValue());
        }

        public double getDouble(int idx) {
            return this.notNull(idx, this.getObject(idx, Number.class)).doubleValue();
        }

        @Nullable
        public Double getNullableDouble(int idx) {
            Number value = this.getObject(idx, Number.class);
            return value == null ? null : Double.valueOf(value instanceof Double ? ((Double)value).doubleValue() : value.doubleValue());
        }

        public float getFloat(int idx) {
            return this.notNull(idx, this.getObject(idx, Number.class)).floatValue();
        }

        @Nullable
        public Float getNullableFloat(int idx) {
            Number value = this.getObject(idx, Number.class);
            return value == null ? null : Float.valueOf(value instanceof Float ? ((Float)value).floatValue() : value.floatValue());
        }

        @Nullable
        public String getString(int idx) {
            return this.getObject(idx, String.class);
        }

        @Nonnull
        public Evaluated append(@Nonnull Evaluated secondValue) {
            ArrayList<Object> combined = new ArrayList<Object>(this.values);
            combined.addAll(secondValue.values);
            return new Evaluated(combined);
        }

        @Nonnull
        public List<Object> toList() {
            return this.toTupleAppropriateList();
        }

        @Nonnull
        public List<Object> toTupleAppropriateList() {
            if (this.tupleAppropriateList == null) {
                this.tupleAppropriateList = TupleTypeUtil.toTupleAppropriateList(this.values);
            }
            return this.tupleAppropriateList;
        }

        public boolean containsNonUniqueNull() {
            return this.values.indexOf((Object)NullStandin.NULL) >= 0;
        }

        public List<Object> values() {
            return this.values;
        }

        public int size() {
            return this.values.size();
        }

        public Evaluated subKey(int start, int end) {
            return new Evaluated(this.values.subList(start, end));
        }

        public static enum NullStandin {
            NULL(RecordKeyExpressionProto.Field.NullInterpretation.NOT_UNIQUE),
            NULL_UNIQUE(RecordKeyExpressionProto.Field.NullInterpretation.UNIQUE),
            NOT_NULL(RecordKeyExpressionProto.Field.NullInterpretation.NOT_NULL);

            private RecordKeyExpressionProto.Field.NullInterpretation proto;

            private NullStandin(RecordKeyExpressionProto.Field.NullInterpretation nullInterpretation) {
                this.proto = nullInterpretation;
            }

            public RecordKeyExpressionProto.Field.NullInterpretation toProto() {
                return this.proto;
            }

            public static NullStandin valueOf(RecordKeyExpressionProto.Field.NullInterpretation nullInterpretation) throws KeyExpression.DeserializationException {
                switch (nullInterpretation) {
                    case NOT_UNIQUE: {
                        return NULL;
                    }
                    case UNIQUE: {
                        return NULL_UNIQUE;
                    }
                    case NOT_NULL: {
                        return NOT_NULL;
                    }
                }
                throw new KeyExpression.DeserializationException("Invalid null interpretation" + String.valueOf(nullInterpretation));
            }
        }
    }

    public static class Expressions {
        @Nonnull
        public static final String MAP_KEY_FIELD = "key";
        @Nonnull
        public static final String MAP_VALUE_FIELD = "value";

        private Expressions() {
        }

        @Nonnull
        public static FieldKeyExpression field(@Nonnull String name) {
            return Expressions.field(name, KeyExpression.FanType.None);
        }

        @Nonnull
        public static FieldKeyExpression field(@Nonnull String name, @Nonnull KeyExpression.FanType fanType) {
            return Expressions.field(name, fanType, Evaluated.NullStandin.NULL);
        }

        @Nonnull
        public static FieldKeyExpression field(@Nonnull String name, @Nonnull KeyExpression.FanType fanType, @Nonnull Evaluated.NullStandin nullStandin) {
            return new FieldKeyExpression(name, fanType, nullStandin);
        }

        @Nonnull
        public static ThenKeyExpression concat(@Nonnull KeyExpression first, @Nonnull KeyExpression second, KeyExpression ... rest) {
            return new ThenKeyExpression(first, second, rest);
        }

        @Nonnull
        public static ThenKeyExpression concat(@Nonnull List<KeyExpression> children) {
            return new ThenKeyExpression(children);
        }

        @Nonnull
        public static ThenKeyExpression concatenateFields(@Nonnull String first, @Nonnull String second, String ... fields) {
            KeyExpression[] rest = new KeyExpression[fields.length];
            for (int i = 0; i < fields.length; ++i) {
                rest[i] = Expressions.field(fields[i]);
            }
            return new ThenKeyExpression(Expressions.field(first), Expressions.field(second), rest);
        }

        @Nonnull
        public static ThenKeyExpression concatenateFields(@Nonnull List<String> fields) {
            ArrayList<KeyExpression> exprs = new ArrayList<KeyExpression>(fields.size());
            for (String field : fields) {
                exprs.add(Expressions.field(field));
            }
            return new ThenKeyExpression(exprs);
        }

        @Nonnull
        public static ListKeyExpression list(KeyExpression ... children) {
            return new ListKeyExpression(Arrays.asList(children));
        }

        @Nonnull
        public static ListKeyExpression list(@Nonnull List<KeyExpression> children) {
            return new ListKeyExpression(children);
        }

        @Nonnull
        public static NestingKeyExpression mapKeyValues(@Nonnull String name) {
            return Expressions.field(name, KeyExpression.FanType.FanOut).nest(Expressions.concatenateFields(MAP_KEY_FIELD, MAP_VALUE_FIELD, new String[0]));
        }

        @Nonnull
        public static NestingKeyExpression mapKeys(@Nonnull String name) {
            return Expressions.field(name, KeyExpression.FanType.FanOut).nest(Expressions.field(MAP_KEY_FIELD));
        }

        @Nonnull
        public static NestingKeyExpression mapValues(@Nonnull String name) {
            return Expressions.field(name, KeyExpression.FanType.FanOut).nest(Expressions.field(MAP_VALUE_FIELD));
        }

        @Nonnull
        public static NestingKeyExpression mapValueKeys(@Nonnull String name) {
            return Expressions.field(name, KeyExpression.FanType.FanOut).nest(Expressions.concatenateFields(MAP_VALUE_FIELD, MAP_KEY_FIELD, new String[0]));
        }

        @Nonnull
        public static FunctionKeyExpression function(@Nonnull String name, @Nonnull KeyExpression arguments) {
            return FunctionKeyExpression.create(name, arguments);
        }

        @Nonnull
        public static FunctionKeyExpression function(@Nonnull String name) {
            return FunctionKeyExpression.create(name, EmptyKeyExpression.EMPTY);
        }

        @Nonnull
        public static <T> LiteralKeyExpression<T> value(@Nullable T value) {
            return new LiteralKeyExpression<T>(value);
        }

        @Nonnull
        public static KeyWithValueExpression keyWithValue(@Nonnull KeyExpression child, int splitPoint) {
            return new KeyWithValueExpression(child, splitPoint);
        }

        @Nonnull
        public static EmptyKeyExpression empty() {
            return EmptyKeyExpression.EMPTY;
        }

        @Nonnull
        public static VersionKeyExpression version() {
            return VersionKeyExpression.VERSION;
        }

        @Nonnull
        public static RecordTypeKeyExpression recordType() {
            return RecordTypeKeyExpression.RECORD_TYPE_KEY;
        }

        @Nonnull
        public static FieldKeyExpression fromDescriptor(@Nonnull Descriptors.FieldDescriptor fieldDescriptor) {
            FieldKeyExpression field = fieldDescriptor.isRepeated() ? Expressions.field(fieldDescriptor.getName(), KeyExpression.FanType.FanOut) : Expressions.field(fieldDescriptor.getName());
            field.validate(fieldDescriptor.getContainingType(), fieldDescriptor, false);
            return field;
        }

        public static boolean hasRecordTypePrefix(@Nonnull KeyExpression key) {
            if (key instanceof RecordTypeKeyExpression) {
                return true;
            }
            if (key instanceof GroupingKeyExpression) {
                GroupingKeyExpression grouping = (GroupingKeyExpression)key;
                return grouping.getGroupingCount() > 0 && Expressions.hasRecordTypePrefix(grouping.getWholeKey());
            }
            if (key instanceof KeyWithValueExpression) {
                KeyWithValueExpression keyWithValue = (KeyWithValueExpression)key;
                return keyWithValue.getSplitPoint() > 0 && Expressions.hasRecordTypePrefix(keyWithValue.getInnerKey());
            }
            if (key instanceof ThenKeyExpression) {
                ThenKeyExpression then = (ThenKeyExpression)key;
                return !then.getChildren().isEmpty() && Expressions.hasRecordTypePrefix(then.getChildren().get(0));
            }
            if (key instanceof NestingKeyExpression) {
                return Expressions.hasRecordTypePrefix(((NestingKeyExpression)key).getChild());
            }
            return false;
        }
    }
}

