/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record.metadata;

import com.apple.foundationdb.annotation.API;
import com.apple.foundationdb.record.RecordMetaData;
import com.apple.foundationdb.record.logging.LogMessageKeys;
import com.apple.foundationdb.record.metadata.FormerIndex;
import com.apple.foundationdb.record.metadata.Index;
import com.apple.foundationdb.record.metadata.IndexValidator;
import com.apple.foundationdb.record.metadata.IndexValidatorRegistry;
import com.apple.foundationdb.record.metadata.MetaDataException;
import com.apple.foundationdb.record.metadata.RecordType;
import com.apple.foundationdb.record.provider.foundationdb.IndexMaintainerFactoryRegistryImpl;
import com.apple.foundationdb.record.provider.foundationdb.IndexMaintainerRegistry;
import com.apple.foundationdb.record.util.pair.NonnullPair;
import com.google.common.collect.HashBiMap;
import com.google.common.collect.Sets;
import com.google.protobuf.Descriptors;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;

@API(value=API.Status.EXPERIMENTAL)
public class MetaDataEvolutionValidator {
    @Nonnull
    private static final MetaDataEvolutionValidator DEFAULT_INSTANCE = new MetaDataEvolutionValidator();
    @Nonnull
    private final IndexValidatorRegistry indexValidatorRegistry;
    private final boolean allowNoVersionChange;
    private final boolean allowNoSinceVersion;
    private final boolean allowIndexRebuilds;
    private final boolean allowMissingFormerIndexNames;
    private final boolean allowOlderFormerIndexAddedVersions;
    private final boolean allowUnsplitToSplit;
    private final boolean disallowTypeRenames;

    private MetaDataEvolutionValidator() {
        this.indexValidatorRegistry = IndexMaintainerFactoryRegistryImpl.instance();
        this.allowNoVersionChange = false;
        this.allowNoSinceVersion = false;
        this.allowIndexRebuilds = false;
        this.allowMissingFormerIndexNames = false;
        this.allowOlderFormerIndexAddedVersions = false;
        this.allowUnsplitToSplit = false;
        this.disallowTypeRenames = false;
    }

    private MetaDataEvolutionValidator(@Nonnull Builder builder) {
        this.indexValidatorRegistry = builder.indexValidatorRegistry;
        this.allowNoVersionChange = builder.allowNoVersionChange;
        this.allowNoSinceVersion = builder.allowNoSinceVersion;
        this.allowIndexRebuilds = builder.allowIndexRebuilds;
        this.allowMissingFormerIndexNames = builder.allowMissingFormerIndexNames;
        this.allowOlderFormerIndexAddedVersions = builder.allowOlderFormerIndexAddedVersions;
        this.allowUnsplitToSplit = builder.allowUnsplitToSplit;
        this.disallowTypeRenames = builder.disallowTypeRenames;
    }

    public void validate(@Nonnull RecordMetaData oldMetaData, @Nonnull RecordMetaData newMetaData) {
        if (oldMetaData.getVersion() > newMetaData.getVersion() || !this.allowNoVersionChange && oldMetaData.getVersion() == newMetaData.getVersion()) {
            throw new MetaDataException("new meta-data does not have newer version than old meta-data", new Object[]{LogMessageKeys.OLD_VERSION, oldMetaData.getVersion(), LogMessageKeys.NEW_VERSION, newMetaData.getVersion()});
        }
        this.validateSchemaOptions(oldMetaData, newMetaData);
        this.validateUnion(oldMetaData.getUnionDescriptor(), newMetaData.getUnionDescriptor());
        Map<String, String> typeRenames = this.getTypeRenames(oldMetaData.getUnionDescriptor(), newMetaData.getUnionDescriptor());
        this.validateRecordTypes(oldMetaData, newMetaData, typeRenames);
        this.validateCurrentAndFormerIndexes(oldMetaData, newMetaData, typeRenames);
    }

    private void validateSchemaOptions(@Nonnull RecordMetaData oldMetaData, @Nonnull RecordMetaData newMetaData) {
        if (!this.allowUnsplitToSplit && !oldMetaData.isSplitLongRecords() && newMetaData.isSplitLongRecords()) {
            throw new MetaDataException("new meta-data splits long records", new Object[0]);
        }
        if (oldMetaData.isSplitLongRecords() && !newMetaData.isSplitLongRecords()) {
            throw new MetaDataException("new meta-data no longer splits long records", new Object[0]);
        }
    }

    public void validateUnion(@Nonnull Descriptors.Descriptor oldUnionDescriptor, @Nonnull Descriptors.Descriptor newUnionDescriptor) {
        if (oldUnionDescriptor == newUnionDescriptor) {
            return;
        }
        HashBiMap<Descriptors.Descriptor, Descriptors.Descriptor> updatedDescriptors = HashBiMap.create(oldUnionDescriptor.getFields().size());
        HashSet<NonnullPair<Descriptors.Descriptor, Descriptors.Descriptor>> seenDescriptors = new HashSet<NonnullPair<Descriptors.Descriptor, Descriptors.Descriptor>>();
        for (Descriptors.FieldDescriptor oldUnionField : oldUnionDescriptor.getFields()) {
            if (!oldUnionField.getType().equals((Object)Descriptors.FieldDescriptor.Type.MESSAGE)) {
                throw new MetaDataException("field in union is not a message type", new Object[]{LogMessageKeys.FIELD_NAME, oldUnionField.getName()});
            }
            int fieldNumber = oldUnionField.getNumber();
            Descriptors.FieldDescriptor newUnionField = newUnionDescriptor.findFieldByNumber(fieldNumber);
            if (newUnionField != null) {
                if (!newUnionField.getType().equals((Object)Descriptors.FieldDescriptor.Type.MESSAGE)) {
                    throw new MetaDataException("field in new union is not a message type", new Object[]{LogMessageKeys.FIELD_NAME, newUnionField.getName()});
                }
                Descriptors.Descriptor oldRecord = oldUnionField.getMessageType();
                Descriptors.Descriptor newRecord = newUnionField.getMessageType();
                Descriptors.Descriptor alreadySeenNewRecord = (Descriptors.Descriptor)updatedDescriptors.get(oldRecord);
                if (alreadySeenNewRecord != null) {
                    if (alreadySeenNewRecord != newRecord) {
                        throw new MetaDataException("record type corresponds to multiple types in new meta-data", new Object[]{LogMessageKeys.OLD_RECORD_TYPE, oldRecord.getName(), LogMessageKeys.NEW_RECORD_TYPE, newRecord.getName() + " & " + alreadySeenNewRecord.getName()});
                    }
                } else if (updatedDescriptors.containsValue(newRecord)) {
                    Descriptors.Descriptor alreadySeenOldRecord = (Descriptors.Descriptor)updatedDescriptors.inverse().get(newRecord);
                    throw new MetaDataException("record type corresponds to multiple types in old meta-data", new Object[]{LogMessageKeys.OLD_RECORD_TYPE, oldRecord.getName() + " & " + alreadySeenOldRecord.getName(), LogMessageKeys.NEW_RECORD_TYPE, newRecord.getName()});
                }
                updatedDescriptors.put(oldRecord, newRecord);
                this.validateMessage(oldRecord, newRecord, seenDescriptors);
                continue;
            }
            throw new MetaDataException("record type removed from union", new Object[]{LogMessageKeys.RECORD_TYPE, oldUnionField.getMessageType()});
        }
    }

    private void validateMessage(@Nonnull Descriptors.Descriptor oldDescriptor, @Nonnull Descriptors.Descriptor newDescriptor, @Nonnull Set<NonnullPair<Descriptors.Descriptor, Descriptors.Descriptor>> seenDescriptors) {
        if (oldDescriptor == newDescriptor) {
            return;
        }
        if (!seenDescriptors.add(NonnullPair.of(oldDescriptor, newDescriptor))) {
            return;
        }
        this.validateProtoSyntax(oldDescriptor, newDescriptor);
        for (Descriptors.FieldDescriptor oldField : oldDescriptor.getFields()) {
            int fieldNumber = oldField.getNumber();
            Descriptors.FieldDescriptor newField = newDescriptor.findFieldByNumber(fieldNumber);
            if (newField != null) {
                this.validateField(oldField, newField, seenDescriptors);
                continue;
            }
            throw new MetaDataException("field removed from message descriptor", new Object[]{LogMessageKeys.FIELD_NAME, oldField.getName()});
        }
        for (Descriptors.FieldDescriptor newField : newDescriptor.getFields()) {
            if (oldDescriptor.findFieldByNumber(newField.getNumber()) != null || !newField.isRequired()) continue;
            throw new MetaDataException("required field added to record type", new Object[]{LogMessageKeys.FIELD_NAME, newField.getName()});
        }
    }

    private void validateProtoSyntax(@Nonnull Descriptors.Descriptor oldDescriptor, @Nonnull Descriptors.Descriptor newDescriptor) {
        if (!oldDescriptor.getFile().toProto().getSyntax().equals(newDescriptor.getFile().toProto().getSyntax()) || !oldDescriptor.getFile().toProto().getEdition().equals(newDescriptor.getFile().toProto().getEdition())) {
            throw new MetaDataException("message descriptor proto syntax changed", new Object[]{LogMessageKeys.RECORD_TYPE, oldDescriptor.getName()});
        }
    }

    private void validateField(@Nonnull Descriptors.FieldDescriptor oldFieldDescriptor, @Nonnull Descriptors.FieldDescriptor newFieldDescriptor, @Nonnull Set<NonnullPair<Descriptors.Descriptor, Descriptors.Descriptor>> seenDescriptors) {
        if (!oldFieldDescriptor.getName().equals(newFieldDescriptor.getName())) {
            throw new MetaDataException("field renamed", new Object[]{LogMessageKeys.OLD_FIELD_NAME, oldFieldDescriptor.getName(), LogMessageKeys.NEW_FIELD_NAME, newFieldDescriptor.getName()});
        }
        if (!oldFieldDescriptor.getType().equals((Object)newFieldDescriptor.getType())) {
            this.validateTypeChange(oldFieldDescriptor, newFieldDescriptor);
        }
        if (oldFieldDescriptor.isRequired() && !newFieldDescriptor.isRequired()) {
            throw new MetaDataException("required field is no longer required", new Object[]{LogMessageKeys.FIELD_NAME, oldFieldDescriptor.getName()});
        }
        if (oldFieldDescriptor.isOptional() && !newFieldDescriptor.isOptional()) {
            throw new MetaDataException("optional field is no longer optional", new Object[]{LogMessageKeys.FIELD_NAME, oldFieldDescriptor.getName()});
        }
        if (oldFieldDescriptor.isRepeated() && !newFieldDescriptor.isRepeated()) {
            throw new MetaDataException("repeated field is no longer repeated", new Object[]{LogMessageKeys.FIELD_NAME, oldFieldDescriptor.getName()});
        }
        if (oldFieldDescriptor.getType().equals((Object)Descriptors.FieldDescriptor.Type.ENUM)) {
            this.validateEnum(newFieldDescriptor.getName(), oldFieldDescriptor.getEnumType(), newFieldDescriptor.getEnumType());
        }
        if (oldFieldDescriptor.getType().equals((Object)Descriptors.FieldDescriptor.Type.GROUP) || oldFieldDescriptor.getType().equals((Object)Descriptors.FieldDescriptor.Type.MESSAGE)) {
            Descriptors.Descriptor oldMessageType = oldFieldDescriptor.getMessageType();
            Descriptors.Descriptor newMessageType = newFieldDescriptor.getMessageType();
            this.validateMessage(oldMessageType, newMessageType, seenDescriptors);
        }
    }

    private void validateTypeChange(@Nonnull Descriptors.FieldDescriptor oldFieldDescriptor, @Nonnull Descriptors.FieldDescriptor newFieldDescriptor) {
        if (!(oldFieldDescriptor.getType().equals((Object)Descriptors.FieldDescriptor.Type.INT32) && newFieldDescriptor.getType().equals((Object)Descriptors.FieldDescriptor.Type.INT64) || oldFieldDescriptor.getType().equals((Object)Descriptors.FieldDescriptor.Type.SINT32) && newFieldDescriptor.getType().equals((Object)Descriptors.FieldDescriptor.Type.SINT64))) {
            throw new MetaDataException("field type changed", new Object[]{LogMessageKeys.FIELD_NAME, oldFieldDescriptor.getName(), LogMessageKeys.OLD_FIELD_TYPE, oldFieldDescriptor.getType(), LogMessageKeys.NEW_FIELD_TYPE, newFieldDescriptor.getType()});
        }
    }

    private void validateEnum(@Nonnull String fieldName, @Nonnull Descriptors.EnumDescriptor oldEnumDescriptor, @Nonnull Descriptors.EnumDescriptor newEnumDescriptor) {
        for (Descriptors.EnumValueDescriptor oldEnumValue : oldEnumDescriptor.getValues()) {
            Descriptors.EnumValueDescriptor newEnumValue = newEnumDescriptor.findValueByNumber(oldEnumValue.getNumber());
            if (newEnumValue != null) continue;
            throw new MetaDataException("enum removes value", new Object[]{LogMessageKeys.FIELD_NAME, fieldName});
        }
    }

    @Nonnull
    private Map<String, String> getTypeRenames(@Nonnull Descriptors.Descriptor oldUnionDescriptor, @Nonnull Descriptors.Descriptor newUnionDescriptor) {
        if (oldUnionDescriptor == newUnionDescriptor) {
            return Collections.emptyMap();
        }
        HashMap<String, String> renames = this.disallowTypeRenames ? Collections.emptyMap() : new HashMap<String, String>();
        for (Descriptors.FieldDescriptor oldField : oldUnionDescriptor.getFields()) {
            Descriptors.Descriptor oldRecord = oldField.getMessageType();
            Descriptors.Descriptor newRecord = newUnionDescriptor.findFieldByNumber(oldField.getNumber()).getMessageType();
            if (oldRecord.getName().equals(newRecord.getName())) continue;
            if (this.disallowTypeRenames) {
                throw new MetaDataException("record type name changed", new Object[]{LogMessageKeys.OLD_RECORD_TYPE, oldRecord.getName(), LogMessageKeys.NEW_RECORD_TYPE, newRecord.getName()});
            }
            String existingName = renames.putIfAbsent(oldRecord.getName(), newRecord.getName());
            if (existingName == null || existingName.equals(newRecord.getName())) continue;
            throw new MetaDataException("record type corresponds to multiple types in new meta-data", new Object[]{LogMessageKeys.OLD_RECORD_TYPE, oldRecord.getName(), LogMessageKeys.NEW_RECORD_TYPE, newRecord.getName() + " & " + existingName});
        }
        return renames;
    }

    private void validateRecordTypes(@Nonnull RecordMetaData oldMetaData, @Nonnull RecordMetaData newMetaData, @Nonnull Map<String, String> typeRenames) {
        Map<String, RecordType> oldRecordTypes = oldMetaData.getRecordTypes();
        Map<String, RecordType> newRecordTypes = newMetaData.getRecordTypes();
        for (Map.Entry<String, RecordType> oldRecordTypeEntry : oldRecordTypes.entrySet()) {
            String oldRecordTypeName = oldRecordTypeEntry.getKey();
            String newRecordTypeName = typeRenames.getOrDefault(oldRecordTypeName, oldRecordTypeName);
            if (!newRecordTypes.containsKey(newRecordTypeName)) {
                throw new MetaDataException("record type removed from meta-data", new Object[]{LogMessageKeys.OLD_RECORD_TYPE, oldRecordTypeName, LogMessageKeys.NEW_RECORD_TYPE, newRecordTypeName});
            }
            RecordType oldRecordType = oldRecordTypeEntry.getValue();
            RecordType newRecordType = newRecordTypes.get(newRecordTypeName);
            if (!Objects.equals(oldRecordType.getSinceVersion(), newRecordType.getSinceVersion())) {
                throw new MetaDataException("record type since version changed", new Object[]{LogMessageKeys.RECORD_TYPE, newRecordTypeName, LogMessageKeys.OLD_VERSION, oldRecordType.getSinceVersion(), LogMessageKeys.NEW_VERSION, newRecordType.getSinceVersion()});
            }
            if (!oldRecordType.getPrimaryKey().equals(newRecordType.getPrimaryKey())) {
                throw new MetaDataException("record type primary key changed", new Object[]{LogMessageKeys.RECORD_TYPE, newRecordTypeName, LogMessageKeys.OLD_KEY_EXPRESSION, oldRecordType.getPrimaryKey(), LogMessageKeys.NEW_KEY_EXPRESSION, newRecordType.getPrimaryKey()});
            }
            if (oldRecordType.getRecordTypeKey().equals(newRecordType.getRecordTypeKey())) continue;
            throw new MetaDataException("record type key changed", new Object[]{LogMessageKeys.RECORD_TYPE, newRecordTypeName});
        }
        HashSet olderRecordTypeNames = Sets.newHashSetWithExpectedSize(oldRecordTypes.size());
        oldRecordTypes.forEach((typeName, ignore) -> olderRecordTypeNames.add(typeRenames.getOrDefault(typeName, (String)typeName)));
        for (Map.Entry<String, RecordType> newRecordTypeEntry : newRecordTypes.entrySet()) {
            String recordTypeName = newRecordTypeEntry.getKey();
            if (olderRecordTypeNames.contains(recordTypeName)) continue;
            RecordType newRecordType = newRecordTypeEntry.getValue();
            Integer newSinceVersion = newRecordType.getSinceVersion();
            if (newSinceVersion == null) {
                if (this.allowNoSinceVersion) continue;
                throw new MetaDataException("new record type is missing since version", new Object[]{LogMessageKeys.RECORD_TYPE, recordTypeName});
            }
            if (newSinceVersion > oldMetaData.getVersion()) continue;
            throw new MetaDataException("new record type has since version older than old meta-data", new Object[]{LogMessageKeys.RECORD_TYPE, recordTypeName});
        }
    }

    @Nonnull
    private Map<Object, FormerIndex> getFormerIndexMap(@Nonnull RecordMetaData metaData) {
        Map<Object, FormerIndex> formerIndexMap;
        List<FormerIndex> formerIndexes = metaData.getFormerIndexes();
        if (formerIndexes.isEmpty()) {
            formerIndexMap = Collections.emptyMap();
        } else {
            formerIndexMap = new HashMap<Object, FormerIndex>(2 * formerIndexes.size());
            for (FormerIndex formerIndex : formerIndexes) {
                formerIndexMap.put(formerIndex.getSubspaceKey(), formerIndex);
            }
        }
        return formerIndexMap;
    }

    @Nonnull
    private Map<Object, Index> getIndexMap(@Nonnull RecordMetaData metaData) {
        Map<Object, Index> indexMap;
        List<Index> allIndexes = metaData.getAllIndexes();
        if (allIndexes.isEmpty()) {
            indexMap = Collections.emptyMap();
        } else {
            indexMap = new HashMap<Object, Index>(allIndexes.size() * 2);
            for (Index index : allIndexes) {
                indexMap.put(index.getSubspaceKey(), index);
            }
        }
        return indexMap;
    }

    private void validateCurrentAndFormerIndexes(@Nonnull RecordMetaData oldMetaData, @Nonnull RecordMetaData newMetaData, @Nonnull Map<String, String> typeRenames) {
        Index oldIndex;
        Object subspaceKey;
        Map<Object, FormerIndex> oldFormerIndexMap = this.getFormerIndexMap(oldMetaData);
        Map<Object, Index> oldIndexMap = this.getIndexMap(oldMetaData);
        Map<Object, FormerIndex> newFormerIndexMap = this.getFormerIndexMap(newMetaData);
        Map<Object, Index> newIndexMap = this.getIndexMap(newMetaData);
        for (Map.Entry<Object, FormerIndex> entry : oldFormerIndexMap.entrySet()) {
            subspaceKey = entry.getKey();
            if (newIndexMap.containsKey(subspaceKey)) {
                throw new MetaDataException("former index key used for new index in meta-data", new Object[]{LogMessageKeys.SUBSPACE_KEY, subspaceKey, LogMessageKeys.INDEX_NAME, newIndexMap.get(subspaceKey).getName()});
            }
            if (newFormerIndexMap.containsKey(subspaceKey)) continue;
            throw new MetaDataException("former index removed from meta-data", new Object[]{LogMessageKeys.SUBSPACE_KEY, subspaceKey});
        }
        for (Map.Entry<Object, Object> entry : oldIndexMap.entrySet()) {
            subspaceKey = entry.getKey();
            if (newIndexMap.containsKey(subspaceKey) || newFormerIndexMap.containsKey(subspaceKey)) continue;
            throw new MetaDataException("index missing in new meta-data", new Object[]{LogMessageKeys.SUBSPACE_KEY, subspaceKey, LogMessageKeys.INDEX_NAME, ((Index)entry.getValue()).getName()});
        }
        for (Map.Entry<Object, Object> entry : newFormerIndexMap.entrySet()) {
            subspaceKey = entry.getKey();
            FormerIndex newFormerIndex = (FormerIndex)entry.getValue();
            if (oldFormerIndexMap.containsKey(subspaceKey)) {
                FormerIndex oldFormerIndex = oldFormerIndexMap.get(subspaceKey);
                this.validateFormerIndex(subspaceKey, oldFormerIndex, newFormerIndex);
                continue;
            }
            if (newFormerIndex.getRemovedVersion() <= oldMetaData.getVersion()) {
                throw new MetaDataException("new former index has removed version that is not newer than the old meta-data version", new Object[]{LogMessageKeys.SUBSPACE_KEY, subspaceKey, LogMessageKeys.VERSION, newFormerIndex.getRemovedVersion()});
            }
            oldIndex = oldIndexMap.get(subspaceKey);
            if (oldIndex == null) {
                if (this.allowOlderFormerIndexAddedVersions || newFormerIndex.getAddedVersion() > oldMetaData.getVersion()) continue;
                throw new MetaDataException("former index without existing index has added version prior to old meta-data version", new Object[]{LogMessageKeys.SUBSPACE_KEY, subspaceKey, LogMessageKeys.OLD_VERSION, oldMetaData.getVersion(), LogMessageKeys.NEW_VERSION, newFormerIndex.getAddedVersion()});
            }
            this.validateFormerIndexFromIndex(subspaceKey, oldIndex, newFormerIndex);
        }
        for (Map.Entry<Object, Object> entry : newIndexMap.entrySet()) {
            subspaceKey = entry.getKey();
            Index newIndex = (Index)entry.getValue();
            if (oldIndexMap.containsKey(subspaceKey)) {
                oldIndex = oldIndexMap.get(subspaceKey);
                this.validateIndex(oldMetaData, oldIndex, newMetaData, newIndex, typeRenames);
                continue;
            }
            if (newIndex.getLastModifiedVersion() > oldMetaData.getVersion()) continue;
            throw new MetaDataException("new index has version that is not newer than the old meta-data version", new Object[]{LogMessageKeys.INDEX_NAME, newIndex.getName(), LogMessageKeys.VERSION, newIndex.getLastModifiedVersion()});
        }
    }

    private void validateFormerIndexFromIndex(@Nonnull Object subspaceKey, @Nonnull Index oldIndex, @Nonnull FormerIndex newFormerIndex) {
        if (!(this.allowMissingFormerIndexNames && newFormerIndex.getFormerName() == null || Objects.equals(newFormerIndex.getFormerName(), oldIndex.getName()))) {
            throw new MetaDataException("former index has different name than old index", new Object[]{LogMessageKeys.SUBSPACE_KEY, subspaceKey, LogMessageKeys.OLD_INDEX_NAME, oldIndex.getName(), LogMessageKeys.NEW_INDEX_NAME, newFormerIndex.getFormerName()});
        }
        if (newFormerIndex.getAddedVersion() > oldIndex.getAddedVersion()) {
            throw new MetaDataException("former index added after old index", new Object[]{LogMessageKeys.SUBSPACE_KEY, LogMessageKeys.INDEX_NAME, oldIndex.getName(), LogMessageKeys.OLD_VERSION, oldIndex.getAddedVersion(), LogMessageKeys.NEW_VERSION, newFormerIndex.getAddedVersion()});
        }
        if (!this.allowOlderFormerIndexAddedVersions && newFormerIndex.getAddedVersion() != oldIndex.getAddedVersion()) {
            throw new MetaDataException("former index reports added version older than replacing index", new Object[]{LogMessageKeys.SUBSPACE_KEY, subspaceKey, LogMessageKeys.INDEX_NAME, oldIndex.getName(), LogMessageKeys.OLD_VERSION, oldIndex.getAddedVersion(), LogMessageKeys.NEW_VERSION, newFormerIndex.getAddedVersion()});
        }
        if (newFormerIndex.getRemovedVersion() <= oldIndex.getLastModifiedVersion()) {
            throw new MetaDataException("former index removed before old index's last modification", new Object[]{LogMessageKeys.SUBSPACE_KEY, subspaceKey, LogMessageKeys.INDEX_NAME, oldIndex.getName(), LogMessageKeys.OLD_VERSION, oldIndex.getLastModifiedVersion(), LogMessageKeys.NEW_VERSION, newFormerIndex.getRemovedVersion()});
        }
    }

    private void validateFormerIndex(@Nonnull Object subspaceKey, @Nonnull FormerIndex oldFormerIndex, @Nonnull FormerIndex newFormerIndex) {
        if (oldFormerIndex.getRemovedVersion() != newFormerIndex.getRemovedVersion()) {
            throw new MetaDataException("removed version of former index differs from prior version", new Object[]{LogMessageKeys.SUBSPACE_KEY, subspaceKey, LogMessageKeys.OLD_VERSION, oldFormerIndex.getRemovedVersion(), LogMessageKeys.NEW_VERSION, newFormerIndex.getRemovedVersion()});
        }
        if (oldFormerIndex.getAddedVersion() != newFormerIndex.getAddedVersion()) {
            throw new MetaDataException("added version of former index differs from prior version", new Object[]{LogMessageKeys.SUBSPACE_KEY, subspaceKey, LogMessageKeys.OLD_VERSION, oldFormerIndex.getAddedVersion(), LogMessageKeys.NEW_VERSION, newFormerIndex.getAddedVersion()});
        }
        if (!Objects.equals(oldFormerIndex.getFormerName(), newFormerIndex.getFormerName())) {
            throw new MetaDataException("name of former index differs from prior version", new Object[]{LogMessageKeys.SUBSPACE_KEY, subspaceKey, LogMessageKeys.OLD_INDEX_NAME, oldFormerIndex.getFormerName(), LogMessageKeys.NEW_INDEX_NAME, newFormerIndex.getFormerName()});
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void validateIndex(@Nonnull RecordMetaData oldMetaData, @Nonnull Index oldIndex, @Nonnull RecordMetaData newMetaData, @Nonnull Index newIndex, @Nonnull Map<String, String> typeRenames) {
        if (!oldIndex.getName().equals(newIndex.getName())) {
            throw new MetaDataException("index name changed", new Object[]{LogMessageKeys.OLD_INDEX_NAME, oldIndex.getName(), LogMessageKeys.NEW_INDEX_NAME, newIndex.getName()});
        }
        if (oldIndex.getAddedVersion() != newIndex.getAddedVersion()) {
            throw new MetaDataException("new index added version does not match old index added version", new Object[]{LogMessageKeys.INDEX_NAME, newIndex.getName(), LogMessageKeys.OLD_VERSION, oldIndex.getAddedVersion(), LogMessageKeys.NEW_VERSION, newIndex.getAddedVersion()});
        }
        if (oldIndex.getLastModifiedVersion() > newIndex.getLastModifiedVersion()) {
            throw new MetaDataException("old index has last-modified version newer than new index", new Object[]{LogMessageKeys.INDEX_NAME, newIndex.getName(), LogMessageKeys.OLD_VERSION, oldIndex.getLastModifiedVersion(), LogMessageKeys.NEW_VERSION, newIndex.getLastModifiedVersion()});
        }
        if (!this.allowIndexRebuilds && oldIndex.getLastModifiedVersion() != newIndex.getLastModifiedVersion()) {
            throw new MetaDataException("last modified version of index changed", new Object[]{LogMessageKeys.INDEX_NAME, newIndex.getName(), LogMessageKeys.OLD_VERSION, oldIndex.getLastModifiedVersion(), LogMessageKeys.NEW_VERSION, newIndex.getLastModifiedVersion()});
        }
        if (this.allowIndexRebuilds && oldIndex.getLastModifiedVersion() < newIndex.getLastModifiedVersion()) {
            return;
        }
        if (!oldIndex.getType().equals(newIndex.getType())) {
            throw new MetaDataException("index type changed", new Object[]{LogMessageKeys.INDEX_NAME, newIndex.getName(), LogMessageKeys.OLD_INDEX_TYPE, oldIndex.getType(), LogMessageKeys.NEW_INDEX_TYPE, newIndex.getType()});
        }
        if (!oldIndex.getRootExpression().equals(newIndex.getRootExpression())) {
            throw new MetaDataException("index key expression changed", new Object[]{LogMessageKeys.INDEX_NAME, newIndex.getName(), LogMessageKeys.OLD_KEY_EXPRESSION, oldIndex.getRootExpression(), LogMessageKeys.NEW_KEY_EXPRESSION, newIndex.getRootExpression()});
        }
        Set oldRecordTypeNames = oldMetaData.recordTypesForIndex(oldIndex).stream().map(recordType -> typeRenames.getOrDefault(recordType.getName(), recordType.getName())).collect(Collectors.toSet());
        Set newRecordTypeNames = newMetaData.recordTypesForIndex(newIndex).stream().map(RecordType::getName).collect(Collectors.toSet());
        for (String oldRecordTypeName : oldRecordTypeNames) {
            if (newRecordTypeNames.contains(oldRecordTypeName)) continue;
            throw new MetaDataException("new index removes record type", new Object[]{LogMessageKeys.INDEX_NAME, newIndex.getName(), LogMessageKeys.RECORD_TYPE, oldRecordTypeName});
        }
        for (String newRecordTypeName : newRecordTypeNames) {
            RecordType newRecordType;
            Integer sinceVersion;
            if (oldRecordTypeNames.contains(newRecordTypeName) || (sinceVersion = (newRecordType = newMetaData.getRecordType(newRecordTypeName)).getSinceVersion()) != null && newRecordType.getSinceVersion() > oldMetaData.getVersion()) continue;
            throw new MetaDataException("new index adds record type that is not newer than old meta-data", new Object[]{LogMessageKeys.INDEX_NAME, newIndex.getName(), LogMessageKeys.RECORD_TYPE, newRecordTypeName});
        }
        if (oldIndex.hasPrimaryKeyComponentPositions()) {
            int[] newPositions;
            if (!newIndex.hasPrimaryKeyComponentPositions()) throw new MetaDataException("new index drops primary key component positions", new Object[]{LogMessageKeys.INDEX_NAME, newIndex.getName()});
            int[] oldPositions = oldIndex.getPrimaryKeyComponentPositions();
            if (!Arrays.equals(oldPositions, newPositions = newIndex.getPrimaryKeyComponentPositions())) {
                throw new MetaDataException("new index changes primary key component positions", new Object[]{LogMessageKeys.INDEX_NAME, newIndex.getName()});
            }
        } else if (newIndex.hasPrimaryKeyComponentPositions()) {
            throw new MetaDataException("new index adds primary key component positions", new Object[]{LogMessageKeys.INDEX_NAME, newIndex.getName()});
        }
        if (oldIndex.getOptions().equals(newIndex.getOptions())) return;
        IndexValidator validatorForIndex = this.indexValidatorRegistry.getIndexValidator(newIndex);
        validatorForIndex.validateChangedOptions(oldIndex);
    }

    @Nonnull
    public IndexValidatorRegistry getIndexValidatorRegistry() {
        return this.indexValidatorRegistry;
    }

    public boolean allowsNoVersionChange() {
        return this.allowNoVersionChange;
    }

    public boolean allowsNoSinceVersion() {
        return this.allowNoSinceVersion;
    }

    public boolean allowsIndexRebuilds() {
        return this.allowIndexRebuilds;
    }

    public boolean allowsMissingFormerIndexNames() {
        return this.allowMissingFormerIndexNames;
    }

    public boolean allowsOlderFormerIndexAddedVersions() {
        return this.allowOlderFormerIndexAddedVersions;
    }

    public boolean allowsUnsplitToSplit() {
        return this.allowUnsplitToSplit;
    }

    public boolean disallowsTypeRenames() {
        return this.disallowTypeRenames;
    }

    @Nonnull
    public Builder asBuilder() {
        return new Builder(this);
    }

    @Nonnull
    public static Builder newBuilder() {
        return new Builder(DEFAULT_INSTANCE);
    }

    @Nonnull
    public static MetaDataEvolutionValidator getDefaultInstance() {
        return DEFAULT_INSTANCE;
    }

    public static class Builder {
        @Nonnull
        private IndexValidatorRegistry indexValidatorRegistry;
        private boolean allowNoVersionChange;
        private boolean allowNoSinceVersion;
        private boolean allowIndexRebuilds;
        private boolean allowMissingFormerIndexNames;
        private boolean allowOlderFormerIndexAddedVersions;
        private boolean allowUnsplitToSplit;
        private boolean disallowTypeRenames;

        private Builder(@Nonnull MetaDataEvolutionValidator validator) {
            this.indexValidatorRegistry = validator.indexValidatorRegistry;
            this.allowNoVersionChange = validator.allowNoVersionChange;
            this.allowNoSinceVersion = validator.allowNoSinceVersion;
            this.allowIndexRebuilds = validator.allowIndexRebuilds;
            this.allowMissingFormerIndexNames = validator.allowMissingFormerIndexNames;
            this.allowOlderFormerIndexAddedVersions = validator.allowOlderFormerIndexAddedVersions;
            this.allowUnsplitToSplit = validator.allowUnsplitToSplit;
            this.disallowTypeRenames = validator.disallowTypeRenames;
        }

        @Nonnull
        public Builder setIndexValidatorRegistry(@Nonnull IndexMaintainerRegistry indexValidatorRegistry) {
            this.indexValidatorRegistry = indexValidatorRegistry;
            return this;
        }

        @Nonnull
        public IndexValidatorRegistry getIndexValidatorRegistry() {
            return this.indexValidatorRegistry;
        }

        @Nonnull
        public Builder setAllowNoVersionChange(boolean allowNoVersionChange) {
            this.allowNoVersionChange = allowNoVersionChange;
            return this;
        }

        public boolean allowsNoVersionChange() {
            return this.allowNoVersionChange;
        }

        @Nonnull
        public Builder setAllowNoSinceVersion(boolean allowNoSinceVersion) {
            this.allowNoSinceVersion = allowNoSinceVersion;
            return this;
        }

        public boolean allowsNoSinceVersion() {
            return this.allowNoSinceVersion;
        }

        @Nonnull
        public Builder setAllowIndexRebuilds(boolean allowIndexRebuilds) {
            this.allowIndexRebuilds = allowIndexRebuilds;
            return this;
        }

        public boolean allowsIndexRebuilds() {
            return this.allowIndexRebuilds;
        }

        @Nonnull
        public Builder setAllowMissingFormerIndexNames(boolean allowMissingFormerIndexNames) {
            this.allowMissingFormerIndexNames = allowMissingFormerIndexNames;
            return this;
        }

        public boolean allowsMissingFormerIndexNames() {
            return this.allowMissingFormerIndexNames;
        }

        @Nonnull
        public Builder setAllowOlderFormerIndexAddedVerions(boolean allowOlderFormerIndexAddedVerions) {
            this.allowOlderFormerIndexAddedVersions = allowOlderFormerIndexAddedVerions;
            return this;
        }

        public boolean allowsOlderFormerIndexAddedVersions() {
            return this.allowOlderFormerIndexAddedVersions;
        }

        @Nonnull
        public Builder setAllowUnsplitToSplit(boolean allowUnsplitToSplit) {
            this.allowUnsplitToSplit = allowUnsplitToSplit;
            return this;
        }

        public boolean allowsUnsplitToSplit() {
            return this.allowUnsplitToSplit;
        }

        @Nonnull
        public Builder setDisallowTypeRenames(boolean disallowTypeRenames) {
            this.disallowTypeRenames = disallowTypeRenames;
            return this;
        }

        public boolean disallowsTypeRenames() {
            return this.disallowTypeRenames;
        }

        @Nonnull
        public MetaDataEvolutionValidator build() {
            return new MetaDataEvolutionValidator(this);
        }
    }
}

