/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record.metadata;

import com.apple.foundationdb.annotation.API;
import com.apple.foundationdb.record.RecordMetaData;
import com.apple.foundationdb.record.RecordMetaDataProvider;
import com.apple.foundationdb.record.metadata.FormerIndex;
import com.apple.foundationdb.record.metadata.Index;
import com.apple.foundationdb.record.metadata.IndexValidator;
import com.apple.foundationdb.record.metadata.IndexValidatorRegistry;
import com.apple.foundationdb.record.metadata.MetaDataException;
import com.apple.foundationdb.record.metadata.RecordType;
import com.apple.foundationdb.record.metadata.expressions.KeyExpression;
import com.google.protobuf.Descriptors;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;

@API(value=API.Status.UNSTABLE)
public class MetaDataValidator
implements RecordMetaDataProvider {
    @Nonnull
    protected final RecordMetaData metaData;
    @Nonnull
    protected final IndexValidatorRegistry indexRegistry;
    @Nonnull
    protected final Map<Object, Index> assignedPrefixes;
    @Nonnull
    protected final Map<Object, FormerIndex> assignedFormerPrefixes;
    @Nonnull
    protected final Map<Object, RecordType> recordTypeKeys;

    public MetaDataValidator(@Nonnull RecordMetaDataProvider metaData, @Nonnull IndexValidatorRegistry indexRegistry) {
        this.metaData = metaData.getRecordMetaData();
        this.indexRegistry = indexRegistry;
        this.assignedPrefixes = new HashMap<Object, Index>();
        this.assignedFormerPrefixes = new HashMap<Object, FormerIndex>();
        this.recordTypeKeys = new HashMap<Object, RecordType>();
    }

    public void validate() {
        this.validateUnionDescriptor(this.metaData.getUnionDescriptor());
        if (this.metaData.getRecordTypes().isEmpty()) {
            throw new MetaDataException("No record types defined in meta-data", new Object[0]);
        }
        this.metaData.getRecordTypes().values().forEach(this::validateRecordType);
        this.validateCurrentAndFormerIndexes();
    }

    protected void validateUnionDescriptor(Descriptors.Descriptor unionDescriptor) {
        List<Descriptors.OneofDescriptor> oneofs = unionDescriptor.getOneofs();
        if (!oneofs.isEmpty()) {
            if (oneofs.size() > 1) {
                throw new MetaDataException("Union descriptor has more than one oneof", new Object[0]);
            }
            if (oneofs.get(0).getFieldCount() != unionDescriptor.getFields().size()) {
                throw new MetaDataException("Union descriptor oneof must contain every field", new Object[0]);
            }
        }
    }

    protected void validateRecordType(@Nonnull RecordType recordType) {
        this.metaData.getUnionFieldForRecordType(recordType);
        this.validatePrimaryKeyForRecordType(recordType.getPrimaryKey(), recordType);
        RecordType otherRecordType = this.recordTypeKeys.put(recordType.getRecordTypeKey(), recordType);
        if (otherRecordType != null) {
            throw new MetaDataException("Same record type key " + String.valueOf(recordType.getRecordTypeKey()) + " used by both " + recordType.getName() + " and " + otherRecordType.getName(), new Object[0]);
        }
        if (recordType.getSinceVersion() != null && recordType.getSinceVersion() > this.metaData.getVersion()) {
            throw new MetaDataException("Record type " + recordType.getName() + " has since version of " + recordType.getSinceVersion() + " which is greater than the meta-data version " + this.metaData.getVersion(), new Object[0]);
        }
    }

    protected void validatePrimaryKeyForRecordType(@Nonnull KeyExpression primaryKey, @Nonnull RecordType recordType) {
        primaryKey.validate(recordType.getDescriptor());
        if (primaryKey.createsDuplicates()) {
            throw new MetaDataException("Primary key for " + recordType.getName() + " can generate more than one entry", new Object[0]);
        }
    }

    protected void validateCurrentAndFormerIndexes() {
        this.metaData.getAllIndexes().forEach(this::validateIndex);
        this.metaData.getFormerIndexes().forEach(this::validateFormerIndex);
        for (Map.Entry<Object, Index> assignedPrefixEntry : this.assignedPrefixes.entrySet()) {
            Object indexSubspaceKey = assignedPrefixEntry.getKey();
            FormerIndex formerIndex = this.assignedFormerPrefixes.get(indexSubspaceKey);
            if (formerIndex == null) continue;
            throw new MetaDataException("Same subspace key " + String.valueOf(indexSubspaceKey) + " used by index " + assignedPrefixEntry.getValue().getName() + " and former index" + (String)(formerIndex.getFormerName() == null ? "" : " " + formerIndex.getFormerName()), new Object[0]);
        }
    }

    protected void validateIndex(@Nonnull Index index) {
        this.indexRegistry.getIndexValidator(index).validate(this);
        Index otherIndex = this.assignedPrefixes.put(index.getSubspaceKey(), index);
        if (otherIndex != null) {
            throw new MetaDataException("Same subspace key " + String.valueOf(index.getSubspaceKey()) + " used by both " + index.getName() + " and " + otherIndex.getName(), new Object[0]);
        }
        if (index.getAddedVersion() > this.metaData.getVersion()) {
            throw new MetaDataException("Index " + index.getName() + " has added version " + index.getAddedVersion() + " which is greater than the meta-data version " + this.metaData.getVersion(), new Object[0]);
        }
        if (index.getLastModifiedVersion() > this.metaData.getVersion()) {
            throw new MetaDataException("Index " + index.getName() + " has last modified version " + index.getLastModifiedVersion() + " which is greater than the meta-data version " + this.metaData.getVersion(), new Object[0]);
        }
        List<String> replacementIndexNames = index.getReplacedByIndexNames();
        if (!replacementIndexNames.isEmpty()) {
            for (String replacementIndexName : replacementIndexNames) {
                if (this.metaData.hasIndex(replacementIndexName)) {
                    Index replacementIndex = this.metaData.getIndex(replacementIndexName);
                    if (replacementIndex.getReplacedByIndexNames().isEmpty()) continue;
                    throw new MetaDataException("Index " + index.getName() + " has replacement index " + replacementIndexName + " that itself has replacement indexes", new Object[0]);
                }
                throw new MetaDataException("Index " + index.getName() + " has replacement index " + replacementIndexName + " that is not in the meta-data", new Object[0]);
            }
        }
    }

    protected void validateFormerIndex(@Nonnull FormerIndex formerIndex) {
        FormerIndex otherFormerIndex = this.assignedFormerPrefixes.put(formerIndex.getSubspaceKey(), formerIndex);
        if (otherFormerIndex != null) {
            String indexNameString = (formerIndex.getFormerName() == null ? "<unknown>" : formerIndex.getFormerName()) + " and " + (otherFormerIndex.getFormerName() == null ? "<unknown>" : otherFormerIndex.getFormerName());
            throw new MetaDataException("Same subspace key " + String.valueOf(formerIndex.getSubspaceKey()) + " used by two former indexes " + indexNameString, new Object[0]);
        }
        if (formerIndex.getAddedVersion() > formerIndex.getRemovedVersion()) {
            throw new MetaDataException("Former index" + (String)(formerIndex.getFormerName() == null ? "" : " " + formerIndex.getFormerName()) + " has added version " + formerIndex.getAddedVersion() + " which is greater than the removed version " + formerIndex.getRemovedVersion(), new Object[0]);
        }
        if (formerIndex.getAddedVersion() > this.metaData.getVersion()) {
            throw new MetaDataException("Former index" + (String)(formerIndex.getFormerName() == null ? "" : " " + formerIndex.getFormerName()) + " has added version " + formerIndex.getAddedVersion() + " which is greater than the meta-data version " + this.metaData.getVersion(), new Object[0]);
        }
        if (formerIndex.getRemovedVersion() > this.metaData.getVersion()) {
            throw new MetaDataException("Former index" + (String)(formerIndex.getFormerName() == null ? "" : " " + formerIndex.getFormerName()) + " has removed version " + formerIndex.getRemovedVersion() + " which is greater than the meta-data version " + this.metaData.getVersion(), new Object[0]);
        }
    }

    public void validateIndexForRecordTypes(@Nonnull Index index, @Nonnull IndexValidator indexValidator) {
        for (RecordType recordType : this.metaData.recordTypesForIndex(index)) {
            indexValidator.validateIndexForRecordType(recordType, this);
        }
    }

    @Nonnull
    public List<Descriptors.FieldDescriptor> validateIndexForRecordType(@Nonnull Index index, @Nonnull RecordType recordType) {
        return index.validate(recordType.getDescriptor());
    }

    @Override
    @Nonnull
    public RecordMetaData getRecordMetaData() {
        return this.metaData;
    }
}

