/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record.metadata;

import com.apple.foundationdb.annotation.API;
import com.apple.foundationdb.record.RecordMetaData;
import com.apple.foundationdb.record.RecordMetaDataProvider;
import com.apple.foundationdb.record.metadata.Index;
import com.apple.foundationdb.record.metadata.Key;
import com.apple.foundationdb.record.metadata.MetaDataException;
import com.apple.foundationdb.record.metadata.RecordTypeOrBuilder;
import com.apple.foundationdb.record.metadata.TupleTypeUtil;
import com.apple.foundationdb.record.metadata.expressions.KeyExpression;
import com.apple.foundationdb.tuple.Tuple;
import com.google.protobuf.Descriptors;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@API(value=API.Status.UNSTABLE)
public class RecordType
implements RecordTypeOrBuilder,
RecordMetaDataProvider {
    @Nonnull
    private final RecordMetaData metaData;
    @Nonnull
    private final String name;
    @Nonnull
    private final Descriptors.Descriptor descriptor;
    @Nonnull
    private final KeyExpression primaryKey;
    @Nonnull
    private final List<Index> indexes;
    @Nonnull
    private final List<Index> multiTypeIndexes;
    @Nullable
    private final Integer sinceVersion;
    @Nullable
    private final Object explicitRecordTypeKey;
    @Nullable
    private Object recordTypeKey;
    @Nullable
    private Tuple recordTypeKeyTuple = null;

    public RecordType(@Nonnull RecordMetaData metaData, @Nonnull Descriptors.Descriptor descriptor, @Nonnull KeyExpression primaryKey, @Nonnull List<Index> indexes, @Nonnull List<Index> multiTypeIndexes, @Nullable Integer sinceVersion, @Nullable Object recordTypeKey) {
        this.metaData = metaData;
        this.descriptor = descriptor;
        this.primaryKey = primaryKey;
        this.name = descriptor.getName();
        this.indexes = indexes;
        this.multiTypeIndexes = multiTypeIndexes;
        this.sinceVersion = sinceVersion;
        this.recordTypeKey = this.explicitRecordTypeKey = TupleTypeUtil.toTupleEquivalentValue(recordTypeKey);
    }

    @Override
    @Nonnull
    public String getName() {
        return this.name;
    }

    @Override
    @Nonnull
    public Descriptors.Descriptor getDescriptor() {
        return this.descriptor;
    }

    @Override
    @Nonnull
    public List<Index> getIndexes() {
        return this.indexes;
    }

    @Override
    @Nonnull
    public List<Index> getMultiTypeIndexes() {
        return this.multiTypeIndexes;
    }

    @Nonnull
    public List<Index> getAllIndexes() {
        ArrayList<Index> allIndexes = new ArrayList<Index>();
        allIndexes.addAll(this.getIndexes());
        allIndexes.addAll(this.getMultiTypeIndexes());
        allIndexes.addAll(this.getRecordMetaData().getUniversalIndexes());
        return allIndexes;
    }

    @Override
    @Nonnull
    public KeyExpression getPrimaryKey() {
        return this.primaryKey;
    }

    @Override
    @Nullable
    public Integer getSinceVersion() {
        return this.sinceVersion;
    }

    public boolean hasExplicitRecordTypeKey() {
        return this.explicitRecordTypeKey != null;
    }

    @Nullable
    public Object getExplicitRecordTypeKey() {
        return this.explicitRecordTypeKey;
    }

    @Override
    @Nonnull
    public Object getRecordTypeKey() {
        if (this.recordTypeKey == null) {
            this.recordTypeKey = TupleTypeUtil.toTupleEquivalentValue(this.metaData.getUnionDescriptor().getFields().stream().filter(f -> f.getJavaType() == Descriptors.FieldDescriptor.JavaType.MESSAGE && f.getMessageType() == this.descriptor).min(Comparator.comparing(Descriptors.FieldDescriptor::getNumber)).orElseThrow(() -> new MetaDataException("no matching fields in union", new Object[0])).getNumber());
        }
        return this.recordTypeKey;
    }

    @Nonnull
    public Tuple getRecordTypeKeyTuple() {
        if (this.recordTypeKeyTuple == null) {
            this.recordTypeKeyTuple = Tuple.from(TupleTypeUtil.toTupleAppropriateValue(this.getRecordTypeKey()));
        }
        return this.recordTypeKeyTuple;
    }

    public boolean primaryKeyHasRecordTypePrefix() {
        return Key.Expressions.hasRecordTypePrefix(this.primaryKey);
    }

    @Override
    @Nonnull
    public RecordMetaData getRecordMetaData() {
        return this.metaData;
    }

    @API(value=API.Status.EXPERIMENTAL)
    public boolean isSynthetic() {
        return false;
    }

    public String toString() {
        StringBuilder str = new StringBuilder();
        str.append("RecordType {'").append(this.name).append("'");
        str.append(", ").append(this.primaryKey);
        str.append("}");
        if (this.explicitRecordTypeKey != null) {
            str.append("#").append(this.explicitRecordTypeKey);
        }
        return str.toString();
    }
}

