/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record.metadata;

import com.apple.foundationdb.annotation.API;
import com.apple.foundationdb.record.RecordMetaData;
import com.apple.foundationdb.record.metadata.MetaDataException;
import com.apple.foundationdb.record.metadata.RecordType;
import com.apple.foundationdb.record.metadata.RecordTypeIndexesBuilder;
import com.apple.foundationdb.record.metadata.RecordTypeOrBuilder;
import com.apple.foundationdb.record.metadata.expressions.KeyExpression;
import com.google.protobuf.Descriptors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@API(value=API.Status.UNSTABLE)
public class RecordTypeBuilder
extends RecordTypeIndexesBuilder
implements RecordTypeOrBuilder {
    @Nonnull
    private final Descriptors.Descriptor descriptor;
    @Nullable
    private KeyExpression primaryKey;
    @Nullable
    private Integer sinceVersion;

    public RecordTypeBuilder(@Nonnull Descriptors.Descriptor descriptor) {
        super(descriptor.getName());
        this.descriptor = descriptor;
    }

    public RecordTypeBuilder(@Nonnull Descriptors.Descriptor descriptor, @Nonnull RecordTypeBuilder other) {
        super(descriptor.getName(), other);
        this.descriptor = descriptor;
        this.primaryKey = other.primaryKey;
        this.sinceVersion = other.sinceVersion;
    }

    @Override
    public RecordTypeBuilder setRecordTypeKey(@Nullable Object recordTypeKey) {
        super.setRecordTypeKey(recordTypeKey);
        return this;
    }

    @Override
    @Nonnull
    public Descriptors.Descriptor getDescriptor() {
        return this.descriptor;
    }

    @Override
    @Nullable
    public KeyExpression getPrimaryKey() {
        return this.primaryKey;
    }

    public void setPrimaryKey(@Nonnull KeyExpression primaryKey) {
        if (primaryKey.versionColumns() != 0) {
            throw new MetaDataException("Version in primary key not supported", new Object[0]);
        }
        this.primaryKey = primaryKey;
    }

    @Override
    @Nullable
    public Integer getSinceVersion() {
        return this.sinceVersion;
    }

    public void setSinceVersion(@Nullable Integer sinceVersion) {
        this.sinceVersion = sinceVersion;
    }

    public RecordType build(@Nonnull RecordMetaData metaData) {
        if (this.primaryKey == null) {
            throw new NonbuildableException("Missing primary key");
        }
        return new RecordType(metaData, this.descriptor, this.primaryKey, this.indexes, this.multiTypeIndexes, this.sinceVersion, this.recordTypeKey);
    }

    public static class NonbuildableException
    extends IllegalStateException {
        public NonbuildableException(String s2) {
            super(s2);
        }
    }
}

