/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record.metadata;

import com.apple.foundationdb.record.metadata.Index;
import com.apple.foundationdb.record.metadata.MetaDataException;
import com.apple.foundationdb.record.metadata.TupleTypeUtil;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public abstract class RecordTypeIndexesBuilder {
    @Nonnull
    protected final String name;
    @Nonnull
    protected final List<Index> indexes;
    @Nonnull
    protected final List<Index> multiTypeIndexes;
    @Nullable
    protected Object recordTypeKey;

    protected RecordTypeIndexesBuilder(@Nonnull String name) {
        this.name = name;
        this.indexes = new ArrayList<Index>();
        this.multiTypeIndexes = new ArrayList<Index>();
    }

    protected RecordTypeIndexesBuilder(@Nonnull String name, @Nonnull RecordTypeIndexesBuilder other) {
        this.name = name;
        this.indexes = new ArrayList<Index>(other.indexes);
        this.multiTypeIndexes = new ArrayList<Index>(other.multiTypeIndexes);
        this.recordTypeKey = other.recordTypeKey;
    }

    @Nonnull
    public String getName() {
        return this.name;
    }

    @Nonnull
    public List<Index> getIndexes() {
        return this.indexes;
    }

    @Nonnull
    public List<Index> getMultiTypeIndexes() {
        return this.multiTypeIndexes;
    }

    @Nullable
    public Object getRecordTypeKey() {
        return this.recordTypeKey;
    }

    public RecordTypeIndexesBuilder setRecordTypeKey(@Nullable Object recordTypeKey) {
        if (!(recordTypeKey == null || recordTypeKey instanceof Number || recordTypeKey instanceof Boolean || recordTypeKey instanceof String || recordTypeKey instanceof byte[])) {
            throw new MetaDataException("Only primitive types are allowed as record type key", new Object[0]);
        }
        this.recordTypeKey = TupleTypeUtil.toTupleEquivalentValue(recordTypeKey);
        return this;
    }
}

