/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record.metadata;

import com.apple.foundationdb.annotation.API;
import com.apple.foundationdb.record.RecordMetaData;
import com.apple.foundationdb.record.metadata.Index;
import com.apple.foundationdb.record.metadata.RecordType;
import com.apple.foundationdb.record.metadata.expressions.KeyExpression;
import com.apple.foundationdb.record.provider.foundationdb.FDBRecordStore;
import com.apple.foundationdb.record.provider.foundationdb.FDBSyntheticRecord;
import com.apple.foundationdb.record.provider.foundationdb.IndexOrphanBehavior;
import com.apple.foundationdb.tuple.Tuple;
import com.google.protobuf.Descriptors;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import javax.annotation.Nonnull;

@API(value=API.Status.EXPERIMENTAL)
public abstract class SyntheticRecordType<C extends Constituent>
extends RecordType {
    @Nonnull
    private final List<C> constituents;

    protected SyntheticRecordType(@Nonnull RecordMetaData metaData, @Nonnull Descriptors.Descriptor descriptor, @Nonnull KeyExpression primaryKey, @Nonnull Object recordTypeKey, @Nonnull List<Index> indexes, @Nonnull List<Index> multiTypeIndexes, @Nonnull List<C> constituents) {
        super(metaData, descriptor, primaryKey, indexes, multiTypeIndexes, null, recordTypeKey);
        this.constituents = constituents;
    }

    @Nonnull
    public List<C> getConstituents() {
        return this.constituents;
    }

    @Override
    public boolean isSynthetic() {
        return true;
    }

    @Nonnull
    @API(value=API.Status.INTERNAL)
    public CompletableFuture<FDBSyntheticRecord> loadByPrimaryKeyAsync(FDBRecordStore store, Tuple primaryKey) {
        return this.loadByPrimaryKeyAsync(store, primaryKey, IndexOrphanBehavior.ERROR);
    }

    @Nonnull
    @API(value=API.Status.INTERNAL)
    public abstract CompletableFuture<FDBSyntheticRecord> loadByPrimaryKeyAsync(FDBRecordStore var1, Tuple var2, IndexOrphanBehavior var3);

    @Override
    public String toString() {
        StringBuilder str = new StringBuilder();
        str.append(this.getClass().getSimpleName()).append(" {'").append(this.getName()).append("'");
        for (Constituent constituent : this.constituents) {
            str.append(", ").append(constituent.getName()).append(":").append(constituent.getRecordType().getName());
        }
        return str.toString();
    }

    public static class Constituent {
        @Nonnull
        private final String name;
        @Nonnull
        private final RecordType recordType;

        protected Constituent(@Nonnull String name, @Nonnull RecordType recordType) {
            this.name = name;
            this.recordType = recordType;
        }

        @Nonnull
        public String getName() {
            return this.name;
        }

        @Nonnull
        public RecordType getRecordType() {
            return this.recordType;
        }
    }
}

