/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record.metadata;

import com.apple.foundationdb.annotation.API;
import com.apple.foundationdb.record.RecordMetaData;
import com.apple.foundationdb.record.RecordMetaDataBuilder;
import com.apple.foundationdb.record.metadata.Key;
import com.apple.foundationdb.record.metadata.RecordTypeBuilder;
import com.apple.foundationdb.record.metadata.RecordTypeIndexesBuilder;
import com.apple.foundationdb.record.metadata.SyntheticRecordType;
import com.apple.foundationdb.record.metadata.expressions.KeyExpression;
import com.google.protobuf.DescriptorProtos;
import com.google.protobuf.Descriptors;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@API(value=API.Status.EXPERIMENTAL)
public abstract class SyntheticRecordTypeBuilder<C extends Constituent>
extends RecordTypeIndexesBuilder {
    @Nonnull
    private final RecordMetaDataBuilder metaDataBuilder;
    @Nonnull
    private final List<C> constituents = new ArrayList<C>();

    protected SyntheticRecordTypeBuilder(@Nonnull String name, @Nonnull Object recordTypeKey, @Nonnull RecordMetaDataBuilder metaDataBuilder) {
        super(name);
        this.recordTypeKey = recordTypeKey;
        this.metaDataBuilder = metaDataBuilder;
    }

    @Override
    public SyntheticRecordTypeBuilder<C> setRecordTypeKey(@Nullable Object recordTypeKey) {
        super.setRecordTypeKey(recordTypeKey);
        return this;
    }

    @Nonnull
    public List<C> getConstituents() {
        return this.constituents;
    }

    @Nonnull
    protected abstract C newConstituent(@Nonnull String var1, @Nonnull RecordTypeBuilder var2);

    @Nonnull
    protected C addConstituent(@Nonnull C constituent) {
        this.constituents.add(constituent);
        return constituent;
    }

    @Nonnull
    public C addConstituent(@Nonnull String name, @Nonnull RecordTypeBuilder recordType) {
        return this.addConstituent(this.newConstituent(name, recordType));
    }

    @Nonnull
    public C addConstituent(@Nonnull String name, @Nonnull String recordType) {
        return this.addConstituent(name, this.metaDataBuilder.getRecordType(recordType));
    }

    @Nonnull
    public C addConstituent(@Nonnull RecordTypeBuilder recordType) {
        return this.addConstituent(recordType.getName(), recordType);
    }

    @Nonnull
    protected C addConstituent(@Nonnull String constituent) {
        return this.addConstituent(constituent, constituent);
    }

    @Nonnull
    public abstract SyntheticRecordType<?> build(@Nonnull RecordMetaData var1, @Nonnull Descriptors.FileDescriptor var2);

    @API(value=API.Status.INTERNAL)
    public void buildDescriptor(@Nonnull DescriptorProtos.FileDescriptorProto.Builder fileDescriptorProto, @Nonnull Set<Descriptors.FileDescriptor> sources) {
        DescriptorProtos.DescriptorProto.Builder descriptorProto = fileDescriptorProto.addMessageTypeBuilder();
        descriptorProto.setName(this.name);
        this.addConstituentFields(descriptorProto, sources);
    }

    protected void addConstituentFields(@Nonnull DescriptorProtos.DescriptorProto.Builder descriptorProto, @Nonnull Set<Descriptors.FileDescriptor> sources) {
        int fieldNumber = 0;
        for (Constituent constituent : this.constituents) {
            descriptorProto.addFieldBuilder().setName(constituent.getName()).setNumber(++fieldNumber).setType(DescriptorProtos.FieldDescriptorProto.Type.TYPE_MESSAGE).setTypeName("." + constituent.getRecordType().getDescriptor().getFullName());
            sources.add(constituent.getRecordType().getDescriptor().getFile());
        }
    }

    @Nonnull
    protected KeyExpression buildPrimaryKey() {
        return Key.Expressions.concat(Key.Expressions.recordType(), Key.Expressions.list(this.constituents.stream().map(c -> Key.Expressions.field(c.getName()).nest(c.getRecordType().getPrimaryKey())).collect(Collectors.toList())), new KeyExpression[0]);
    }

    public static class Constituent {
        @Nonnull
        private final String name;
        @Nonnull
        private final RecordTypeBuilder recordType;

        protected Constituent(@Nonnull String name, @Nonnull RecordTypeBuilder recordType) {
            this.name = name;
            this.recordType = recordType;
        }

        @Nonnull
        public String getName() {
            return this.name;
        }

        @Nonnull
        public RecordTypeBuilder getRecordType() {
            return this.recordType;
        }
    }
}

