/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record.metadata;

import com.apple.foundationdb.record.metadata.Key;
import com.apple.foundationdb.record.provider.foundationdb.FDBRecordVersion;
import com.apple.foundationdb.tuple.Tuple;
import com.google.protobuf.ByteString;
import com.google.protobuf.Internal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

class TupleTypeUtil {
    @Nonnull
    private static final BigInteger BIG_INT_MAX_LONG = BigInteger.valueOf(Long.MAX_VALUE);
    @Nonnull
    private static final BigInteger BIG_INT_MIN_LONG = BigInteger.valueOf(Long.MIN_VALUE);

    @Nonnull
    static List<Object> toTupleEquivalentList(@Nonnull List<?> values) {
        ArrayList<Object> tupleEquivalentList = new ArrayList<Object>(values.size());
        for (Object o : values) {
            tupleEquivalentList.add(TupleTypeUtil.toTupleEquivalentValue(o));
        }
        return tupleEquivalentList;
    }

    @Nullable
    static Object toTupleEquivalentValue(@Nullable Object obj) {
        if (obj == null || obj instanceof Key.Evaluated.NullStandin) {
            return null;
        }
        if (obj instanceof List) {
            List list = (List)obj;
            return TupleTypeUtil.toTupleEquivalentList(list);
        }
        if (obj instanceof Tuple) {
            return TupleTypeUtil.toTupleEquivalentList(((Tuple)obj).getItems());
        }
        if (obj instanceof byte[]) {
            return ByteString.copyFrom((byte[])obj);
        }
        if (obj instanceof Byte || obj instanceof Short || obj instanceof Integer) {
            return ((Number)obj).longValue();
        }
        if (obj instanceof BigInteger) {
            BigInteger bigInt = (BigInteger)obj;
            if (bigInt.compareTo(BIG_INT_MIN_LONG) > 0 && bigInt.compareTo(BIG_INT_MAX_LONG) < 0) {
                return bigInt.longValue();
            }
            return bigInt;
        }
        if (obj instanceof Internal.EnumLite) {
            return (long)((Internal.EnumLite)obj).getNumber();
        }
        if (obj instanceof FDBRecordVersion) {
            return ((FDBRecordVersion)obj).toVersionstamp(false);
        }
        return obj;
    }

    @Nonnull
    static List<Object> toTupleAppropriateList(@Nonnull List<?> values) {
        ArrayList<Object> tupleAppropriateList = new ArrayList<Object>(values.size());
        for (Object o : values) {
            tupleAppropriateList.add(TupleTypeUtil.toTupleAppropriateValue(o));
        }
        return tupleAppropriateList;
    }

    @Nullable
    static Object toTupleAppropriateValue(@Nullable Object obj) {
        if (obj instanceof Key.Evaluated.NullStandin) {
            return null;
        }
        if (obj instanceof ByteString) {
            return ((ByteString)obj).toByteArray();
        }
        if (obj instanceof List) {
            return TupleTypeUtil.toTupleAppropriateList((List)obj);
        }
        if (obj instanceof Internal.EnumLite) {
            return ((Internal.EnumLite)obj).getNumber();
        }
        if (obj instanceof FDBRecordVersion) {
            return ((FDBRecordVersion)obj).toVersionstamp(false);
        }
        return obj;
    }

    private TupleTypeUtil() {
    }
}

