/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record.metadata;

import com.apple.foundationdb.annotation.API;
import com.apple.foundationdb.record.RecordCoreException;
import com.apple.foundationdb.record.RecordMetaData;
import com.apple.foundationdb.record.RecordMetaDataProto;
import com.apple.foundationdb.record.logging.LogMessageKeys;
import com.apple.foundationdb.record.metadata.Index;
import com.apple.foundationdb.record.metadata.Key;
import com.apple.foundationdb.record.metadata.MetaDataException;
import com.apple.foundationdb.record.metadata.RecordType;
import com.apple.foundationdb.record.metadata.SyntheticRecordType;
import com.apple.foundationdb.record.metadata.expressions.KeyExpression;
import com.apple.foundationdb.record.metadata.expressions.LiteralKeyExpression;
import com.apple.foundationdb.record.provider.foundationdb.FDBRecordStore;
import com.apple.foundationdb.record.provider.foundationdb.FDBStoredRecord;
import com.apple.foundationdb.record.provider.foundationdb.FDBSyntheticRecord;
import com.apple.foundationdb.record.provider.foundationdb.IndexOrphanBehavior;
import com.apple.foundationdb.record.provider.foundationdb.RecordDoesNotExistException;
import com.apple.foundationdb.tuple.Tuple;
import com.google.protobuf.Descriptors;
import com.google.protobuf.Message;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@API(value=API.Status.EXPERIMENTAL)
public class UnnestedRecordType
extends SyntheticRecordType<NestedConstituent> {
    @Nonnull
    public static final String POSITIONS_FIELD = "__positions";
    @Nonnull
    private final NestedConstituent parentConstituent;

    protected UnnestedRecordType(@Nonnull RecordMetaData metaData, @Nonnull Descriptors.Descriptor descriptor, @Nonnull KeyExpression primaryKey, @Nonnull Object recordTypeKey, @Nonnull List<Index> indexes, @Nonnull List<Index> multiTypeIndexes, @Nonnull List<NestedConstituent> constituents) {
        super(metaData, descriptor, primaryKey, recordTypeKey, indexes, multiTypeIndexes, constituents);
        this.parentConstituent = constituents.stream().filter(NestedConstituent::isParent).findFirst().orElseThrow(() -> new MetaDataException("unnested record type missing parent constituent", new Object[0]));
    }

    @Nonnull
    public NestedConstituent getParentConstituent() {
        return this.parentConstituent;
    }

    @Override
    @Nonnull
    @API(value=API.Status.INTERNAL)
    public CompletableFuture<FDBSyntheticRecord> loadByPrimaryKeyAsync(@Nonnull FDBRecordStore store, @Nonnull Tuple primaryKey, IndexOrphanBehavior orphanBehavior) {
        Tuple parentPrimaryKey = primaryKey.getNestedTuple(1);
        return store.loadRecordAsync(parentPrimaryKey).thenApply(storedRecord -> {
            if (storedRecord == null) {
                switch (orphanBehavior) {
                    case ERROR: {
                        throw new RecordDoesNotExistException("constituent record not found: " + this.parentConstituent.getName(), new Object[0]).addLogInfo(new Object[]{LogMessageKeys.PRIMARY_KEY, parentPrimaryKey});
                    }
                    case SKIP: {
                        return null;
                    }
                    case RETURN: {
                        return FDBSyntheticRecord.of(this, Map.of());
                    }
                }
                throw new IllegalArgumentException("Unknown orphanBehavior value: " + String.valueOf((Object)orphanBehavior));
            }
            HashMap<String, FDBStoredRecord<? extends Message>> constituentValues = new HashMap<String, FDBStoredRecord<? extends Message>>();
            constituentValues.put(this.getParentConstituent().getName(), (FDBStoredRecord<? extends Message>)storedRecord);
            boolean foundMore = true;
            while (foundMore) {
                foundMore = false;
                for (NestedConstituent constituent : this.getConstituents()) {
                    if (constituent.isParent() || !constituentValues.containsKey(constituent.getParentName()) || constituentValues.containsKey(constituent.getName())) continue;
                    foundMore = true;
                    FDBStoredRecord parentRecord = (FDBStoredRecord)constituentValues.get(constituent.getParentName());
                    List<Key.Evaluated> childElems = constituent.getNestingExpression().evaluate(parentRecord);
                    int childConstituentIndex = this.getConstituents().indexOf(constituent);
                    int childElemIndex = (int)primaryKey.getNestedTuple(childConstituentIndex + 1).getLong(0);
                    if (childElemIndex >= childElems.size()) {
                        switch (orphanBehavior) {
                            case ERROR: {
                                throw new RecordCoreException("child element position is too large", new Object[0]).addLogInfo(new Object[]{LogMessageKeys.CHILD_COUNT, childElems.size()});
                            }
                            case SKIP: {
                                return null;
                            }
                            case RETURN: {
                                return FDBSyntheticRecord.of(this, Map.of());
                            }
                        }
                        throw new IllegalArgumentException("Unknown orphanBehavior value: " + String.valueOf((Object)orphanBehavior));
                    }
                    Key.Evaluated childElem = childElems.get(childElemIndex);
                    Message childMessage = childElem.getObject(0, Message.class);
                    FDBStoredRecord<Message> childRecord = FDBStoredRecord.newBuilder().setRecordType(constituent.getRecordType()).setRecord(childMessage).setPrimaryKey(Tuple.from(childElemIndex)).build();
                    constituentValues.put(constituent.getName(), childRecord);
                }
            }
            return FDBSyntheticRecord.of(this, constituentValues);
        });
    }

    @Nonnull
    public RecordMetaDataProto.UnnestedRecordType toProto() {
        RecordMetaDataProto.UnnestedRecordType.Builder builder = RecordMetaDataProto.UnnestedRecordType.newBuilder().setName(this.getName()).setRecordTypeKey(LiteralKeyExpression.toProtoValue(this.getRecordTypeKey()));
        for (NestedConstituent constituent : this.getConstituents()) {
            RecordMetaDataProto.UnnestedRecordType.NestedConstituent.Builder constituentBuilder = builder.addNestedConstituentsBuilder().setName(constituent.getName());
            if (constituent.isParent()) {
                constituentBuilder.setTypeName(constituent.getRecordType().getName());
                continue;
            }
            constituentBuilder.setTypeName(constituent.getRecordType().getDescriptor().getFullName()).setParent(Objects.requireNonNull(constituent.getParentName())).setNestingExpression(constituent.getNestingExpression().toKeyExpression());
        }
        return builder.build();
    }

    public static class NestedConstituent
    extends SyntheticRecordType.Constituent {
        @Nullable
        private final NestedConstituent parent;
        @Nonnull
        private final KeyExpression nestingExpression;

        NestedConstituent(@Nonnull String name, @Nonnull RecordType recordType, @Nullable NestedConstituent parent, @Nonnull KeyExpression nestingExpression) {
            super(name, recordType);
            this.parent = parent;
            this.nestingExpression = nestingExpression;
        }

        @Nullable
        public NestedConstituent getParent() {
            return this.parent;
        }

        @Nullable
        public String getParentName() {
            return this.parent == null ? null : this.parent.getName();
        }

        @Nonnull
        public KeyExpression getNestingExpression() {
            return this.nestingExpression;
        }

        public boolean isParent() {
            return this.parent == null;
        }
    }
}

