/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record.metadata;

import com.apple.foundationdb.annotation.API;
import com.apple.foundationdb.record.RecordCoreException;
import com.apple.foundationdb.record.RecordMetaData;
import com.apple.foundationdb.record.RecordMetaDataBuilder;
import com.apple.foundationdb.record.RecordMetaDataProto;
import com.apple.foundationdb.record.logging.LogMessageKeys;
import com.apple.foundationdb.record.metadata.Key;
import com.apple.foundationdb.record.metadata.MetaDataException;
import com.apple.foundationdb.record.metadata.NestedRecordType;
import com.apple.foundationdb.record.metadata.NestedRecordTypeBuilder;
import com.apple.foundationdb.record.metadata.RecordType;
import com.apple.foundationdb.record.metadata.RecordTypeBuilder;
import com.apple.foundationdb.record.metadata.SyntheticRecordTypeBuilder;
import com.apple.foundationdb.record.metadata.UnnestedRecordType;
import com.apple.foundationdb.record.metadata.expressions.EmptyKeyExpression;
import com.apple.foundationdb.record.metadata.expressions.KeyExpression;
import com.apple.foundationdb.record.metadata.expressions.LiteralKeyExpression;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Maps;
import com.google.protobuf.DescriptorProtos;
import com.google.protobuf.Descriptors;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@API(value=API.Status.EXPERIMENTAL)
public class UnnestedRecordTypeBuilder
extends SyntheticRecordTypeBuilder<NestedConstituent> {
    @Nonnull
    private static final String INTERNAL_PREFIX = "__";
    @Nullable
    private RecordTypeBuilder parentTypeBuilder;

    @API(value=API.Status.INTERNAL)
    public UnnestedRecordTypeBuilder(@Nonnull String name, @Nonnull Object recordTypeKey, @Nonnull RecordMetaDataBuilder metaDataBuilder) {
        super(name, recordTypeKey, metaDataBuilder);
    }

    @API(value=API.Status.INTERNAL)
    public UnnestedRecordTypeBuilder(@Nonnull RecordMetaDataProto.UnnestedRecordType typeProto, @Nonnull RecordMetaDataBuilder metaDataBuilder) {
        super(typeProto.getName(), LiteralKeyExpression.fromProtoValue(typeProto.getRecordTypeKey()), metaDataBuilder);
        Descriptors.FileDescriptor fileDescriptor = metaDataBuilder.getUnionDescriptor().getFile();
        for (RecordMetaDataProto.UnnestedRecordType.NestedConstituent constituentProto : typeProto.getNestedConstituentsList()) {
            String constituentName = constituentProto.getName();
            String parentConstituent = constituentProto.getParent();
            if (parentConstituent.isEmpty()) {
                if (this.parentTypeBuilder != null) {
                    throw new MetaDataException("duplicate parent types found in unnested record type", new Object[0]).addLogInfo(new Object[]{LogMessageKeys.RECORD_TYPE, this.getName()}).addLogInfo(new Object[]{LogMessageKeys.CONSTITUENT, constituentName});
                }
                if (constituentProto.hasNestingExpression()) {
                    throw new MetaDataException("parent constituent should not have a nesting expression", new Object[0]).addLogInfo(new Object[]{LogMessageKeys.RECORD_TYPE, this.getName()}).addLogInfo(new Object[]{LogMessageKeys.CONSTITUENT, constituentName});
                }
                this.parentTypeBuilder = metaDataBuilder.getRecordType(constituentProto.getTypeName());
                this.addConstituent(this.newConstituent(constituentName, this.parentTypeBuilder, null, EmptyKeyExpression.EMPTY));
                continue;
            }
            Descriptors.Descriptor nestedDescriptor = UnnestedRecordTypeBuilder.findDescriptorByName(fileDescriptor, constituentProto.getTypeName());
            if (nestedDescriptor == null) {
                throw new MetaDataException("missing descriptor for nested constituent", new Object[0]).addLogInfo(new Object[]{LogMessageKeys.EXPECTED, constituentProto.getTypeName()}).addLogInfo(new Object[]{LogMessageKeys.CONSTITUENT, constituentName});
            }
            NestedRecordTypeBuilder nestedTypeBuilder = new NestedRecordTypeBuilder(nestedDescriptor);
            KeyExpression nestingExpression = KeyExpression.fromProto(constituentProto.getNestingExpression());
            this.addConstituent(this.newConstituent(constituentName, nestedTypeBuilder, parentConstituent, nestingExpression));
        }
    }

    @Nullable
    @API(value=API.Status.INTERNAL)
    public static Descriptors.Descriptor findDescriptorByName(@Nonnull Descriptors.FileDescriptor fileDescriptor, @Nonnull String fullName) {
        HashSet<Descriptors.FileDescriptor> seen = new HashSet<Descriptors.FileDescriptor>();
        seen.add(fileDescriptor);
        return UnnestedRecordTypeBuilder.findDescriptorByName(fileDescriptor, fullName, seen);
    }

    @Nullable
    private static Descriptors.Descriptor findDescriptorByName(@Nonnull Descriptors.FileDescriptor fileDescriptor, @Nonnull String fullName, @Nonnull Set<Descriptors.FileDescriptor> seen) {
        Descriptors.Descriptor found;
        if (fullName.startsWith(fileDescriptor.getPackage())) {
            for (Descriptors.Descriptor desc : fileDescriptor.getMessageTypes()) {
                found = UnnestedRecordTypeBuilder.findDescriptorByName(desc, fullName);
                if (found == null) continue;
                return found;
            }
        }
        for (Descriptors.FileDescriptor dependency : fileDescriptor.getDependencies()) {
            if (!seen.add(dependency) || (found = UnnestedRecordTypeBuilder.findDescriptorByName(dependency, fullName, seen)) == null) continue;
            return found;
        }
        return null;
    }

    @Nullable
    private static Descriptors.Descriptor findDescriptorByName(@Nonnull Descriptors.Descriptor descriptor, @Nonnull String fullName) {
        if (fullName.startsWith(descriptor.getFullName())) {
            if (descriptor.getFullName().equals(fullName)) {
                return descriptor;
            }
            for (Descriptors.Descriptor nestedType : descriptor.getNestedTypes()) {
                Descriptors.Descriptor foundNested = UnnestedRecordTypeBuilder.findDescriptorByName(nestedType, fullName);
                if (foundNested == null) continue;
                return foundNested;
            }
        }
        return null;
    }

    @Override
    @Nonnull
    protected NestedConstituent newConstituent(@Nonnull String name, @Nonnull RecordTypeBuilder recordType) {
        throw new RecordCoreException("unimplemented", new Object[0]);
    }

    @Nonnull
    private NestedConstituent newConstituent(@Nonnull String name, @Nonnull RecordTypeBuilder recordType, @Nullable String parentName, @Nonnull KeyExpression nestingExpression) {
        if (name.startsWith(INTERNAL_PREFIX)) {
            throw new MetaDataException("cannot create constituent with reserved prefix \"__\"", new Object[0]).addLogInfo(new Object[]{LogMessageKeys.CONSTITUENT, name}).addLogInfo(new Object[]{LogMessageKeys.RECORD_TYPE, this.getName()});
        }
        return new NestedConstituent(name, recordType, parentName, nestingExpression);
    }

    @Nonnull
    public NestedConstituent addParentConstituent(@Nonnull String name, @Nonnull RecordTypeBuilder recordType) {
        if (this.parentTypeBuilder != null) {
            throw new MetaDataException("cannot add duplicate parent type to unnested record type", new Object[0]).addLogInfo(new Object[]{LogMessageKeys.RECORD_TYPE, this.getName()}).addLogInfo(new Object[]{LogMessageKeys.OLD_RECORD_TYPE, this.parentTypeBuilder.getName()}).addLogInfo(new Object[]{LogMessageKeys.NEW_RECORD_TYPE, recordType.getName()});
        }
        if (!this.getConstituents().isEmpty()) {
            throw new MetaDataException("parent must be added as first constituent", new Object[0]).addLogInfo(new Object[]{LogMessageKeys.RECORD_TYPE, this.getName()});
        }
        this.parentTypeBuilder = recordType;
        NestedConstituent constituent = this.newConstituent(name, recordType, null, EmptyKeyExpression.EMPTY);
        this.addConstituent(constituent);
        return constituent;
    }

    @Nonnull
    public NestedConstituent addNestedConstituent(@Nonnull String name, @Nonnull Descriptors.Descriptor descriptor, @Nonnull String parent, @Nonnull KeyExpression nestingExpression) {
        if (this.getConstituents().stream().map(SyntheticRecordTypeBuilder.Constituent::getName).noneMatch(n -> n.equals(parent))) {
            throw new MetaDataException("unknown parent constituent name", new Object[0]).addLogInfo(new Object[]{LogMessageKeys.EXPECTED, parent}).addLogInfo(new Object[]{LogMessageKeys.CONSTITUENT, name}).addLogInfo(new Object[]{LogMessageKeys.RECORD_TYPE, this.getName()});
        }
        NestedRecordTypeBuilder nestedRecordType = new NestedRecordTypeBuilder(descriptor);
        NestedConstituent constituent = this.newConstituent(name, nestedRecordType, parent, nestingExpression);
        this.addConstituent(constituent);
        return constituent;
    }

    @Nonnull
    private List<UnnestedRecordType.NestedConstituent> buildConstituents(@Nonnull RecordType parentType) {
        ImmutableList.Builder builder = ImmutableList.builderWithExpectedSize(this.getConstituents().size());
        HashMap<String, UnnestedRecordType.NestedConstituent> soFar = Maps.newHashMapWithExpectedSize(this.getConstituents().size());
        RecordMetaData metaData = parentType.getRecordMetaData();
        for (NestedConstituent constituent : this.getConstituents()) {
            UnnestedRecordType.NestedConstituent built = constituent.build(metaData, soFar);
            if (soFar.put(built.getName(), built) != null) {
                throw new MetaDataException("duplicate constituents in unnested record type share name", new Object[0]).addLogInfo(new Object[]{LogMessageKeys.CONSTITUENT, constituent.getName()}).addLogInfo(new Object[]{LogMessageKeys.RECORD_TYPE, this.getName()});
            }
            builder.add(built);
        }
        return builder.build();
    }

    @Override
    @Nonnull
    protected KeyExpression buildPrimaryKey() {
        ArrayList<KeyExpression> subPrimaryKeys = new ArrayList<KeyExpression>(this.getConstituents().size());
        for (NestedConstituent constituent : this.getConstituents()) {
            RecordTypeBuilder typeBuilder = constituent.getRecordType();
            if (constituent.isParent()) {
                KeyExpression typePrimaryKey = typeBuilder.getPrimaryKey();
                if (typePrimaryKey == null) {
                    throw new MetaDataException("constituent primary key is null", new Object[0]).addLogInfo(new Object[]{LogMessageKeys.RECORD_TYPE, this.getName()}).addLogInfo(new Object[]{LogMessageKeys.CONSTITUENT, constituent.getName()});
                }
                subPrimaryKeys.add(Key.Expressions.field(constituent.getName()).nest(typePrimaryKey));
                continue;
            }
            subPrimaryKeys.add(Key.Expressions.field("__positions").nest(constituent.getName()));
        }
        return Key.Expressions.concat(Key.Expressions.recordType(), Key.Expressions.list(subPrimaryKeys), new KeyExpression[0]);
    }

    @Override
    public void buildDescriptor(@Nonnull DescriptorProtos.FileDescriptorProto.Builder fileDescriptorProto, @Nonnull Set<Descriptors.FileDescriptor> sources) {
        DescriptorProtos.DescriptorProto.Builder descriptorProto = fileDescriptorProto.addMessageTypeBuilder();
        descriptorProto.setName(this.name);
        this.addConstituentFields(descriptorProto, sources);
        DescriptorProtos.DescriptorProto.Builder indexesProto = descriptorProto.addNestedTypeBuilder().setName("Positions");
        int indexPosition = 1;
        for (NestedConstituent constituent : this.getConstituents()) {
            if (constituent.isParent()) continue;
            indexesProto.addFieldBuilder().setLabel(DescriptorProtos.FieldDescriptorProto.Label.LABEL_OPTIONAL).setType(DescriptorProtos.FieldDescriptorProto.Type.TYPE_INT64).setName(constituent.getName()).setNumber(indexPosition++);
        }
        descriptorProto.addFieldBuilder().setLabel(DescriptorProtos.FieldDescriptorProto.Label.LABEL_OPTIONAL).setType(DescriptorProtos.FieldDescriptorProto.Type.TYPE_MESSAGE).setTypeName(this.name + "." + indexesProto.getName()).setName("__positions").setNumber(this.getConstituents().size() + 1);
    }

    @Nonnull
    public UnnestedRecordType build(@Nonnull RecordMetaData metaData, @Nonnull Descriptors.FileDescriptor fileDescriptor) {
        if (this.parentTypeBuilder == null) {
            throw new MetaDataException("unnested record type missing parent type", new Object[0]).addLogInfo(new Object[]{LogMessageKeys.RECORD_TYPE, this.getName()});
        }
        RecordType parentType = metaData.getRecordType(this.parentTypeBuilder.getName());
        List<UnnestedRecordType.NestedConstituent> builtConstituents = this.buildConstituents(parentType);
        Descriptors.Descriptor descriptor = fileDescriptor.findMessageTypeByName(this.name);
        return new UnnestedRecordType(metaData, descriptor, this.buildPrimaryKey(), Objects.requireNonNull(this.recordTypeKey), this.getIndexes(), this.getMultiTypeIndexes(), builtConstituents);
    }

    public static class NestedConstituent
    extends SyntheticRecordTypeBuilder.Constituent {
        @Nullable
        private final String parentName;
        @Nonnull
        private final KeyExpression nestingExpression;

        private NestedConstituent(@Nonnull String name, @Nonnull RecordTypeBuilder recordType, @Nullable String parentName, @Nonnull KeyExpression nestingExpression) {
            super(name, recordType);
            this.parentName = parentName;
            this.nestingExpression = nestingExpression;
        }

        @Nullable
        public String getParentName() {
            return this.parentName;
        }

        @Nonnull
        public KeyExpression getNestingExpression() {
            return this.nestingExpression;
        }

        public boolean isParent() {
            return this.parentName == null;
        }

        @Nonnull
        UnnestedRecordType.NestedConstituent build(@Nonnull RecordMetaData metaData, @Nonnull Map<String, UnnestedRecordType.NestedConstituent> soFar) {
            String name = this.getName();
            if (this.isParent()) {
                RecordType recordType = metaData.getRecordType(this.getRecordType().getName());
                return new UnnestedRecordType.NestedConstituent(name, recordType, null, this.nestingExpression);
            }
            if (name.startsWith(UnnestedRecordTypeBuilder.INTERNAL_PREFIX)) {
                throw new MetaDataException("reserved name cannot be used for constituent", new Object[0]).addLogInfo(new Object[]{LogMessageKeys.CONSTITUENT, name});
            }
            if (soFar.containsKey(name)) {
                throw new MetaDataException("duplicate constituent name", new Object[0]).addLogInfo(new Object[]{LogMessageKeys.CONSTITUENT, name});
            }
            UnnestedRecordType.NestedConstituent parent = soFar.get(this.parentName);
            if (parent == null) {
                throw new MetaDataException("missing parent constituent for nested constituent", new Object[0]).addLogInfo(new Object[]{LogMessageKeys.CONSTITUENT, name}).addLogInfo(new Object[]{LogMessageKeys.EXPECTED, this.parentName});
            }
            NestedRecordType recordType = new NestedRecordType(metaData, this.getRecordType().getDescriptor(), parent.getRecordType(), Key.Expressions.field("__positions").nest(name));
            return new UnnestedRecordType.NestedConstituent(name, recordType, parent, this.nestingExpression);
        }
    }
}

