/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record.metadata.expressions;

import com.apple.foundationdb.annotation.API;
import com.apple.foundationdb.record.RecordCoreException;
import com.apple.foundationdb.record.logging.LogMessageKeys;
import com.apple.foundationdb.record.metadata.Key;
import com.apple.foundationdb.record.metadata.expressions.AtomKeyExpression;
import com.apple.foundationdb.record.metadata.expressions.EmptyKeyExpression;
import com.apple.foundationdb.record.metadata.expressions.GroupingKeyExpression;
import com.apple.foundationdb.record.metadata.expressions.KeyExpression;
import com.apple.foundationdb.record.metadata.expressions.KeyExpressionWithChildren;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.List;
import java.util.ListIterator;
import javax.annotation.Nonnull;

@API(value=API.Status.UNSTABLE)
public abstract class BaseKeyExpression
implements KeyExpression {
    @Override
    @Nonnull
    public final KeyExpression getSubKey(int start, int end) {
        int columnSize = this.getColumnSize();
        if (start < 0 || end > columnSize || start > end) {
            throw new IllegalSubKeyException(start, end, columnSize);
        }
        if (start == end) {
            return EmptyKeyExpression.EMPTY;
        }
        if (start == 0 && end == columnSize) {
            return this;
        }
        return this.getSubKeyImpl(start, end);
    }

    @Nonnull
    protected KeyExpression getSubKeyImpl(int start, int end) {
        throw new UnsplittableKeyExpressionException(this);
    }

    void validateColumnCounts(List<Key.Evaluated> results) {
        int columnSize = this.getColumnSize();
        for (Key.Evaluated result : results) {
            if (result.size() == columnSize) continue;
            throw new KeyExpression.InvalidResultException("Expression evaluated to unexpected number of columns").addLogInfo(new Object[]{LogMessageKeys.KEY_EXPRESSION, this.toString(), LogMessageKeys.KEY_EVALUATED, result.toTuple().toString(), LogMessageKeys.EXPECTED_COLUMN_SIZE, this.getColumnSize(), LogMessageKeys.ACTUAL_COLUMN_SIZE, result.size()});
        }
    }

    @Override
    public boolean isPrefixKey(@Nonnull KeyExpression key) {
        if (this instanceof EmptyKeyExpression || this.equals(key)) {
            return true;
        }
        if (this instanceof GroupingKeyExpression && ((GroupingKeyExpression)this).getGroupedCount() > 0) {
            return false;
        }
        ArrayDeque<KeyExpression> prefixes = new ArrayDeque<KeyExpression>();
        ArrayDeque<KeyExpression> keys = new ArrayDeque<KeyExpression>();
        prefixes.push(this);
        keys.push(key);
        while (!prefixes.isEmpty()) {
            if (keys.isEmpty()) {
                return prefixes.stream().allMatch(prefixPart -> prefixPart instanceof EmptyKeyExpression);
            }
            KeyExpression prefixPart2 = (KeyExpression)prefixes.pop();
            KeyExpression keyPart = (KeyExpression)keys.pop();
            if (!keyPart.hasProperInterfaces() || !prefixPart2.hasProperInterfaces()) {
                throw new KeyExpression.InvalidExpressionException("Expression contained Key.Expression implementation that does not implement Key.ExpressionWithChildren or Key.ExpressionWithoutChildren");
            }
            if (prefixPart2 instanceof AtomKeyExpression && keyPart instanceof AtomKeyExpression) {
                if (((AtomKeyExpression)prefixPart2).equalsAtomic((AtomKeyExpression)keyPart)) {
                    BaseKeyExpression.pushChildren(prefixes, prefixPart2);
                    BaseKeyExpression.pushChildren(keys, keyPart);
                    continue;
                }
                return false;
            }
            if (prefixPart2 instanceof AtomKeyExpression) {
                prefixes.push(prefixPart2);
                BaseKeyExpression.pushChildren(keys, keyPart);
                continue;
            }
            if (keyPart instanceof AtomKeyExpression) {
                keys.push(keyPart);
                BaseKeyExpression.pushChildren(prefixes, prefixPart2);
                continue;
            }
            BaseKeyExpression.pushChildren(prefixes, prefixPart2);
            BaseKeyExpression.pushChildren(keys, keyPart);
        }
        return true;
    }

    private static void pushChildren(Deque<KeyExpression> stack, KeyExpression part) {
        if (part instanceof KeyExpressionWithChildren) {
            List<KeyExpression> children = ((KeyExpressionWithChildren)part).getChildren();
            ListIterator<KeyExpression> childrenIterator = children.listIterator(children.size());
            while (childrenIterator.hasPrevious()) {
                stack.push(childrenIterator.previous());
            }
        }
    }

    public static class IllegalSubKeyException
    extends RecordCoreException {
        public static final long serialVersionUID = 1L;

        public IllegalSubKeyException(int start, int end, int columnSize) {
            super("requested subkey is invalid", new Object[0]);
            this.addLogInfo(new Object[]{LogMessageKeys.REQUESTED_START, start});
            this.addLogInfo(new Object[]{LogMessageKeys.REQUESTED_END, end});
            this.addLogInfo(new Object[]{LogMessageKeys.COLUMN_SIZE, columnSize});
        }
    }

    public static class UnsplittableKeyExpressionException
    extends RecordCoreException {
        public static final long serialVersionUID = 1L;

        public UnsplittableKeyExpressionException(@Nonnull BaseKeyExpression keyExpression) {
            super("Cannot split " + String.valueOf(keyExpression), new Object[0]);
        }
    }
}

