/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record.metadata.expressions;

import com.apple.foundationdb.annotation.API;
import com.apple.foundationdb.record.ObjectPlanHash;
import com.apple.foundationdb.record.PlanHashable;
import com.apple.foundationdb.record.metadata.Key;
import com.apple.foundationdb.record.metadata.MetaDataException;
import com.apple.foundationdb.record.metadata.expressions.FunctionKeyExpression;
import com.apple.foundationdb.record.metadata.expressions.KeyExpression;
import com.apple.foundationdb.record.metadata.expressions.LiteralKeyExpression;
import com.apple.foundationdb.record.metadata.expressions.QueryableKeyExpression;
import com.apple.foundationdb.record.metadata.expressions.ThenKeyExpression;
import com.apple.foundationdb.record.provider.common.text.TextCollator;
import com.apple.foundationdb.record.provider.common.text.TextCollatorRegistry;
import com.apple.foundationdb.record.provider.foundationdb.FDBRecord;
import com.apple.foundationdb.record.query.plan.cascades.KeyExpressionVisitor;
import com.apple.foundationdb.record.query.plan.cascades.values.Value;
import com.google.common.base.Verify;
import com.google.protobuf.Message;
import java.util.Collections;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@API(value=API.Status.EXPERIMENTAL)
public class CollateFunctionKeyExpression
extends FunctionKeyExpression
implements QueryableKeyExpression {
    private static final ObjectPlanHash BASE_HASH = new ObjectPlanHash("Collate-Function-Key-Expression");
    @Nonnull
    private final TextCollatorRegistry collatorRegistry;
    @Nullable
    private final TextCollator invariableCollator;

    protected CollateFunctionKeyExpression(@Nonnull TextCollatorRegistry collatorRegistry, @Nonnull String name, @Nonnull KeyExpression arguments) {
        super(name, arguments);
        this.collatorRegistry = collatorRegistry;
        this.invariableCollator = CollateFunctionKeyExpression.getInvariableCollator(collatorRegistry, arguments);
    }

    @Nullable
    protected static TextCollator getInvariableCollator(@Nonnull TextCollatorRegistry collatorRegistry, @Nonnull KeyExpression arguments) {
        if (arguments.getColumnSize() < 2) {
            return collatorRegistry.getTextCollator();
        }
        if (arguments instanceof ThenKeyExpression) {
            List<KeyExpression> children = ((ThenKeyExpression)arguments).getChildren();
            if (children.size() > 1 && !(children.get(1) instanceof LiteralKeyExpression)) {
                return null;
            }
            if (children.size() > 2 && !(children.get(2) instanceof LiteralKeyExpression)) {
                return null;
            }
            String locale = null;
            Integer strength = null;
            if (children.size() > 1) {
                Object literal1 = ((LiteralKeyExpression)children.get(1)).getValue();
                if (literal1 instanceof String) {
                    locale = (String)literal1;
                } else if (literal1 != null) {
                    return null;
                }
            }
            if (children.size() > 2) {
                Object literal2 = ((LiteralKeyExpression)children.get(2)).getValue();
                if (literal2 instanceof Number) {
                    strength = ((Number)literal2).intValue();
                } else if (literal2 != null) {
                    return null;
                }
            }
            if (locale == null) {
                return strength == null ? collatorRegistry.getTextCollator() : collatorRegistry.getTextCollator(strength);
            }
            return strength == null ? collatorRegistry.getTextCollator(locale) : collatorRegistry.getTextCollator(locale, strength);
        }
        return null;
    }

    protected TextCollator getTextCollator(@Nonnull Key.Evaluated arguments) {
        if (this.invariableCollator != null) {
            return this.invariableCollator;
        }
        if (arguments.size() < 2) {
            return this.collatorRegistry.getTextCollator();
        }
        String locale = arguments.getString(1);
        if (arguments.size() < 3) {
            return locale == null ? this.collatorRegistry.getTextCollator() : this.collatorRegistry.getTextCollator(locale);
        }
        int strength = (int)arguments.getLong(2);
        return locale == null ? this.collatorRegistry.getTextCollator(strength) : this.collatorRegistry.getTextCollator(locale, strength);
    }

    @Nonnull
    public TextCollatorRegistry getCollatorRegistry() {
        return this.collatorRegistry;
    }

    @Override
    public int getMinArguments() {
        return 1;
    }

    @Override
    public int getMaxArguments() {
        return 3;
    }

    @Override
    @Nonnull
    public <M extends Message> List<Key.Evaluated> evaluateFunction(@Nullable FDBRecord<M> record, @Nullable Message message, @Nonnull Key.Evaluated arguments) {
        String value = arguments.getString(0);
        if (value == null) {
            return Collections.singletonList(Key.Evaluated.NULL);
        }
        TextCollator textCollator = this.getTextCollator(arguments);
        return Collections.singletonList(Key.Evaluated.scalar(textCollator.getKey(value)));
    }

    @Override
    public boolean createsDuplicates() {
        return this.getArguments().createsDuplicates();
    }

    @Override
    public int getColumnSize() {
        return 1;
    }

    @Override
    @Nonnull
    public <S extends KeyExpressionVisitor.State, R> R expand(@Nonnull KeyExpressionVisitor<S, R> visitor) {
        return visitor.visitExpression(this);
    }

    @Override
    @Nonnull
    public Value toValue(@Nonnull List<? extends Value> argumentValues) {
        Verify.verify(argumentValues.size() == this.arguments.getColumnSize());
        return this.resolveAndEncapsulateFunction(this.getName(), argumentValues);
    }

    @Override
    @Nullable
    public Function<Object, Object> getComparandConversionFunction() {
        TextCollator textCollator = this.invariableCollator;
        if (textCollator == null) {
            throw new MetaDataException("can only be used in queries when collation name is constant", new Object[0]);
        }
        return o -> textCollator.getKey((String)o);
    }

    @Override
    public int planHash(@Nonnull PlanHashable.PlanHashMode mode) {
        return super.basePlanHash(mode, BASE_HASH, new Object[0]);
    }
}

