/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record.metadata.expressions;

import com.apple.foundationdb.annotation.API;
import com.apple.foundationdb.record.ObjectPlanHash;
import com.apple.foundationdb.record.PlanHashable;
import com.apple.foundationdb.record.expressions.RecordKeyExpressionProto;
import com.apple.foundationdb.record.metadata.Key;
import com.apple.foundationdb.record.metadata.expressions.BaseKeyExpression;
import com.apple.foundationdb.record.metadata.expressions.KeyExpression;
import com.apple.foundationdb.record.metadata.expressions.KeyExpressionWithChild;
import com.apple.foundationdb.record.metadata.expressions.ThenKeyExpression;
import com.apple.foundationdb.record.provider.foundationdb.FDBRecord;
import com.apple.foundationdb.record.query.plan.cascades.KeyExpressionVisitor;
import com.google.common.base.Verify;
import com.google.common.collect.ImmutableList;
import com.google.protobuf.Descriptors;
import com.google.protobuf.Message;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@API(value=API.Status.UNSTABLE)
public class DimensionsKeyExpression
extends BaseKeyExpression
implements KeyExpressionWithChild {
    private static final ObjectPlanHash BASE_HASH = new ObjectPlanHash("Dimension-Key-Expression");
    @Nonnull
    private final KeyExpression wholeKey;
    private final int prefixSize;
    private final int dimensionsSize;

    private DimensionsKeyExpression(@Nonnull KeyExpression wholeKey, int prefixSize, int dimensionsSize) {
        this.wholeKey = wholeKey;
        this.prefixSize = prefixSize;
        this.dimensionsSize = dimensionsSize;
    }

    DimensionsKeyExpression(@Nonnull RecordKeyExpressionProto.Dimensions dimensions) throws KeyExpression.DeserializationException {
        this(KeyExpression.fromProto(dimensions.getWholeKey()), dimensions.getPrefixSize(), dimensions.getDimensionsSize());
    }

    public int getPrefixSize() {
        return this.prefixSize;
    }

    public int getDimensionsSize() {
        return this.dimensionsSize;
    }

    @Override
    @Nonnull
    public <M extends Message> List<Key.Evaluated> evaluateMessage(@Nullable FDBRecord<M> record, @Nullable Message message) {
        return this.getWholeKey().evaluateMessage(record, message);
    }

    @Override
    public boolean createsDuplicates() {
        return this.getWholeKey().createsDuplicates();
    }

    @Override
    public List<Descriptors.FieldDescriptor> validate(@Nonnull Descriptors.Descriptor descriptor) {
        if (this.prefixSize + this.dimensionsSize > this.wholeKey.getColumnSize()) {
            throw new KeyExpression.InvalidExpressionException("dimensions declared a prefix size and number of dimensions that are together larger than the number of columns in the index");
        }
        List<Descriptors.FieldDescriptor> fieldDescriptors = this.getWholeKey().validate(descriptor);
        for (int i = this.prefixSize; i < this.prefixSize + this.dimensionsSize; ++i) {
            Descriptors.FieldDescriptor fieldDescriptor = Objects.requireNonNull(fieldDescriptors.get(i));
            if (fieldDescriptor.getType() == Descriptors.FieldDescriptor.Type.INT64) continue;
            throw new KeyExpression.InvalidExpressionException("the declared dimension columns have to be of type INT64");
        }
        return fieldDescriptors;
    }

    @Override
    public int getColumnSize() {
        return this.getWholeKey().getColumnSize();
    }

    @Override
    public boolean needsCopyingToPartialRecord() {
        return this.getWholeKey().needsCopyingToPartialRecord();
    }

    @Override
    @Nonnull
    public RecordKeyExpressionProto.Dimensions toProto() throws KeyExpression.SerializationException {
        RecordKeyExpressionProto.Dimensions.Builder builder = RecordKeyExpressionProto.Dimensions.newBuilder();
        builder.setWholeKey(this.getWholeKey().toKeyExpression());
        builder.setPrefixSize(this.prefixSize);
        builder.setDimensionsSize(this.dimensionsSize);
        return builder.build();
    }

    @Override
    @Nonnull
    public RecordKeyExpressionProto.KeyExpression toKeyExpression() {
        return RecordKeyExpressionProto.KeyExpression.newBuilder().setDimensions(this.toProto()).build();
    }

    @Override
    @Nonnull
    public List<KeyExpression> normalizeKeyForPositions() {
        return this.getWholeKey().normalizeKeyForPositions();
    }

    @Override
    public boolean hasLosslessNormalization() {
        return this.getWholeKey().hasLosslessNormalization();
    }

    @Override
    @Nonnull
    protected KeyExpression getSubKeyImpl(int start, int end) {
        return this.getWholeKey().getSubKey(start, end);
    }

    @Override
    @Nonnull
    public <S extends KeyExpressionVisitor.State, R> R expand(@Nonnull KeyExpressionVisitor<S, R> visitor) {
        return visitor.visitExpression(this);
    }

    @Override
    public int versionColumns() {
        return this.getWholeKey().versionColumns();
    }

    @Override
    public boolean hasRecordTypeKey() {
        return this.getWholeKey().hasRecordTypeKey();
    }

    @Nonnull
    public KeyExpression getWholeKey() {
        return this.wholeKey;
    }

    @Override
    @Nonnull
    public KeyExpression getChild() {
        return this.getWholeKey();
    }

    @Nullable
    public KeyExpression getPrefixSubKey() {
        if (this.prefixSize == 0) {
            return null;
        }
        return this.getWholeKey().getSubKey(0, this.prefixSize);
    }

    @Nonnull
    public KeyExpression getDimensionsSubKey() {
        return this.getWholeKey().getSubKey(this.prefixSize, this.dimensionsSize);
    }

    @Nonnull
    public KeyExpression getPrefixAndDimensionsKeyExpression() {
        return this.getWholeKey().getSubKey(0, this.prefixSize + this.dimensionsSize);
    }

    public String toString() {
        int restSize = this.getColumnSize() - this.prefixSize - this.dimensionsSize;
        return String.valueOf(this.getWholeKey()) + " dimensions(" + this.prefixSize + ", " + this.dimensionsSize + (String)(restSize > 0 ? ", " + restSize : "") + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DimensionsKeyExpression that = (DimensionsKeyExpression)o;
        return this.getWholeKey().equals(that.getWholeKey()) && this.prefixSize == that.prefixSize && this.dimensionsSize == that.dimensionsSize;
    }

    public int hashCode() {
        return Objects.hash(this.wholeKey, this.prefixSize, this.dimensionsSize);
    }

    @Override
    public int planHash(@Nonnull PlanHashable.PlanHashMode mode) {
        switch (mode.getKind()) {
            case LEGACY: 
            case FOR_CONTINUATION: {
                return PlanHashable.objectsPlanHash(mode, BASE_HASH, this.getWholeKey(), this.prefixSize, this.dimensionsSize);
            }
        }
        throw new UnsupportedOperationException("Hash kind " + String.valueOf((Object)mode.getKind()) + " is not supported");
    }

    @Nonnull
    public static DimensionsKeyExpression of(@Nullable KeyExpression prefix, @Nonnull KeyExpression dimensions) {
        int prefixCount = prefix == null ? 0 : prefix.getColumnSize();
        int dimensionsCount = dimensions.getColumnSize();
        Verify.verify(dimensionsCount > 1);
        ImmutableList.Builder wholeKeyBuilder = ImmutableList.builder();
        wholeKeyBuilder.addAll(DimensionsKeyExpression.liftExpression(prefix));
        wholeKeyBuilder.addAll(DimensionsKeyExpression.liftExpression(dimensions));
        ThenKeyExpression wholeKey = Key.Expressions.concat((List<KeyExpression>)((Object)wholeKeyBuilder.build()));
        return new DimensionsKeyExpression(wholeKey, prefixCount, dimensionsCount);
    }

    @Nonnull
    public static DimensionsKeyExpression of(@Nullable KeyExpression prefix, @Nonnull KeyExpression dimensions, @Nullable KeyExpression rest) {
        int prefixCount = prefix == null ? 0 : prefix.getColumnSize();
        int dimensionsCount = dimensions.getColumnSize();
        Verify.verify(dimensionsCount > 1);
        ImmutableList.Builder wholeKeyBuilder = ImmutableList.builder();
        wholeKeyBuilder.addAll(DimensionsKeyExpression.liftExpression(prefix));
        wholeKeyBuilder.addAll(DimensionsKeyExpression.liftExpression(dimensions));
        wholeKeyBuilder.addAll(DimensionsKeyExpression.liftExpression(rest));
        ThenKeyExpression wholeKey = Key.Expressions.concat((List<KeyExpression>)((Object)wholeKeyBuilder.build()));
        return new DimensionsKeyExpression(wholeKey, prefixCount, dimensionsCount);
    }

    @Nonnull
    private static List<KeyExpression> liftExpression(@Nullable KeyExpression expression) {
        if (expression == null) {
            return ImmutableList.of();
        }
        if (expression instanceof ThenKeyExpression) {
            return ((ThenKeyExpression)expression).getChildren();
        }
        return ImmutableList.of(expression);
    }
}

