/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record.metadata.expressions;

import com.apple.foundationdb.annotation.API;
import com.apple.foundationdb.record.ObjectPlanHash;
import com.apple.foundationdb.record.PlanHashable;
import com.apple.foundationdb.record.RecordCoreException;
import com.apple.foundationdb.record.expressions.RecordKeyExpressionProto;
import com.apple.foundationdb.record.logging.LogMessageKeys;
import com.apple.foundationdb.record.metadata.Key;
import com.apple.foundationdb.record.metadata.expressions.AtomKeyExpression;
import com.apple.foundationdb.record.metadata.expressions.BaseKeyExpression;
import com.apple.foundationdb.record.metadata.expressions.GroupingKeyExpression;
import com.apple.foundationdb.record.metadata.expressions.KeyExpression;
import com.apple.foundationdb.record.metadata.expressions.KeyExpressionWithoutChildren;
import com.apple.foundationdb.record.metadata.expressions.NestingKeyExpression;
import com.apple.foundationdb.record.metadata.expressions.SplitKeyExpression;
import com.apple.foundationdb.record.metadata.expressions.TupleFieldsHelper;
import com.apple.foundationdb.record.provider.foundationdb.FDBRecord;
import com.apple.foundationdb.record.query.expressions.Query;
import com.apple.foundationdb.record.query.plan.cascades.KeyExpressionVisitor;
import com.apple.foundationdb.record.query.plan.cascades.Quantifier;
import com.apple.foundationdb.record.query.plan.cascades.Reference;
import com.apple.foundationdb.record.query.plan.cascades.expressions.ExplodeExpression;
import com.apple.foundationdb.record.query.plan.cascades.expressions.RelationalExpression;
import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableList;
import com.google.protobuf.Descriptors;
import com.google.protobuf.Message;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@API(value=API.Status.UNSTABLE)
public class FieldKeyExpression
extends BaseKeyExpression
implements AtomKeyExpression,
KeyExpressionWithoutChildren {
    private static final ObjectPlanHash BASE_HASH = new ObjectPlanHash("Field-Key-Expression");
    @Nonnull
    private final String fieldName;
    @Nonnull
    private final KeyExpression.FanType fanType;
    @Nonnull
    private final Key.Evaluated.NullStandin nullStandin;

    public FieldKeyExpression(@Nonnull String fieldName, @Nonnull KeyExpression.FanType fanType, @Nonnull Key.Evaluated.NullStandin nullStandin) {
        this.fieldName = fieldName;
        this.fanType = fanType;
        this.nullStandin = nullStandin;
    }

    public FieldKeyExpression(@Nonnull RecordKeyExpressionProto.Field field) throws KeyExpression.DeserializationException {
        if (!field.hasFieldName()) {
            throw new KeyExpression.DeserializationException("Serialized Field is missing field name");
        }
        if (!field.hasFanType()) {
            throw new KeyExpression.DeserializationException("Serialized Field is missing fan type");
        }
        this.fieldName = field.getFieldName();
        this.fanType = KeyExpression.FanType.valueOf(field.getFanType());
        this.nullStandin = Key.Evaluated.NullStandin.valueOf(field.getNullInterpretation());
    }

    @Override
    public List<Descriptors.FieldDescriptor> validate(@Nonnull Descriptors.Descriptor parentDescriptor) {
        return this.validate(parentDescriptor, false);
    }

    public List<Descriptors.FieldDescriptor> validate(@Nonnull Descriptors.Descriptor parentDescriptor, boolean allowMessageType) {
        Descriptors.FieldDescriptor fieldDescriptor = parentDescriptor.findFieldByName(this.fieldName);
        this.validate(parentDescriptor, fieldDescriptor, allowMessageType);
        return Collections.singletonList(fieldDescriptor);
    }

    public void validate(@Nonnull Descriptors.Descriptor parentDescriptor, Descriptors.FieldDescriptor fieldDescriptor, boolean allowMessageType) {
        if (fieldDescriptor == null) {
            throw new KeyExpression.InvalidExpressionException("Descriptor " + parentDescriptor.getName() + " does not have field: " + this.fieldName);
        }
        switch (this.fanType) {
            case FanOut: 
            case Concatenate: {
                if (fieldDescriptor.isRepeated()) break;
                throw new KeyExpression.InvalidExpressionException(this.fieldName + " is not repeated with FanType." + String.valueOf((Object)this.fanType));
            }
            case None: {
                if (!fieldDescriptor.isRepeated()) break;
                throw new KeyExpression.InvalidExpressionException(this.fieldName + " is repeated with FanType.None");
            }
            default: {
                throw new KeyExpression.InvalidExpressionException("Unexpected FanType." + String.valueOf((Object)this.fanType));
            }
        }
        if (!allowMessageType && fieldDescriptor.getJavaType() == Descriptors.FieldDescriptor.JavaType.MESSAGE && !TupleFieldsHelper.isTupleField(fieldDescriptor.getMessageType())) {
            throw new Query.InvalidExpressionException(this.fieldName + " is a nested message, but accessed as a scalar");
        }
    }

    @Override
    @Nonnull
    public <M extends Message> List<Key.Evaluated> evaluateMessage(@Nullable FDBRecord<M> record, @Nullable Message message) {
        if (message == null) {
            return this.getNullResult();
        }
        Descriptors.Descriptor recordDescriptor = message.getDescriptorForType();
        Descriptors.FieldDescriptor fieldDescriptor = recordDescriptor.findFieldByName(this.fieldName);
        if (fieldDescriptor != null && fieldDescriptor.isRepeated()) {
            List values = message.getRepeatedFieldCount(fieldDescriptor) > 0 ? (List)message.getField(fieldDescriptor) : Collections.emptyList();
            switch (this.fanType) {
                case FanOut: {
                    return Key.Evaluated.fan(values);
                }
                case Concatenate: {
                    return Collections.singletonList(Key.Evaluated.scalar(values));
                }
                case None: {
                    throw new RecordCoreException("FanType.None with repeated field", new Object[0]);
                }
            }
            throw new RecordCoreException("unknown fan type", new Object[0]).addLogInfo(new Object[]{LogMessageKeys.VALUE, this.fanType});
        }
        if (fieldDescriptor != null && (this.nullStandin == Key.Evaluated.NullStandin.NOT_NULL || message.hasField(fieldDescriptor))) {
            Object value = message.getField(fieldDescriptor);
            if (fieldDescriptor.getJavaType() == Descriptors.FieldDescriptor.JavaType.MESSAGE && TupleFieldsHelper.isTupleField(fieldDescriptor.getMessageType())) {
                value = TupleFieldsHelper.fromProto((Message)value, fieldDescriptor.getMessageType());
            }
            return Collections.singletonList(Key.Evaluated.scalar(value));
        }
        return this.getNullResult();
    }

    private List<Key.Evaluated> getNullResult() {
        switch (this.fanType) {
            case FanOut: {
                return Collections.emptyList();
            }
            case Concatenate: {
                return Collections.singletonList(Key.Evaluated.scalar(Collections.emptyList()));
            }
            case None: {
                return Collections.singletonList(Key.Evaluated.scalar((Object)this.nullStandin));
            }
        }
        throw new RecordCoreException("unknown fan type", new Object[0]).addLogInfo(new Object[]{LogMessageKeys.VALUE, this.fanType});
    }

    @Override
    public boolean createsDuplicates() {
        return this.fanType == KeyExpression.FanType.FanOut;
    }

    @Override
    public int getColumnSize() {
        return 1;
    }

    @Override
    @Nonnull
    public RecordKeyExpressionProto.Field toProto() throws KeyExpression.SerializationException {
        return RecordKeyExpressionProto.Field.newBuilder().setFieldName(this.fieldName).setFanType(this.fanType.toProto()).setNullInterpretation(this.nullStandin.toProto()).build();
    }

    @Override
    @Nonnull
    public RecordKeyExpressionProto.KeyExpression toKeyExpression() {
        return RecordKeyExpressionProto.KeyExpression.newBuilder().setField(this.toProto()).build();
    }

    @Override
    @Nonnull
    public <S extends KeyExpressionVisitor.State, R> R expand(@Nonnull KeyExpressionVisitor<S, R> visitor) {
        return visitor.visitExpression(this);
    }

    @Nonnull
    public Quantifier.ForEach explodeField(@Nonnull Quantifier.ForEach baseQuantifier, @Nonnull List<String> fieldNamePrefix) {
        ImmutableCollection fieldNames = ((ImmutableList.Builder)((ImmutableList.Builder)ImmutableList.builder().addAll(fieldNamePrefix)).add(this.fieldName)).build();
        switch (this.fanType) {
            case FanOut: {
                return Quantifier.forEach(Reference.initialOf((RelationalExpression)ExplodeExpression.explodeField(baseQuantifier, (List<String>)((Object)fieldNames))));
            }
        }
        throw new RecordCoreException("unrecognized fan type", new Object[0]);
    }

    @Nonnull
    public String getFieldName() {
        return this.fieldName;
    }

    @Nonnull
    public NestingKeyExpression nest(@Nonnull String fieldName) {
        return this.nest(fieldName, KeyExpression.FanType.None);
    }

    @Nonnull
    public NestingKeyExpression nest(@Nonnull String fieldName, @Nonnull KeyExpression.FanType fanType) {
        return this.nest(Key.Expressions.field(fieldName, fanType));
    }

    @Nonnull
    public NestingKeyExpression nest(@Nonnull KeyExpression first, @Nonnull KeyExpression second, KeyExpression ... rest) {
        return this.nest(Key.Expressions.concat(first, second, rest));
    }

    @Nonnull
    public NestingKeyExpression nest(@Nonnull KeyExpression child) {
        if (this.fanType == KeyExpression.FanType.Concatenate) {
            throw new KeyExpression.InvalidExpressionException("Concatenated fields cannot nest");
        }
        return new NestingKeyExpression(this, child);
    }

    @Nonnull
    public GroupingKeyExpression ungrouped() {
        return new GroupingKeyExpression(this, 1);
    }

    @Nonnull
    public GroupingKeyExpression groupBy(@Nonnull KeyExpression groupByFirst, KeyExpression ... groupByRest) {
        return GroupingKeyExpression.of(this, groupByFirst, groupByRest);
    }

    @Nonnull
    public SplitKeyExpression split(int splitSize) {
        return new SplitKeyExpression(this, splitSize);
    }

    @Nonnull
    public Descriptors.Descriptor getDescriptor(@Nonnull Descriptors.Descriptor parentDescriptor) {
        Descriptors.FieldDescriptor field = parentDescriptor.findFieldByName(this.fieldName);
        return field.getMessageType();
    }

    @Nonnull
    public KeyExpression.FanType getFanType() {
        return this.fanType;
    }

    @Nonnull
    public Key.Evaluated.NullStandin getNullStandin() {
        return this.nullStandin;
    }

    public String toString() {
        return "Field { '" + this.fieldName + "' " + String.valueOf((Object)this.fanType) + "}";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o == null || !(o instanceof FieldKeyExpression)) {
            return false;
        }
        FieldKeyExpression that = (FieldKeyExpression)o;
        return this.fieldName.equals(that.fieldName) && this.fanType == that.fanType;
    }

    public int hashCode() {
        return this.fieldName.hashCode() + this.fanType.name().hashCode();
    }

    @Override
    public int planHash(@Nonnull PlanHashable.PlanHashMode mode) {
        switch (mode.getKind()) {
            case LEGACY: {
                return this.fieldName.hashCode() + this.fanType.name().hashCode();
            }
            case FOR_CONTINUATION: {
                return PlanHashable.objectsPlanHash(mode, new Object[]{BASE_HASH, this.fieldName, this.fanType});
            }
        }
        throw new UnsupportedOperationException("Hash kind " + String.valueOf((Object)mode.getKind()) + " is not supported");
    }

    @Override
    public boolean equalsAtomic(AtomKeyExpression other) {
        return this.equals(other);
    }
}

