/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record.metadata.expressions;

import com.apple.foundationdb.annotation.API;
import com.apple.foundationdb.record.ObjectPlanHash;
import com.apple.foundationdb.record.PlanHashable;
import com.apple.foundationdb.record.RecordCoreArgumentException;
import com.apple.foundationdb.record.RecordCoreException;
import com.apple.foundationdb.record.expressions.RecordKeyExpressionProto;
import com.apple.foundationdb.record.logging.LogMessageKeys;
import com.apple.foundationdb.record.metadata.Key;
import com.apple.foundationdb.record.metadata.expressions.AtomKeyExpression;
import com.apple.foundationdb.record.metadata.expressions.BaseKeyExpression;
import com.apple.foundationdb.record.metadata.expressions.GroupingKeyExpression;
import com.apple.foundationdb.record.metadata.expressions.KeyExpression;
import com.apple.foundationdb.record.metadata.expressions.KeyExpressionWithChild;
import com.apple.foundationdb.record.provider.foundationdb.FDBRecord;
import com.apple.foundationdb.record.query.plan.cascades.BuiltInFunction;
import com.apple.foundationdb.record.query.plan.cascades.KeyExpressionVisitor;
import com.apple.foundationdb.record.query.plan.cascades.typing.Typed;
import com.apple.foundationdb.record.query.plan.cascades.values.BuiltInFunctionCatalog;
import com.apple.foundationdb.record.query.plan.cascades.values.Value;
import com.apple.foundationdb.record.util.ServiceLoaderProvider;
import com.google.protobuf.Descriptors;
import com.google.protobuf.Message;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.ServiceConfigurationError;
import java.util.function.BiFunction;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@API(value=API.Status.EXPERIMENTAL)
public abstract class FunctionKeyExpression
extends BaseKeyExpression
implements AtomKeyExpression,
KeyExpressionWithChild {
    @Nonnull
    protected final String name;
    @Nonnull
    protected final KeyExpression arguments;

    protected FunctionKeyExpression(@Nonnull String name, @Nonnull KeyExpression arguments) {
        this.name = name;
        this.arguments = arguments;
    }

    public static FunctionKeyExpression create(@Nonnull String name, @Nonnull KeyExpression arguments) {
        Optional<Builder> funcBuilder = Registry.instance().getBuilder(name);
        if (funcBuilder.isEmpty()) {
            throw new KeyExpression.InvalidExpressionException("Function not defined").addLogInfo(new Object[]{LogMessageKeys.FUNCTION, name});
        }
        FunctionKeyExpression function = funcBuilder.get().build(arguments);
        int argumentCount = arguments.getColumnSize();
        if (argumentCount < function.getMinArguments() || argumentCount > function.getMaxArguments()) {
            throw new KeyExpression.InvalidExpressionException("Invalid number of arguments provided to function", new Object[]{LogMessageKeys.FUNCTION, name, "args_provided", argumentCount, "min_args_expected", function.getMinArguments(), "max_args_expected", function.getMaxArguments()});
        }
        return function;
    }

    @Nonnull
    public final String getName() {
        return this.name;
    }

    @Override
    @Nonnull
    public KeyExpression getChild() {
        return this.getArguments();
    }

    @Nonnull
    public final KeyExpression getArguments() {
        return this.arguments;
    }

    public abstract int getMinArguments();

    public abstract int getMaxArguments();

    @Nonnull
    public GroupingKeyExpression groupBy(@Nonnull KeyExpression groupByFirst, KeyExpression ... groupByRest) {
        return GroupingKeyExpression.of(this, groupByFirst, groupByRest);
    }

    @Override
    @Nonnull
    public <M extends Message> List<Key.Evaluated> evaluateMessage(@Nullable FDBRecord<M> record, @Nullable Message message) {
        List<Key.Evaluated> evaluatedArguments = this.getArguments().evaluateMessage(record, message);
        ArrayList<Key.Evaluated> results = new ArrayList<Key.Evaluated>(evaluatedArguments.size());
        for (Key.Evaluated evaluatedArgument : evaluatedArguments) {
            this.validateArgumentCount(evaluatedArgument);
            results.addAll(this.evaluateFunction(record, message, evaluatedArgument));
        }
        this.validateColumnCounts(results);
        return results;
    }

    @Nonnull
    public abstract <M extends Message> List<Key.Evaluated> evaluateFunction(@Nullable FDBRecord<M> var1, @Nullable Message var2, @Nonnull Key.Evaluated var3);

    private void validateArgumentCount(Key.Evaluated arguments) {
        int argumentCount = arguments.size();
        if (argumentCount < this.getMinArguments() || argumentCount > this.getMaxArguments()) {
            throw new KeyExpression.InvalidResultException("Invalid number of arguments provided to function").addLogInfo(new Object[]{LogMessageKeys.FUNCTION, this.getName(), "args_provided", argumentCount, "min_args_expected", this.getMinArguments(), "max_args_expected", this.getMaxArguments()});
        }
    }

    @Override
    public List<Descriptors.FieldDescriptor> validate(@Nonnull Descriptors.Descriptor descriptor) {
        return this.getArguments().validate(descriptor);
    }

    @Override
    public boolean equalsAtomic(AtomKeyExpression other) {
        return this.equals(other);
    }

    @Nonnull
    public static FunctionKeyExpression fromProto(RecordKeyExpressionProto.Function function) throws KeyExpression.DeserializationException {
        try {
            return FunctionKeyExpression.create(function.getName(), KeyExpression.fromProto(function.getArguments()));
        }
        catch (RecordCoreException e) {
            throw new KeyExpression.DeserializationException(e.getMessage(), e);
        }
    }

    @Override
    @Nonnull
    public final RecordKeyExpressionProto.Function toProto() throws KeyExpression.SerializationException {
        RecordKeyExpressionProto.Function.Builder builder = RecordKeyExpressionProto.Function.newBuilder().setName(this.getName());
        builder.setArguments(this.getArguments().toKeyExpression());
        return builder.build();
    }

    @Override
    @Nonnull
    public final RecordKeyExpressionProto.KeyExpression toKeyExpression() {
        return RecordKeyExpressionProto.KeyExpression.newBuilder().setFunction(this.toProto()).build();
    }

    @Override
    @Nonnull
    public <S extends KeyExpressionVisitor.State, R> R expand(@Nonnull KeyExpressionVisitor<S, R> visitor) {
        return visitor.visitExpression(this);
    }

    @Nonnull
    public abstract Value toValue(@Nonnull List<? extends Value> var1);

    @Nonnull
    protected Value resolveAndEncapsulateFunction(@Nonnull String functionName, @Nonnull List<? extends Value> argumentValues) {
        BuiltInFunction<? extends Typed> builtInFunction = BuiltInFunctionCatalog.resolve(functionName, argumentValues.size()).orElseThrow(() -> new RecordCoreArgumentException("unknown function", new Object[]{LogMessageKeys.FUNCTION, this.getName()}));
        return (Value)builtInFunction.encapsulate(argumentValues);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof FunctionKeyExpression)) {
            return false;
        }
        FunctionKeyExpression that = (FunctionKeyExpression)o;
        if (!this.getName().equals(that.getName())) {
            return false;
        }
        return this.getArguments().equals(that.getArguments());
    }

    public int hashCode() {
        return Objects.hash(this.getName(), this.getArguments());
    }

    protected int basePlanHash(@Nonnull PlanHashable.PlanHashMode mode, ObjectPlanHash baseHash, Object ... hashables) {
        switch (mode.getKind()) {
            case LEGACY: {
                return this.getName().hashCode() + this.getArguments().planHash(mode);
            }
            case FOR_CONTINUATION: {
                return PlanHashable.objectsPlanHash(mode, baseHash, this.getName(), this.getArguments(), hashables);
            }
        }
        throw new UnsupportedOperationException("Hash kind " + String.valueOf((Object)mode.getKind()) + " is not supported");
    }

    public String toString() {
        return this.getName() + "(" + String.valueOf(this.getArguments()) + ")";
    }

    public static class Registry {
        private static final Registry INSTANCE = new Registry();
        @Nullable
        private volatile Map<String, Builder> functions = null;

        private Registry() {
        }

        @Nonnull
        public static Registry instance() {
            return INSTANCE;
        }

        public Optional<Builder> getBuilder(String name) {
            Map<String, Builder> registry = this.initOrGetRegistry();
            return Optional.ofNullable(registry.get(name));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Nonnull
        private Map<String, Builder> initOrGetRegistry() {
            Map<String, Builder> currRegistry = this.functions;
            if (currRegistry != null) {
                return currRegistry;
            }
            Registry registry = this;
            synchronized (registry) {
                currRegistry = this.functions;
                if (currRegistry == null) {
                    Map<String, Builder> newRegistry = Registry.initRegistry();
                    this.functions = newRegistry;
                    return newRegistry;
                }
                return currRegistry;
            }
        }

        @Nonnull
        private static Map<String, Builder> initRegistry() {
            try {
                HashMap<String, Builder> functions = new HashMap<String, Builder>();
                for (Factory factory : ServiceLoaderProvider.load(Factory.class)) {
                    for (Builder function : factory.getBuilders()) {
                        if (functions.containsKey(function.getName())) {
                            throw new RecordCoreException("Function already defined", new Object[0]).addLogInfo(new Object[]{LogMessageKeys.FUNCTION, function.getName()});
                        }
                        functions.put(function.getName(), function);
                    }
                }
                return functions;
            }
            catch (ServiceConfigurationError err) {
                throw new RecordCoreException("Unable to load all defined FunctionKeyExpressions", err);
            }
        }
    }

    public static abstract class Builder {
        @Nonnull
        protected final String functionName;

        public Builder(@Nonnull String functionName) {
            this.functionName = functionName;
        }

        @Nonnull
        public String getName() {
            return this.functionName;
        }

        @Nonnull
        public abstract FunctionKeyExpression build(@Nonnull KeyExpression var1);
    }

    public static interface Factory {
        @Nonnull
        public List<Builder> getBuilders();
    }

    public static class BiFunctionBuilder
    extends Builder {
        private final BiFunction<String, KeyExpression, FunctionKeyExpression> generator;

        public BiFunctionBuilder(@Nonnull String functionName, @Nonnull BiFunction<String, KeyExpression, FunctionKeyExpression> generator) {
            super(functionName);
            this.generator = generator;
        }

        @Override
        @Nonnull
        public FunctionKeyExpression build(@Nonnull KeyExpression expression) {
            return this.generator.apply(super.getName(), expression);
        }
    }
}

