/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record.metadata.expressions;

import com.apple.foundationdb.annotation.API;
import com.apple.foundationdb.record.ObjectPlanHash;
import com.apple.foundationdb.record.PlanHashable;
import com.apple.foundationdb.record.expressions.RecordKeyExpressionProto;
import com.apple.foundationdb.record.metadata.Key;
import com.apple.foundationdb.record.metadata.expressions.BaseKeyExpression;
import com.apple.foundationdb.record.metadata.expressions.KeyExpression;
import com.apple.foundationdb.record.metadata.expressions.KeyExpressionWithChild;
import com.apple.foundationdb.record.provider.foundationdb.FDBRecord;
import com.apple.foundationdb.record.query.plan.cascades.KeyExpressionVisitor;
import com.google.protobuf.Descriptors;
import com.google.protobuf.Message;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@API(value=API.Status.UNSTABLE)
public class GroupingKeyExpression
extends BaseKeyExpression
implements KeyExpressionWithChild {
    private static final ObjectPlanHash BASE_HASH = new ObjectPlanHash("Grouping-Key-Expression");
    @Nonnull
    private final KeyExpression wholeKey;
    private final int groupedCount;

    public GroupingKeyExpression(@Nonnull KeyExpression wholeKey, int groupedCount) {
        this.wholeKey = wholeKey;
        this.groupedCount = groupedCount;
    }

    public GroupingKeyExpression(@Nonnull RecordKeyExpressionProto.Grouping grouping) throws KeyExpression.DeserializationException {
        this(KeyExpression.fromProto(grouping.getWholeKey()), grouping.getGroupedCount());
    }

    public static GroupingKeyExpression of(@Nonnull KeyExpression groupedValue, @Nonnull KeyExpression groupByFirst, KeyExpression ... groupByRest) {
        KeyExpression wholeKeySecond;
        KeyExpression wholeKeyFirst = groupByFirst;
        KeyExpression[] wholeKeyRest = new KeyExpression[groupByRest.length];
        if (wholeKeyRest.length == 0) {
            wholeKeySecond = groupedValue;
        } else {
            wholeKeySecond = groupByRest[0];
            System.arraycopy(groupByRest, 1, wholeKeyRest, 0, groupByRest.length - 1);
            wholeKeyRest[wholeKeyRest.length - 1] = groupedValue;
        }
        return new GroupingKeyExpression(Key.Expressions.concat(wholeKeyFirst, wholeKeySecond, wholeKeyRest), groupedValue.getColumnSize());
    }

    @Override
    @Nonnull
    public <M extends Message> List<Key.Evaluated> evaluateMessage(@Nullable FDBRecord<M> record, @Nullable Message message) {
        return this.getWholeKey().evaluateMessage(record, message);
    }

    @Override
    public boolean createsDuplicates() {
        return this.getWholeKey().createsDuplicates();
    }

    @Override
    public List<Descriptors.FieldDescriptor> validate(@Nonnull Descriptors.Descriptor descriptor) {
        return this.getWholeKey().validate(descriptor);
    }

    @Override
    public int getColumnSize() {
        return this.getWholeKey().getColumnSize();
    }

    @Override
    public boolean needsCopyingToPartialRecord() {
        return this.getWholeKey().needsCopyingToPartialRecord();
    }

    @Override
    @Nonnull
    public RecordKeyExpressionProto.Grouping toProto() throws KeyExpression.SerializationException {
        RecordKeyExpressionProto.Grouping.Builder builder = RecordKeyExpressionProto.Grouping.newBuilder();
        builder.setWholeKey(this.getWholeKey().toKeyExpression());
        builder.setGroupedCount(this.groupedCount);
        return builder.build();
    }

    @Override
    @Nonnull
    public RecordKeyExpressionProto.KeyExpression toKeyExpression() {
        return RecordKeyExpressionProto.KeyExpression.newBuilder().setGrouping(this.toProto()).build();
    }

    @Override
    @Nonnull
    public List<KeyExpression> normalizeKeyForPositions() {
        return this.getWholeKey().normalizeKeyForPositions();
    }

    @Override
    public boolean hasLosslessNormalization() {
        return this.getWholeKey().hasLosslessNormalization();
    }

    @Override
    @Nonnull
    public <S extends KeyExpressionVisitor.State, R> R expand(@Nonnull KeyExpressionVisitor<S, R> visitor) {
        return visitor.visitExpression(this);
    }

    @Override
    public int versionColumns() {
        return this.getWholeKey().versionColumns();
    }

    @Override
    public boolean hasRecordTypeKey() {
        return this.getWholeKey().hasRecordTypeKey();
    }

    @Nonnull
    public KeyExpression getWholeKey() {
        return this.wholeKey;
    }

    @Override
    @Nonnull
    public KeyExpression getChild() {
        return this.getGroupingSubKey();
    }

    public int getGroupedCount() {
        return this.groupedCount;
    }

    public int getGroupingCount() {
        return this.getColumnSize() - this.groupedCount;
    }

    @Nonnull
    public KeyExpression getGroupedSubKey() {
        return this.getWholeKey().getSubKey(this.getGroupingCount(), this.getColumnSize());
    }

    @Nonnull
    public KeyExpression getGroupingSubKey() {
        return this.getWholeKey().getSubKey(0, this.getGroupingCount());
    }

    public String toString() {
        StringBuilder str = new StringBuilder(this.getWholeKey().toString());
        str.append(" group ").append(this.groupedCount);
        return str.toString();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GroupingKeyExpression that = (GroupingKeyExpression)o;
        return this.getWholeKey().equals(that.getWholeKey()) && this.groupedCount == that.groupedCount;
    }

    public int hashCode() {
        int hash = this.getWholeKey().hashCode();
        return hash += this.groupedCount;
    }

    @Override
    public int planHash(@Nonnull PlanHashable.PlanHashMode mode) {
        switch (mode.getKind()) {
            case LEGACY: {
                return this.getWholeKey().planHash(mode) + this.groupedCount;
            }
            case FOR_CONTINUATION: {
                return PlanHashable.objectsPlanHash(mode, BASE_HASH, this.getWholeKey(), this.groupedCount);
            }
        }
        throw new UnsupportedOperationException("Hash kind " + String.valueOf((Object)mode.getKind()) + " is not supported");
    }
}

