/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record.metadata.expressions;

import com.apple.foundationdb.annotation.API;
import com.apple.foundationdb.record.PlanHashable;
import com.apple.foundationdb.record.RecordCoreException;
import com.apple.foundationdb.record.expressions.RecordKeyExpressionProto;
import com.apple.foundationdb.record.metadata.Key;
import com.apple.foundationdb.record.metadata.expressions.BaseKeyExpression;
import com.apple.foundationdb.record.metadata.expressions.DimensionsKeyExpression;
import com.apple.foundationdb.record.metadata.expressions.EmptyKeyExpression;
import com.apple.foundationdb.record.metadata.expressions.FieldKeyExpression;
import com.apple.foundationdb.record.metadata.expressions.FunctionKeyExpression;
import com.apple.foundationdb.record.metadata.expressions.GroupingKeyExpression;
import com.apple.foundationdb.record.metadata.expressions.KeyExpressionWithChildren;
import com.apple.foundationdb.record.metadata.expressions.KeyExpressionWithoutChildren;
import com.apple.foundationdb.record.metadata.expressions.KeyWithValueExpression;
import com.apple.foundationdb.record.metadata.expressions.ListKeyExpression;
import com.apple.foundationdb.record.metadata.expressions.LiteralKeyExpression;
import com.apple.foundationdb.record.metadata.expressions.NestingKeyExpression;
import com.apple.foundationdb.record.metadata.expressions.RecordTypeKeyExpression;
import com.apple.foundationdb.record.metadata.expressions.SplitKeyExpression;
import com.apple.foundationdb.record.metadata.expressions.ThenKeyExpression;
import com.apple.foundationdb.record.metadata.expressions.VersionKeyExpression;
import com.apple.foundationdb.record.provider.foundationdb.FDBRecord;
import com.apple.foundationdb.record.query.plan.cascades.KeyExpressionVisitor;
import com.google.protobuf.Descriptors;
import com.google.protobuf.Message;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@API(value=API.Status.UNSTABLE)
public interface KeyExpression
extends PlanHashable {
    @Nonnull
    default public <M extends Message> List<Key.Evaluated> evaluate(@Nullable FDBRecord<M> record) {
        return this.evaluateMessage(record, record == null ? null : (Message)record.getRecord());
    }

    @Nonnull
    default public <M extends Message> Key.Evaluated evaluateSingleton(@Nullable FDBRecord<M> record) {
        List<Key.Evaluated> keys = this.evaluate(record);
        if (keys.size() != 1) {
            throw new RecordCoreException("Should evaluate to single key only", new Object[0]);
        }
        return keys.get(0);
    }

    @Nonnull
    default public <M extends Message> Key.Evaluated evaluateMessageSingleton(@Nullable FDBRecord<M> record, @Nullable Message message) {
        List<Key.Evaluated> keys = this.evaluateMessage(record, message);
        if (keys.size() != 1) {
            throw new RecordCoreException("Should evaluate to single key only", new Object[0]);
        }
        return keys.get(0);
    }

    @Nonnull
    public <M extends Message> List<Key.Evaluated> evaluateMessage(@Nullable FDBRecord<M> var1, @Nullable Message var2);

    public boolean createsDuplicates();

    public List<Descriptors.FieldDescriptor> validate(@Nonnull Descriptors.Descriptor var1);

    public int getColumnSize();

    @Nonnull
    public Message toProto() throws SerializationException;

    @Nonnull
    public RecordKeyExpressionProto.KeyExpression toKeyExpression();

    @Nonnull
    default public List<KeyExpression> normalizeKeyForPositions() {
        return Collections.singletonList(this);
    }

    @API(value=API.Status.INTERNAL)
    default public boolean hasLosslessNormalization() {
        return true;
    }

    @API(value=API.Status.INTERNAL)
    default public boolean needsCopyingToPartialRecord() {
        return true;
    }

    @Nonnull
    @API(value=API.Status.EXPERIMENTAL)
    public <S extends KeyExpressionVisitor.State, R> R expand(@Nonnull KeyExpressionVisitor<S, R> var1);

    @API(value=API.Status.EXPERIMENTAL)
    public static List<KeyExpression> getKeyFields(@Nonnull KeyExpression rootExpression) {
        List<KeyExpression> normalizedKeys = rootExpression.normalizeKeyForPositions();
        if (rootExpression instanceof KeyWithValueExpression) {
            KeyWithValueExpression keyWithValue = (KeyWithValueExpression)rootExpression;
            return new ArrayList<KeyExpression>(normalizedKeys.subList(0, keyWithValue.getSplitPoint()));
        }
        return new ArrayList<KeyExpression>(normalizedKeys);
    }

    @API(value=API.Status.EXPERIMENTAL)
    public static List<KeyExpression> getValueFields(@Nonnull KeyExpression rootExpression) {
        if (rootExpression instanceof KeyWithValueExpression) {
            List<KeyExpression> normalizedKeys = rootExpression.normalizeKeyForPositions();
            KeyWithValueExpression keyWithValue = (KeyWithValueExpression)rootExpression;
            return new ArrayList<KeyExpression>(normalizedKeys.subList(keyWithValue.getSplitPoint(), normalizedKeys.size()));
        }
        return Collections.singletonList(EmptyKeyExpression.EMPTY);
    }

    default public int versionColumns() {
        return 0;
    }

    default public boolean hasRecordTypeKey() {
        return false;
    }

    @Nonnull
    public KeyExpression getSubKey(int var1, int var2);

    public boolean isPrefixKey(@Nonnull KeyExpression var1);

    default public boolean hasProperInterfaces() {
        return this instanceof KeyExpressionWithChildren || this instanceof KeyExpressionWithoutChildren;
    }

    @Nonnull
    public static KeyExpression fromProto(RecordKeyExpressionProto.KeyExpression expression) throws DeserializationException {
        BaseKeyExpression root = null;
        int found = 0;
        if (expression.hasField()) {
            ++found;
            root = new FieldKeyExpression(expression.getField());
        }
        if (expression.hasNesting()) {
            ++found;
            root = new NestingKeyExpression(expression.getNesting());
        }
        if (expression.hasThen()) {
            ++found;
            root = new ThenKeyExpression(expression.getThen());
        }
        if (expression.hasList()) {
            ++found;
            root = new ListKeyExpression(expression.getList());
        }
        if (expression.hasGrouping()) {
            ++found;
            root = new GroupingKeyExpression(expression.getGrouping());
        }
        if (expression.hasSplit()) {
            ++found;
            root = new SplitKeyExpression(expression.getSplit());
        }
        if (expression.hasEmpty()) {
            ++found;
            root = EmptyKeyExpression.EMPTY;
        }
        if (expression.hasVersion()) {
            ++found;
            root = VersionKeyExpression.VERSION;
        }
        if (expression.hasValue()) {
            ++found;
            root = LiteralKeyExpression.fromProto(expression.getValue());
        }
        if (expression.hasFunction()) {
            ++found;
            root = FunctionKeyExpression.fromProto(expression.getFunction());
        }
        if (expression.hasKeyWithValue()) {
            ++found;
            root = new KeyWithValueExpression(expression.getKeyWithValue());
        }
        if (expression.hasRecordTypeKey()) {
            ++found;
            root = RecordTypeKeyExpression.RECORD_TYPE_KEY;
        }
        if (expression.hasDimensions()) {
            ++found;
            root = new DimensionsKeyExpression(expression.getDimensions());
        }
        if (root == null || found > 1) {
            throw new DeserializationException("Exactly one root must be specified for an index");
        }
        return root;
    }

    @Nonnull
    public static KeyExpression fromPath(@Nonnull List<String> path) {
        if (path.isEmpty()) {
            throw new InvalidExpressionException("attempt to create key expression using empty path");
        }
        String fieldName = path.get(path.size() - 1);
        BaseKeyExpression keyExpression = Key.Expressions.field(fieldName);
        List<String> fieldPrefix = path.subList(0, path.size() - 1);
        for (int i = fieldPrefix.size() - 1; i >= 0; --i) {
            keyExpression = Key.Expressions.field(fieldPrefix.get(i)).nest(keyExpression);
        }
        return keyExpression;
    }

    public static class DeserializationException
    extends RecordCoreException {
        public DeserializationException(@Nonnull String message) {
            super(message, new Object[0]);
        }

        public DeserializationException(@Nonnull String message, @Nullable Exception cause) {
            super(message, cause);
        }
    }

    public static class InvalidExpressionException
    extends RecordCoreException {
        public InvalidExpressionException(String message) {
            super(message, new Object[0]);
        }

        public InvalidExpressionException(String message, Object ... keyValues) {
            super(message, keyValues);
        }
    }

    public static class NoSuchArgumentException
    extends RecordCoreException {
        public NoSuchArgumentException(String message) {
            super(message, new Object[0]);
        }
    }

    public static class InvalidResultException
    extends RecordCoreException {
        public InvalidResultException(String message) {
            super(message, new Object[0]);
        }
    }

    public static class SerializationException
    extends RecordCoreException {
        public SerializationException(@Nonnull String message) {
            super(message, new Object[0]);
        }

        public SerializationException(@Nonnull String message, @Nullable Exception cause) {
            super(message, cause);
        }
    }

    public static enum FanType {
        Concatenate(RecordKeyExpressionProto.Field.FanType.CONCATENATE),
        FanOut(RecordKeyExpressionProto.Field.FanType.FAN_OUT),
        None(RecordKeyExpressionProto.Field.FanType.SCALAR);

        private RecordKeyExpressionProto.Field.FanType proto;

        private FanType(RecordKeyExpressionProto.Field.FanType fanType) {
            this.proto = fanType;
        }

        RecordKeyExpressionProto.Field.FanType toProto() {
            return this.proto;
        }

        public static FanType valueOf(RecordKeyExpressionProto.Field.FanType fanType) throws DeserializationException {
            switch (fanType) {
                case SCALAR: {
                    return None;
                }
                case FAN_OUT: {
                    return FanOut;
                }
                case CONCATENATE: {
                    return Concatenate;
                }
            }
            throw new DeserializationException("Invalid fan type " + String.valueOf(fanType));
        }
    }
}

