/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record.metadata.expressions;

import com.apple.foundationdb.annotation.API;
import com.apple.foundationdb.record.ObjectPlanHash;
import com.apple.foundationdb.record.PlanHashable;
import com.apple.foundationdb.record.expressions.RecordKeyExpressionProto;
import com.apple.foundationdb.record.metadata.Key;
import com.apple.foundationdb.record.metadata.expressions.BaseKeyExpression;
import com.apple.foundationdb.record.metadata.expressions.EmptyKeyExpression;
import com.apple.foundationdb.record.metadata.expressions.KeyExpression;
import com.apple.foundationdb.record.metadata.expressions.KeyExpressionWithChild;
import com.apple.foundationdb.record.metadata.expressions.ThenKeyExpression;
import com.apple.foundationdb.record.provider.foundationdb.FDBRecord;
import com.apple.foundationdb.record.query.plan.cascades.KeyExpressionVisitor;
import com.google.protobuf.Descriptors;
import com.google.protobuf.Message;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@API(value=API.Status.UNSTABLE)
public class KeyWithValueExpression
extends BaseKeyExpression
implements KeyExpressionWithChild {
    private static final ObjectPlanHash BASE_HASH = new ObjectPlanHash("Key-With-Value-Expression");
    @Nonnull
    private final KeyExpression innerKey;
    private final int splitPoint;
    @Nullable
    private List<KeyExpression> normalizedKeys;
    @Nullable
    private KeyExpression keyExpression;
    @Nullable
    private KeyExpression valueExpression;

    public KeyWithValueExpression(@Nonnull KeyExpression innerKey, int splitPoint) {
        this.innerKey = innerKey;
        this.splitPoint = splitPoint;
    }

    public KeyWithValueExpression(@Nonnull RecordKeyExpressionProto.KeyWithValue proto) throws KeyExpression.DeserializationException {
        this(KeyExpression.fromProto(proto.getInnerKey()), proto.getSplitPoint());
    }

    @Override
    @Nonnull
    public <M extends Message> List<Key.Evaluated> evaluateMessage(@Nullable FDBRecord<M> record, @Nullable Message message) {
        return this.getInnerKey().evaluateMessage(record, message);
    }

    @Override
    public boolean createsDuplicates() {
        return this.getInnerKey().createsDuplicates();
    }

    @Override
    public List<Descriptors.FieldDescriptor> validate(@Nonnull Descriptors.Descriptor descriptor) {
        KeyExpression key = this.getInnerKey();
        if (key.getColumnSize() < this.splitPoint) {
            throw new KeyExpression.InvalidExpressionException("Child expression of covering expression returns too few columns").addLogInfo("split_point", this.splitPoint, "child_columns", key.getColumnSize());
        }
        return key.validate(descriptor);
    }

    @Override
    public int getColumnSize() {
        return this.getSplitPoint();
    }

    @Override
    @Nonnull
    protected KeyExpression getSubKeyImpl(int start, int end) {
        return this.getInnerKey().getSubKey(start, end);
    }

    @Nonnull
    public KeyExpression getKeyExpression() {
        if (this.keyExpression == null) {
            this.keyExpression = this.getInnerKey().getSubKey(0, this.splitPoint);
        }
        return this.keyExpression;
    }

    @Nonnull
    public KeyExpression getValueExpression() {
        if (this.valueExpression == null) {
            List<KeyExpression> allKeys = this.normalizeKeyForPositions();
            this.valueExpression = this.splitPoint == allKeys.size() ? EmptyKeyExpression.EMPTY : new ThenKeyExpression(allKeys, this.splitPoint, allKeys.size());
        }
        return this.valueExpression;
    }

    public int getChildColumnSize() {
        return this.getInnerKey().getColumnSize();
    }

    @Override
    public boolean needsCopyingToPartialRecord() {
        return this.getInnerKey().needsCopyingToPartialRecord();
    }

    @Override
    @Nonnull
    public RecordKeyExpressionProto.KeyWithValue toProto() throws KeyExpression.SerializationException {
        return RecordKeyExpressionProto.KeyWithValue.newBuilder().setInnerKey(this.getInnerKey().toKeyExpression()).setSplitPoint(this.splitPoint).build();
    }

    @Override
    @Nonnull
    public RecordKeyExpressionProto.KeyExpression toKeyExpression() {
        return RecordKeyExpressionProto.KeyExpression.newBuilder().setKeyWithValue(this.toProto()).build();
    }

    @Override
    @Nonnull
    public <S extends KeyExpressionVisitor.State, R> R expand(@Nonnull KeyExpressionVisitor<S, R> visitor) {
        return visitor.visitExpression(this);
    }

    @Override
    @Nonnull
    public List<KeyExpression> normalizeKeyForPositions() {
        if (this.normalizedKeys == null) {
            this.normalizedKeys = this.getInnerKey().normalizeKeyForPositions();
        }
        return this.normalizedKeys;
    }

    @Override
    public boolean hasLosslessNormalization() {
        return this.getInnerKey().hasLosslessNormalization();
    }

    @Override
    public int versionColumns() {
        return this.getInnerKey().versionColumns();
    }

    @Override
    public boolean hasRecordTypeKey() {
        return this.getInnerKey().hasRecordTypeKey();
    }

    public int getSplitPoint() {
        return this.splitPoint;
    }

    @Nonnull
    public KeyExpression getInnerKey() {
        return this.innerKey;
    }

    @Override
    @Nonnull
    public KeyExpression getChild() {
        return this.getKeyExpression();
    }

    @Nonnull
    public Key.Evaluated getKey(@Nonnull Key.Evaluated wholeKey) {
        return wholeKey.subKey(0, this.splitPoint);
    }

    @Nonnull
    public Key.Evaluated getValue(@Nonnull Key.Evaluated wholeKey) {
        return wholeKey.subKey(this.splitPoint, wholeKey.size());
    }

    public String toString() {
        return "covering(" + this.getInnerKey().toString() + " split " + this.splitPoint + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        KeyWithValueExpression that = (KeyWithValueExpression)o;
        return this.getInnerKey().equals(that.getInnerKey()) && this.splitPoint == that.splitPoint;
    }

    public int hashCode() {
        int result = this.getInnerKey().hashCode();
        result = 31 * result + this.splitPoint;
        return result;
    }

    @Override
    public int planHash(@Nonnull PlanHashable.PlanHashMode mode) {
        switch (mode.getKind()) {
            case LEGACY: {
                return this.getInnerKey().planHash(mode) + this.splitPoint;
            }
            case FOR_CONTINUATION: {
                return PlanHashable.objectsPlanHash(mode, BASE_HASH, this.getInnerKey(), this.splitPoint);
            }
        }
        throw new UnsupportedOperationException("Hash kind " + String.valueOf((Object)mode.getKind()) + " is not supported");
    }
}

