/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record.metadata.expressions;

import com.apple.foundationdb.annotation.API;
import com.apple.foundationdb.record.ObjectPlanHash;
import com.apple.foundationdb.record.PlanHashable;
import com.apple.foundationdb.record.expressions.RecordKeyExpressionProto;
import com.apple.foundationdb.record.metadata.Key;
import com.apple.foundationdb.record.metadata.expressions.BaseKeyExpression;
import com.apple.foundationdb.record.metadata.expressions.KeyExpression;
import com.apple.foundationdb.record.metadata.expressions.KeyExpressionWithChildren;
import com.apple.foundationdb.record.provider.foundationdb.FDBRecord;
import com.apple.foundationdb.record.query.plan.cascades.KeyExpressionVisitor;
import com.google.common.collect.ImmutableList;
import com.google.protobuf.Descriptors;
import com.google.protobuf.Message;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@API(value=API.Status.UNSTABLE)
public class ListKeyExpression
extends BaseKeyExpression
implements KeyExpressionWithChildren {
    private static final ObjectPlanHash BASE_HASH = new ObjectPlanHash("List-Key-Expression");
    @Nonnull
    private final List<KeyExpression> children;

    public ListKeyExpression(@Nonnull List<KeyExpression> exprs) {
        this.children = exprs;
    }

    private ListKeyExpression(@Nonnull ListKeyExpression orig, int start, int end) {
        this.children = orig.children.subList(start, end);
    }

    public ListKeyExpression(@Nonnull RecordKeyExpressionProto.List list) throws KeyExpression.DeserializationException {
        this.children = list.getChildList().stream().map(KeyExpression::fromProto).collect(Collectors.toList());
    }

    @Override
    @Nonnull
    public <M extends Message> List<Key.Evaluated> evaluateMessage(@Nullable FDBRecord<M> record, @Nullable Message message) {
        ArrayList<List<Key.Evaluated>> childrenValues = new ArrayList<List<Key.Evaluated>>(this.children.size());
        int totalCount = 1;
        for (KeyExpression child : this.children) {
            List<Key.Evaluated> childValues = child.evaluateMessage(record, message);
            childrenValues.add(childValues);
            totalCount *= childValues.size();
        }
        return this.combine(childrenValues, totalCount);
    }

    private List<Key.Evaluated> combine(@Nonnull List<List<Key.Evaluated>> childrenValues, int totalCount) {
        ArrayList<Key.Evaluated> combined = new ArrayList<Key.Evaluated>(totalCount);
        this.combine(combined, Collections.emptyList(), 0, childrenValues);
        this.validateColumnCounts(combined);
        return combined;
    }

    private void combine(@Nonnull List<Key.Evaluated> combined, @Nonnull List<Object> listSoFar, int valuesIndex, @Nonnull List<List<Key.Evaluated>> childrenValues) {
        if (valuesIndex == childrenValues.size()) {
            combined.add(Key.Evaluated.concatenate(listSoFar));
        } else {
            for (Key.Evaluated childValue : childrenValues.get(valuesIndex)) {
                ArrayList<Object> nextList = new ArrayList<Object>(listSoFar.size() + 1);
                nextList.addAll(listSoFar);
                nextList.add(childValue.toTupleAppropriateList());
                this.combine(combined, nextList, valuesIndex + 1, childrenValues);
            }
        }
    }

    @Override
    public boolean createsDuplicates() {
        return this.children.stream().anyMatch(KeyExpression::createsDuplicates);
    }

    @Override
    public List<Descriptors.FieldDescriptor> validate(@Nonnull Descriptors.Descriptor descriptor) {
        return this.children.stream().flatMap(child -> child.validate(descriptor).stream()).collect(Collectors.toList());
    }

    @Override
    public int getColumnSize() {
        return this.children.size();
    }

    @Override
    @Nonnull
    public RecordKeyExpressionProto.List toProto() throws KeyExpression.SerializationException {
        RecordKeyExpressionProto.List.Builder builder = RecordKeyExpressionProto.List.newBuilder();
        for (KeyExpression child : this.children) {
            builder.addChild(child.toKeyExpression());
        }
        return builder.build();
    }

    @Override
    @Nonnull
    public RecordKeyExpressionProto.KeyExpression toKeyExpression() {
        return RecordKeyExpressionProto.KeyExpression.newBuilder().setList(this.toProto()).build();
    }

    @Override
    @Nonnull
    public <S extends KeyExpressionVisitor.State, R> R expand(@Nonnull KeyExpressionVisitor<S, R> visitor) {
        return visitor.visitExpression(this);
    }

    @Override
    @Nonnull
    public List<KeyExpression> normalizeKeyForPositions() {
        if (this.children.isEmpty()) {
            return ImmutableList.of();
        }
        if (this.children.size() == 1) {
            return ImmutableList.of(this);
        }
        ImmutableList.Builder builder = ImmutableList.builderWithExpectedSize(this.children.size());
        for (KeyExpression child : this.children) {
            builder.add(Key.Expressions.list(child));
        }
        return builder.build();
    }

    @Override
    public boolean hasLosslessNormalization() {
        for (KeyExpression key : this.children) {
            if (key.hasLosslessNormalization()) continue;
            return false;
        }
        return true;
    }

    @Override
    public int versionColumns() {
        return this.children.stream().mapToInt(KeyExpression::versionColumns).sum();
    }

    @Override
    public boolean hasRecordTypeKey() {
        return this.children.stream().anyMatch(KeyExpression::hasRecordTypeKey);
    }

    @Override
    public KeyExpression getSubKeyImpl(int start, int end) {
        return new ListKeyExpression(this, start, end);
    }

    @Override
    @Nonnull
    public List<KeyExpression> getChildren() {
        return this.children;
    }

    @Override
    public boolean needsCopyingToPartialRecord() {
        return this.getChildren().stream().anyMatch(KeyExpression::needsCopyingToPartialRecord);
    }

    public String toString() {
        return this.getChildren().toString();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ListKeyExpression that = (ListKeyExpression)o;
        return this.getChildren().equals(that.getChildren());
    }

    public int hashCode() {
        return this.getChildren().hashCode();
    }

    @Override
    public int planHash(@Nonnull PlanHashable.PlanHashMode mode) {
        switch (mode.getKind()) {
            case LEGACY: {
                return PlanHashable.planHash(mode, this.getChildren());
            }
            case FOR_CONTINUATION: {
                return PlanHashable.objectsPlanHash(mode, BASE_HASH, this.getChildren());
            }
        }
        throw new UnsupportedOperationException("Hash kind " + String.valueOf((Object)mode.getKind()) + " is not supported");
    }
}

