/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record.metadata.expressions;

import com.apple.foundationdb.annotation.API;
import com.apple.foundationdb.record.ObjectPlanHash;
import com.apple.foundationdb.record.PlanHashable;
import com.apple.foundationdb.record.RecordCoreException;
import com.apple.foundationdb.record.expressions.RecordKeyExpressionProto;
import com.apple.foundationdb.record.metadata.Key;
import com.apple.foundationdb.record.metadata.expressions.AtomKeyExpression;
import com.apple.foundationdb.record.metadata.expressions.BaseKeyExpression;
import com.apple.foundationdb.record.metadata.expressions.KeyExpression;
import com.apple.foundationdb.record.metadata.expressions.KeyExpressionWithValue;
import com.apple.foundationdb.record.metadata.expressions.KeyExpressionWithoutChildren;
import com.apple.foundationdb.record.provider.foundationdb.FDBRecord;
import com.apple.foundationdb.record.query.plan.cascades.CorrelationIdentifier;
import com.apple.foundationdb.record.query.plan.cascades.KeyExpressionVisitor;
import com.apple.foundationdb.record.query.plan.cascades.typing.Type;
import com.apple.foundationdb.record.query.plan.cascades.values.LiteralValue;
import com.apple.foundationdb.record.query.plan.cascades.values.Value;
import com.google.common.collect.ImmutableList;
import com.google.protobuf.Descriptors;
import com.google.protobuf.Message;
import com.google.protobuf.ZeroCopyByteString;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@API(value=API.Status.UNSTABLE)
public class LiteralKeyExpression<T>
extends BaseKeyExpression
implements AtomKeyExpression,
KeyExpressionWithValue,
KeyExpressionWithoutChildren {
    private static final ObjectPlanHash BASE_HASH = new ObjectPlanHash("Literal-Key-Expression");
    @Nullable
    private final T value;
    @Nonnull
    private final List<Key.Evaluated> evaluated;
    @Nonnull
    private final RecordKeyExpressionProto.Value proto;

    public LiteralKeyExpression(@Nullable T value) {
        this(value, LiteralKeyExpression.toProtoValue(value));
    }

    private LiteralKeyExpression(@Nullable T value, @Nonnull RecordKeyExpressionProto.Value proto) {
        this.value = value;
        this.evaluated = ImmutableList.of(value == null ? Key.Evaluated.NULL : Key.Evaluated.scalar(value));
        this.proto = proto;
    }

    @Nullable
    public T getValue() {
        return this.value;
    }

    @Override
    @Nonnull
    public <M extends Message> List<Key.Evaluated> evaluateMessage(@Nullable FDBRecord<M> record, @Nullable Message message) {
        return this.evaluated;
    }

    @Override
    public boolean createsDuplicates() {
        return false;
    }

    @Override
    public List<Descriptors.FieldDescriptor> validate(@Nonnull Descriptors.Descriptor descriptor) {
        return Collections.emptyList();
    }

    @Override
    public int getColumnSize() {
        return 1;
    }

    @Override
    @Nonnull
    public RecordKeyExpressionProto.Value toProto() throws KeyExpression.SerializationException {
        return this.proto;
    }

    @Override
    @Nonnull
    public <S extends KeyExpressionVisitor.State, R> R expand(@Nonnull KeyExpressionVisitor<S, R> visitor) {
        return visitor.visitExpression(this);
    }

    @Override
    @Nonnull
    public Value toValue(@Nonnull CorrelationIdentifier baseAlias, @Nonnull Type baseType) {
        return LiteralValue.ofScalar(this.value);
    }

    @Override
    @Nonnull
    public RecordKeyExpressionProto.KeyExpression toKeyExpression() {
        return RecordKeyExpressionProto.KeyExpression.newBuilder().setValue(this.toProto()).build();
    }

    @Override
    public boolean needsCopyingToPartialRecord() {
        return false;
    }

    @Nonnull
    public static LiteralKeyExpression<?> fromProto(RecordKeyExpressionProto.Value proto) {
        return new LiteralKeyExpression<Object>(LiteralKeyExpression.fromProtoValue(proto), proto);
    }

    @Nullable
    public static Object fromProtoValue(RecordKeyExpressionProto.Value proto) {
        int found = 0;
        Object value = null;
        if (proto.hasDoubleValue()) {
            ++found;
            value = proto.getDoubleValue();
        }
        if (proto.hasFloatValue()) {
            ++found;
            value = Float.valueOf(proto.getFloatValue());
        }
        if (proto.hasLongValue()) {
            ++found;
            value = proto.getLongValue();
        }
        if (proto.hasBoolValue()) {
            ++found;
            value = proto.getBoolValue();
        }
        if (proto.hasStringValue()) {
            ++found;
            value = proto.getStringValue();
        }
        if (proto.hasBytesValue()) {
            ++found;
            value = proto.getBytesValue().toByteArray();
        }
        if (proto.hasIntValue()) {
            ++found;
            value = proto.getIntValue();
        }
        if (found == 0) {
            ++found;
        }
        if (found > 1) {
            throw new RecordCoreException("More than one value encoded in value", new Object[0]).addLogInfo("encoded_value", (Object)proto);
        }
        return value;
    }

    @Nonnull
    public static RecordKeyExpressionProto.Value toProtoValue(@Nullable Object value) {
        RecordKeyExpressionProto.Value.Builder builder = RecordKeyExpressionProto.Value.newBuilder();
        if (value instanceof Double) {
            builder.setDoubleValue((Double)value);
        } else if (value instanceof Float) {
            builder.setFloatValue(((Float)value).floatValue());
        } else if (value instanceof Integer) {
            builder.setIntValue((Integer)value);
        } else if (value instanceof Number) {
            builder.setLongValue(((Number)value).longValue());
        } else if (value instanceof Boolean) {
            builder.setBoolValue((Boolean)value);
        } else if (value instanceof String) {
            builder.setStringValue((String)value);
        } else if (value instanceof byte[]) {
            builder.setBytesValue(ZeroCopyByteString.wrap((byte[])value));
        } else if (value != null) {
            throw new RecordCoreException("Unsupported value type", new Object[0]).addLogInfo("value_type", (Object)value.getClass().getName());
        }
        return builder.build();
    }

    @Override
    public boolean equalsAtomic(AtomKeyExpression other) {
        return this.equals(other);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof LiteralKeyExpression)) {
            return false;
        }
        LiteralKeyExpression other = (LiteralKeyExpression)o;
        return this.proto.equals(other.proto);
    }

    public int hashCode() {
        return this.proto.hashCode();
    }

    @Override
    public int planHash(@Nonnull PlanHashable.PlanHashMode mode) {
        switch (mode.getKind()) {
            case LEGACY: 
            case FOR_CONTINUATION: {
                return PlanHashable.objectsPlanHash(mode, BASE_HASH, this.value);
            }
        }
        throw new UnsupportedOperationException("Hash kind " + String.valueOf((Object)mode.getKind()) + " is not supported");
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("value(");
        if (this.value instanceof String) {
            sb.append('\"').append(this.value).append('\"');
        } else {
            sb.append(this.value);
        }
        sb.append(')');
        return sb.toString();
    }
}

