/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record.metadata.expressions;

import com.apple.foundationdb.record.ObjectPlanHash;
import com.apple.foundationdb.record.PlanHashable;
import com.apple.foundationdb.record.metadata.Key;
import com.apple.foundationdb.record.metadata.expressions.FunctionKeyExpression;
import com.apple.foundationdb.record.metadata.expressions.KeyExpression;
import com.apple.foundationdb.record.metadata.expressions.QueryableKeyExpression;
import com.apple.foundationdb.record.provider.foundationdb.FDBRecord;
import com.apple.foundationdb.record.query.plan.cascades.KeyExpressionVisitor;
import com.apple.foundationdb.record.query.plan.cascades.values.Value;
import com.google.common.base.Verify;
import com.google.common.collect.ImmutableList;
import com.google.protobuf.Message;
import java.util.List;
import java.util.Objects;
import java.util.function.BinaryOperator;
import java.util.function.UnaryOperator;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class LongArithmethicFunctionKeyExpression
extends FunctionKeyExpression
implements QueryableKeyExpression {
    private static final ObjectPlanHash BASE_HASH = new ObjectPlanHash("Long-Arithmetic-Key-Expression-Function");
    @Nonnull
    private final String valueFunctionName;
    private final int minArguments;
    private final int maxArguments;
    @Nullable
    private final UnaryOperator<Long> unaryOperator;
    @Nullable
    private final BinaryOperator<Long> binaryOperator;

    private LongArithmethicFunctionKeyExpression(@Nonnull String name, @Nonnull KeyExpression arguments, @Nonnull String valueFunctionName, int minArguments, int maxArguments, @Nullable UnaryOperator<Long> unaryOperator, @Nullable BinaryOperator<Long> binaryOperator) {
        super(name, arguments);
        this.valueFunctionName = valueFunctionName;
        this.minArguments = minArguments;
        this.maxArguments = maxArguments;
        this.unaryOperator = unaryOperator;
        this.binaryOperator = binaryOperator;
    }

    @Override
    public int planHash(@Nonnull PlanHashable.PlanHashMode hashMode) {
        return super.basePlanHash(hashMode, BASE_HASH, new Object[0]);
    }

    @Override
    public int getMinArguments() {
        return this.minArguments;
    }

    @Override
    public int getMaxArguments() {
        return this.maxArguments;
    }

    @Override
    @Nonnull
    public <M extends Message> List<Key.Evaluated> evaluateFunction(@Nullable FDBRecord<M> record, @Nullable Message message, @Nonnull Key.Evaluated arguments) {
        Long result;
        if (arguments.size() == 1) {
            Long x = arguments.getNullableLong(0);
            result = x == null ? null : (Long)Objects.requireNonNull(this.unaryOperator).apply(x);
        } else {
            Long l = arguments.getNullableLong(0);
            Long r = arguments.getNullableLong(1);
            result = l == null || r == null ? null : (Long)Objects.requireNonNull(this.binaryOperator).apply(l, r);
        }
        return ImmutableList.of(Key.Evaluated.scalar(result));
    }

    @Override
    public boolean createsDuplicates() {
        return this.arguments.createsDuplicates();
    }

    @Override
    public int getColumnSize() {
        return 1;
    }

    @Override
    @Nonnull
    public <S extends KeyExpressionVisitor.State, R> R expand(@Nonnull KeyExpressionVisitor<S, R> visitor) {
        return visitor.visitExpression(this);
    }

    @Override
    @Nonnull
    public Value toValue(@Nonnull List<? extends Value> argumentValues) {
        Verify.verify(argumentValues.size() == this.arguments.getColumnSize());
        return this.resolveAndEncapsulateFunction(this.valueFunctionName, argumentValues);
    }

    public static class LongArithmethicFunctionKeyExpressionFactory
    implements FunctionKeyExpression.Factory {
        @Nonnull
        private static final List<FunctionKeyExpression.Builder> BUILDERS = ((ImmutableList.Builder)((ImmutableList.Builder)((ImmutableList.Builder)((ImmutableList.Builder)((ImmutableList.Builder)((ImmutableList.Builder)((ImmutableList.Builder)((ImmutableList.Builder)((ImmutableList.Builder)((ImmutableList.Builder)((ImmutableList.Builder)((ImmutableList.Builder)((ImmutableList.Builder)((ImmutableList.Builder)ImmutableList.builder().add(Builder.binaryFunction("add", Math::addExact))).add(Builder.bothFunction("sub", x -> -x.longValue(), Math::subtractExact))).add(Builder.bothFunction("subtract", "sub", Math::negateExact, Math::subtractExact))).add(Builder.binaryFunction("mul", Math::multiplyExact))).add(Builder.binaryFunction("multiply", "mul", Math::multiplyExact))).add(Builder.binaryFunction("div", (l, r) -> l / r))).add(Builder.binaryFunction("divide", "div", (l, r) -> l / r))).add(Builder.binaryFunction("mod", (l, r) -> l % r))).add(Builder.binaryFunction("bitor", (l, r) -> l | r))).add(Builder.binaryFunction("bitand", (l, r) -> l & r))).add(Builder.binaryFunction("bitxor", (l, r) -> l ^ r))).add(Builder.unaryFunction("bitnot", x -> x ^ 0xFFFFFFFFFFFFFFFFL))).add(Builder.binaryFunction("bitmap_bit_position", (l, r) -> Math.subtractExact(l, Math.multiplyExact(Math.floorDiv((long)l, r), r))))).add(Builder.binaryFunction("bitmap_bucket_offset", (l, r) -> Math.multiplyExact(Math.floorDiv((long)l, r), r)))).build();

        @Override
        @Nonnull
        public List<FunctionKeyExpression.Builder> getBuilders() {
            return BUILDERS;
        }
    }

    public static class Builder
    extends FunctionKeyExpression.Builder {
        private final String valueFunctionName;
        private final int minArguments;
        private final int maxArguments;
        @Nullable
        private final UnaryOperator<Long> unaryOperator;
        @Nullable
        private final BinaryOperator<Long> binaryOperator;

        private Builder(@Nonnull String functionName, @Nonnull String valueFunctionName, int minArguments, int maxArguments, @Nullable UnaryOperator<Long> unaryOperator, @Nullable BinaryOperator<Long> binaryOperator) {
            super(functionName);
            this.valueFunctionName = valueFunctionName;
            this.minArguments = minArguments;
            this.maxArguments = maxArguments;
            this.unaryOperator = unaryOperator;
            this.binaryOperator = binaryOperator;
        }

        @Override
        @Nonnull
        public FunctionKeyExpression build(@Nonnull KeyExpression arguments) {
            return new LongArithmethicFunctionKeyExpression(this.functionName, arguments, this.valueFunctionName, this.minArguments, this.maxArguments, this.unaryOperator, this.binaryOperator);
        }

        @Nonnull
        public static Builder unaryFunction(@Nonnull String name, @Nonnull UnaryOperator<Long> operator) {
            return Builder.unaryFunction(name, name, operator);
        }

        @Nonnull
        public static Builder unaryFunction(@Nonnull String name, @Nonnull String valueFunctionName, @Nonnull UnaryOperator<Long> operator) {
            return new Builder(name, valueFunctionName, 1, 1, operator, null);
        }

        @Nonnull
        public static Builder binaryFunction(@Nonnull String name, @Nonnull BinaryOperator<Long> operator) {
            return Builder.binaryFunction(name, name, operator);
        }

        @Nonnull
        public static Builder binaryFunction(@Nonnull String name, @Nonnull String valueFunctionName, @Nonnull BinaryOperator<Long> operator) {
            return new Builder(name, valueFunctionName, 2, 2, null, operator);
        }

        @Nonnull
        public static Builder bothFunction(@Nonnull String name, @Nonnull UnaryOperator<Long> unaryOperator, @Nonnull BinaryOperator<Long> binaryOperator) {
            return new Builder(name, name, 1, 2, unaryOperator, binaryOperator);
        }

        @Nonnull
        public static Builder bothFunction(@Nonnull String name, @Nonnull String valueFunctionName, @Nonnull UnaryOperator<Long> unaryOperator, @Nonnull BinaryOperator<Long> binaryOperator) {
            return new Builder(name, valueFunctionName, 1, 2, unaryOperator, binaryOperator);
        }
    }
}

