/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record.metadata.expressions;

import com.apple.foundationdb.annotation.API;
import com.apple.foundationdb.record.ObjectPlanHash;
import com.apple.foundationdb.record.PlanHashable;
import com.apple.foundationdb.record.expressions.RecordKeyExpressionProto;
import com.apple.foundationdb.record.metadata.Key;
import com.apple.foundationdb.record.metadata.expressions.AtomKeyExpression;
import com.apple.foundationdb.record.metadata.expressions.BaseKeyExpression;
import com.apple.foundationdb.record.metadata.expressions.FieldKeyExpression;
import com.apple.foundationdb.record.metadata.expressions.GroupingKeyExpression;
import com.apple.foundationdb.record.metadata.expressions.KeyExpression;
import com.apple.foundationdb.record.metadata.expressions.KeyExpressionWithChild;
import com.apple.foundationdb.record.provider.foundationdb.FDBRecord;
import com.apple.foundationdb.record.query.plan.cascades.KeyExpressionVisitor;
import com.google.protobuf.Descriptors;
import com.google.protobuf.Message;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@API(value=API.Status.UNSTABLE)
public class NestingKeyExpression
extends BaseKeyExpression
implements KeyExpressionWithChild,
AtomKeyExpression {
    private static final ObjectPlanHash BASE_HASH = new ObjectPlanHash("Nesting-Key-Expression");
    @Nonnull
    private final FieldKeyExpression parent;
    @Nonnull
    private final KeyExpression child;

    public NestingKeyExpression(@Nonnull FieldKeyExpression parent, @Nonnull KeyExpression child) {
        this.parent = parent;
        this.child = child;
    }

    public NestingKeyExpression(@Nonnull RecordKeyExpressionProto.Nesting nesting) throws KeyExpression.DeserializationException {
        if (!nesting.hasParent()) {
            throw new KeyExpression.DeserializationException("Serialized Nesting is missing parent");
        }
        this.parent = new FieldKeyExpression(nesting.getParent());
        this.child = KeyExpression.fromProto(nesting.getChild());
    }

    @Override
    @Nonnull
    public <M extends Message> List<Key.Evaluated> evaluateMessage(@Nullable FDBRecord<M> record, @Nullable Message message) {
        List<Key.Evaluated> parentKeys = this.parent.evaluateMessage(record, message);
        ArrayList<Key.Evaluated> result = new ArrayList<Key.Evaluated>();
        for (Key.Evaluated value : parentKeys) {
            Message submessage = (Message)value.toList().get(0);
            result.addAll(this.getChild().evaluateMessage(record, submessage));
        }
        this.validateColumnCounts(result);
        return result;
    }

    @Override
    public boolean createsDuplicates() {
        return this.parent.createsDuplicates() || this.getChild().createsDuplicates();
    }

    @Override
    public List<Descriptors.FieldDescriptor> validate(@Nonnull Descriptors.Descriptor descriptor) {
        this.parent.validate(descriptor, true);
        return this.getChild().validate(this.parent.getDescriptor(descriptor));
    }

    @Override
    public int getColumnSize() {
        return this.getChild().getColumnSize();
    }

    @Override
    @Nonnull
    public RecordKeyExpressionProto.Nesting toProto() throws KeyExpression.SerializationException {
        RecordKeyExpressionProto.Nesting.Builder builder = RecordKeyExpressionProto.Nesting.newBuilder();
        builder.setParent(this.parent.toProto());
        builder.setChild(this.getChild().toKeyExpression());
        return builder.build();
    }

    @Override
    @Nonnull
    public RecordKeyExpressionProto.KeyExpression toKeyExpression() {
        return RecordKeyExpressionProto.KeyExpression.newBuilder().setNesting(this.toProto()).build();
    }

    @Override
    @Nonnull
    public List<KeyExpression> normalizeKeyForPositions() {
        return this.getChild().normalizeKeyForPositions().stream().map(normalizedChild -> new NestingKeyExpression(this.parent, (KeyExpression)normalizedChild)).collect(Collectors.toList());
    }

    @Override
    public boolean hasLosslessNormalization() {
        if (this.parent.getFanType() == KeyExpression.FanType.FanOut && this.child.getColumnSize() > 1) {
            return false;
        }
        return this.child.hasLosslessNormalization();
    }

    @Override
    public boolean needsCopyingToPartialRecord() {
        return this.child.needsCopyingToPartialRecord();
    }

    @Override
    @Nonnull
    public <S extends KeyExpressionVisitor.State, R> R expand(@Nonnull KeyExpressionVisitor<S, R> visitor) {
        return visitor.visitExpression(this);
    }

    @Override
    public int versionColumns() {
        return this.getChild().versionColumns();
    }

    @Override
    public boolean hasRecordTypeKey() {
        return this.getChild().hasRecordTypeKey();
    }

    @Override
    public KeyExpression getSubKeyImpl(int start, int end) {
        KeyExpression childKey = this.getChild().getSubKey(start, end);
        return new NestingKeyExpression(this.parent, childKey);
    }

    @Nonnull
    public FieldKeyExpression getParent() {
        return this.parent;
    }

    @Override
    @Nonnull
    public KeyExpression getChild() {
        return this.child;
    }

    @Nonnull
    public GroupingKeyExpression ungrouped() {
        return new GroupingKeyExpression(this, this.getColumnSize());
    }

    @Nonnull
    public GroupingKeyExpression groupBy(@Nonnull KeyExpression groupByFirst, KeyExpression ... groupByRest) {
        return GroupingKeyExpression.of(this, groupByFirst, groupByRest);
    }

    public String toString() {
        return String.valueOf(this.parent) + "/" + String.valueOf(this.getChild());
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        NestingKeyExpression that = (NestingKeyExpression)o;
        return this.parent.equals(that.parent) && this.getChild().equals(that.getChild());
    }

    public int hashCode() {
        return this.parent.hashCode() + this.getChild().hashCode();
    }

    @Override
    public int planHash(@Nonnull PlanHashable.PlanHashMode mode) {
        switch (mode.getKind()) {
            case LEGACY: {
                return this.parent.planHash(mode) + this.getChild().planHash(mode);
            }
            case FOR_CONTINUATION: {
                return PlanHashable.planHash(mode, BASE_HASH, this.parent, this.getChild());
            }
        }
        throw new UnsupportedOperationException("Hash kind " + String.valueOf((Object)mode.getKind()) + " is not supported");
    }

    @Override
    public boolean equalsAtomic(AtomKeyExpression other) {
        return this.getClass() == other.getClass() && this.parent.equals(((NestingKeyExpression)other).parent);
    }
}

