/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record.metadata.expressions;

import com.apple.foundationdb.annotation.API;
import com.apple.foundationdb.record.ObjectPlanHash;
import com.apple.foundationdb.record.PlanHashable;
import com.apple.foundationdb.record.metadata.Key;
import com.apple.foundationdb.record.metadata.expressions.InvertibleFunctionKeyExpression;
import com.apple.foundationdb.record.metadata.expressions.KeyExpression;
import com.apple.foundationdb.record.metadata.expressions.QueryableKeyExpression;
import com.apple.foundationdb.record.provider.foundationdb.FDBRecord;
import com.apple.foundationdb.record.query.plan.cascades.KeyExpressionVisitor;
import com.apple.foundationdb.record.query.plan.cascades.values.ToOrderedBytesValue;
import com.apple.foundationdb.record.query.plan.cascades.values.Value;
import com.apple.foundationdb.tuple.Tuple;
import com.apple.foundationdb.tuple.TupleOrdering;
import com.google.protobuf.Message;
import com.google.protobuf.ZeroCopyByteString;
import java.util.Collections;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@API(value=API.Status.EXPERIMENTAL)
public class OrderFunctionKeyExpression
extends InvertibleFunctionKeyExpression
implements QueryableKeyExpression {
    private static final ObjectPlanHash BASE_HASH = new ObjectPlanHash("Order-Function-Key-Expression");
    @Nonnull
    private final TupleOrdering.Direction direction;

    protected OrderFunctionKeyExpression(@Nonnull TupleOrdering.Direction direction, @Nonnull String name, @Nonnull KeyExpression arguments) {
        super(name, arguments);
        this.direction = direction;
    }

    @Nonnull
    public TupleOrdering.Direction getDirection() {
        return this.direction;
    }

    @Override
    public int getMinArguments() {
        return 1;
    }

    @Override
    public int getMaxArguments() {
        return 1;
    }

    @Override
    @Nonnull
    public <M extends Message> List<Key.Evaluated> evaluateFunction(@Nullable FDBRecord<M> record, @Nullable Message message, @Nonnull Key.Evaluated arguments) {
        return Collections.singletonList(Key.Evaluated.scalar(ZeroCopyByteString.wrap(TupleOrdering.pack(arguments.toTuple(), this.direction))));
    }

    @Override
    public boolean createsDuplicates() {
        return this.getArguments().createsDuplicates();
    }

    @Override
    public int getColumnSize() {
        return 1;
    }

    @Override
    @Nonnull
    public <S extends KeyExpressionVisitor.State, R> R expand(@Nonnull KeyExpressionVisitor<S, R> visitor) {
        return visitor.visitExpression(this);
    }

    @Override
    @Nonnull
    public Value toValue(@Nonnull List<? extends Value> argumentValues) {
        return new ToOrderedBytesValue(argumentValues.get(0), this.direction);
    }

    @Override
    @Nullable
    public Function<Object, Object> getComparandConversionFunction() {
        return o -> ZeroCopyByteString.wrap(TupleOrdering.pack(Tuple.from(o), this.direction));
    }

    @Override
    public int planHash(@Nonnull PlanHashable.PlanHashMode mode) {
        return super.basePlanHash(mode, BASE_HASH, new Object[]{this.direction});
    }

    @Override
    protected List<Key.Evaluated> evaluateInverseInternal(@Nonnull Key.Evaluated result) {
        return Collections.singletonList(Key.Evaluated.fromTuple(TupleOrdering.unpack(result.getObject(0, byte[].class), this.direction)));
    }

    @Override
    public boolean isInjective() {
        return true;
    }
}

