/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record.metadata.expressions;

import com.apple.foundationdb.annotation.API;
import com.apple.foundationdb.record.EvaluationContext;
import com.apple.foundationdb.record.RecordCoreException;
import com.apple.foundationdb.record.metadata.Key;
import com.apple.foundationdb.record.metadata.expressions.KeyExpression;
import com.apple.foundationdb.record.provider.foundationdb.FDBRecord;
import com.apple.foundationdb.record.provider.foundationdb.FDBRecordStoreBase;
import com.google.protobuf.Message;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@API(value=API.Status.EXPERIMENTAL)
public interface QueryableKeyExpression
extends KeyExpression {
    @Nonnull
    public String getName();

    @Nullable
    default public <M extends Message> Object evalForQuery(@Nonnull FDBRecordStoreBase<M> store, @Nonnull EvaluationContext context, @Nullable FDBRecord<M> record, @Nullable Message message) {
        List<Key.Evaluated> keys = this.evaluateMessage(record, message);
        if (keys.size() != 1) {
            throw new RecordCoreException("Should evaluate to single key only", new Object[0]);
        }
        Key.Evaluated key = keys.get(0);
        if (this.evalForQueryAsTuple()) {
            return key.toTuple();
        }
        if (key.size() != 1) {
            throw new RecordCoreException("Should evaluate to single key only", new Object[0]);
        }
        return key.getObject(0);
    }

    @Nonnull
    default public <M extends Message> List<Object> evalForOneOfQuery(@Nonnull FDBRecordStoreBase<M> store, @Nonnull EvaluationContext context, @Nullable FDBRecord<M> record, @Nullable Message message) {
        List<Key.Evaluated> keys = this.evaluateMessage(record, message);
        Function<Key.Evaluated, Object> mapper = this.evalForQueryAsTuple() ? Key.Evaluated::toTuple : key -> {
            if (key.size() != 1) {
                throw new RecordCoreException("Should evaluate to single key only", new Object[0]);
            }
            return key.getObject(0);
        };
        return keys.stream().map(mapper).collect(Collectors.toList());
    }

    default public boolean evalForQueryAsTuple() {
        return this.getColumnSize() > 1;
    }

    @Nullable
    default public Function<Object, Object> getComparandConversionFunction() {
        return null;
    }
}

