/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record.metadata.expressions;

import com.apple.foundationdb.annotation.API;
import com.apple.foundationdb.record.ObjectPlanHash;
import com.apple.foundationdb.record.PlanHashable;
import com.apple.foundationdb.record.expressions.RecordKeyExpressionProto;
import com.apple.foundationdb.record.metadata.Key;
import com.apple.foundationdb.record.metadata.expressions.AtomKeyExpression;
import com.apple.foundationdb.record.metadata.expressions.BaseKeyExpression;
import com.apple.foundationdb.record.metadata.expressions.GroupingKeyExpression;
import com.apple.foundationdb.record.metadata.expressions.KeyExpression;
import com.apple.foundationdb.record.metadata.expressions.KeyExpressionWithValue;
import com.apple.foundationdb.record.metadata.expressions.KeyExpressionWithoutChildren;
import com.apple.foundationdb.record.provider.foundationdb.FDBRecord;
import com.apple.foundationdb.record.query.plan.cascades.CorrelationIdentifier;
import com.apple.foundationdb.record.query.plan.cascades.KeyExpressionVisitor;
import com.apple.foundationdb.record.query.plan.cascades.typing.Type;
import com.apple.foundationdb.record.query.plan.cascades.values.QuantifiedObjectValue;
import com.apple.foundationdb.record.query.plan.cascades.values.RecordTypeValue;
import com.apple.foundationdb.record.query.plan.cascades.values.Value;
import com.google.protobuf.Descriptors;
import com.google.protobuf.Message;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@API(value=API.Status.UNSTABLE)
public class RecordTypeKeyExpression
extends BaseKeyExpression
implements AtomKeyExpression,
KeyExpressionWithoutChildren,
KeyExpressionWithValue {
    private static final ObjectPlanHash BASE_HASH = new ObjectPlanHash("Record-Type-Key-Expression");
    public static final RecordTypeKeyExpression RECORD_TYPE_KEY = new RecordTypeKeyExpression();
    public static final RecordKeyExpressionProto.KeyExpression RECORD_TYPE_KEY_PROTO = RecordKeyExpressionProto.KeyExpression.newBuilder().setRecordTypeKey(RECORD_TYPE_KEY.toProto()).build();
    private static final GroupingKeyExpression UNGROUPED = new GroupingKeyExpression(new RecordTypeKeyExpression(), 0);

    private RecordTypeKeyExpression() {
    }

    @Override
    @Nonnull
    public <M extends Message> List<Key.Evaluated> evaluateMessage(@Nullable FDBRecord<M> record, @Nullable Message message) {
        Key.Evaluated recordType = record != null ? Key.Evaluated.scalar(record.getRecordType().getRecordTypeKey()) : Key.Evaluated.NULL;
        return Collections.singletonList(recordType);
    }

    @Override
    public boolean createsDuplicates() {
        return false;
    }

    @Override
    public List<Descriptors.FieldDescriptor> validate(@Nonnull Descriptors.Descriptor descriptor) {
        return Collections.emptyList();
    }

    @Override
    public int getColumnSize() {
        return 1;
    }

    @Override
    public boolean hasRecordTypeKey() {
        return true;
    }

    @Nonnull
    public GroupingKeyExpression ungrouped() {
        return UNGROUPED;
    }

    @Override
    @Nonnull
    public RecordKeyExpressionProto.RecordTypeKey toProto() throws KeyExpression.SerializationException {
        return RecordKeyExpressionProto.RecordTypeKey.getDefaultInstance();
    }

    @Override
    @Nonnull
    public RecordKeyExpressionProto.KeyExpression toKeyExpression() {
        return RECORD_TYPE_KEY_PROTO;
    }

    @Override
    @Nonnull
    public <S extends KeyExpressionVisitor.State, R> R expand(@Nonnull KeyExpressionVisitor<S, R> visitor) {
        return visitor.visitExpression(this);
    }

    @Override
    @Nonnull
    public Value toValue(@Nonnull CorrelationIdentifier baseAlias, @Nonnull Type baseType) {
        return new RecordTypeValue(QuantifiedObjectValue.of(baseAlias, new Type.AnyRecord(true)));
    }

    @Override
    public boolean needsCopyingToPartialRecord() {
        return false;
    }

    public boolean equals(Object o) {
        return o == this || o != null && this.getClass() == o.getClass();
    }

    public int hashCode() {
        return 2;
    }

    @Override
    public int planHash(@Nonnull PlanHashable.PlanHashMode mode) {
        switch (mode.getKind()) {
            case LEGACY: {
                return 2;
            }
            case FOR_CONTINUATION: {
                return PlanHashable.objectsPlanHash(mode, BASE_HASH);
            }
        }
        throw new UnsupportedOperationException("Hash kind " + String.valueOf((Object)mode.getKind()) + " is not supported");
    }

    @Override
    public boolean equalsAtomic(AtomKeyExpression other) {
        return this.equals(other);
    }

    public String toString() {
        return "RecordTypeKey";
    }
}

