/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record.metadata.expressions;

import com.apple.foundationdb.annotation.API;
import com.apple.foundationdb.record.ObjectPlanHash;
import com.apple.foundationdb.record.PlanHashable;
import com.apple.foundationdb.record.RecordCoreException;
import com.apple.foundationdb.record.expressions.RecordKeyExpressionProto;
import com.apple.foundationdb.record.metadata.Key;
import com.apple.foundationdb.record.metadata.expressions.AtomKeyExpression;
import com.apple.foundationdb.record.metadata.expressions.BaseKeyExpression;
import com.apple.foundationdb.record.metadata.expressions.GroupingKeyExpression;
import com.apple.foundationdb.record.metadata.expressions.KeyExpression;
import com.apple.foundationdb.record.metadata.expressions.KeyExpressionWithoutChildren;
import com.apple.foundationdb.record.provider.foundationdb.FDBRecord;
import com.apple.foundationdb.record.query.plan.cascades.KeyExpressionVisitor;
import com.google.protobuf.Descriptors;
import com.google.protobuf.Message;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@API(value=API.Status.UNSTABLE)
public class SplitKeyExpression
extends BaseKeyExpression
implements AtomKeyExpression,
KeyExpressionWithoutChildren {
    private static final ObjectPlanHash BASE_HASH = new ObjectPlanHash("Split-Key-Expression");
    private final KeyExpression joined;
    private final int splitSize;

    public SplitKeyExpression(KeyExpression joined, int splitSize) {
        this.joined = joined;
        this.splitSize = splitSize;
    }

    public SplitKeyExpression(@Nonnull RecordKeyExpressionProto.Split split) throws KeyExpression.DeserializationException {
        this(KeyExpression.fromProto(split.getJoined()), split.getSplitSize());
    }

    @Override
    @Nonnull
    public <M extends Message> List<Key.Evaluated> evaluateMessage(@Nullable FDBRecord<M> record, @Nullable Message message) {
        return this.split(this.getJoined().evaluateMessage(record, message));
    }

    private List<Key.Evaluated> split(@Nonnull List<Key.Evaluated> unsplit) {
        if (unsplit.size() % this.splitSize != 0) {
            throw new RecordCoreException("stored value size is not an even multiple of " + this.splitSize, new Object[0]);
        }
        ArrayList<Key.Evaluated> split = new ArrayList<Key.Evaluated>(unsplit.size() / this.splitSize);
        for (int i = 0; i < unsplit.size(); i += this.splitSize) {
            Key.Evaluated item = unsplit.get(i);
            for (int j = 1; j < this.splitSize; ++j) {
                item = item.append(unsplit.get(i + j));
            }
            split.add(item);
        }
        this.validateColumnCounts(split);
        return split;
    }

    @Override
    public boolean createsDuplicates() {
        return true;
    }

    @Override
    public List<Descriptors.FieldDescriptor> validate(@Nonnull Descriptors.Descriptor descriptor) {
        if (this.getJoined().getColumnSize() != 1) {
            throw new KeyExpression.InvalidExpressionException("Must have a single key before splitting");
        }
        if (!this.getJoined().createsDuplicates()) {
            throw new KeyExpression.InvalidExpressionException("Must produce multiple values for splitting");
        }
        return this.getJoined().validate(descriptor);
    }

    @Override
    public int getColumnSize() {
        return this.splitSize;
    }

    @Override
    public boolean needsCopyingToPartialRecord() {
        return this.joined.needsCopyingToPartialRecord();
    }

    @Override
    @Nonnull
    public RecordKeyExpressionProto.Split toProto() throws KeyExpression.SerializationException {
        RecordKeyExpressionProto.Split.Builder builder = RecordKeyExpressionProto.Split.newBuilder();
        builder.setJoined(this.getJoined().toKeyExpression());
        builder.setSplitSize(this.splitSize);
        return builder.build();
    }

    @Override
    @Nonnull
    public RecordKeyExpressionProto.KeyExpression toKeyExpression() {
        return RecordKeyExpressionProto.KeyExpression.newBuilder().setSplit(this.toProto()).build();
    }

    @Override
    @Nonnull
    public List<KeyExpression> normalizeKeyForPositions() {
        return Collections.nCopies(this.splitSize, this.getJoined());
    }

    @Override
    public boolean hasLosslessNormalization() {
        return false;
    }

    @Override
    @Nonnull
    public <S extends KeyExpressionVisitor.State, R> R expand(@Nonnull KeyExpressionVisitor<S, R> visitor) {
        return visitor.visitExpression(this);
    }

    @Override
    public int versionColumns() {
        return this.getJoined().versionColumns();
    }

    @Override
    public boolean hasRecordTypeKey() {
        return this.getJoined().hasRecordTypeKey();
    }

    @Nonnull
    public KeyExpression getJoined() {
        return this.joined;
    }

    @Nonnull
    public GroupingKeyExpression ungrouped() {
        return new GroupingKeyExpression(this, this.getColumnSize());
    }

    @Nonnull
    public GroupingKeyExpression groupBy(@Nonnull KeyExpression groupByFirst, KeyExpression ... groupByRest) {
        return GroupingKeyExpression.of(this, groupByFirst, groupByRest);
    }

    public String toString() {
        StringBuilder str = new StringBuilder(this.getJoined().toString());
        str.append(" split ").append(this.splitSize);
        return str.toString();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SplitKeyExpression that = (SplitKeyExpression)o;
        return this.getJoined().equals(that.getJoined()) && this.splitSize == that.splitSize;
    }

    public int hashCode() {
        int hash = this.getJoined().hashCode();
        return hash += this.splitSize;
    }

    @Override
    public int planHash(@Nonnull PlanHashable.PlanHashMode mode) {
        switch (mode.getKind()) {
            case LEGACY: {
                return this.getJoined().planHash(mode) + this.splitSize;
            }
            case FOR_CONTINUATION: {
                return PlanHashable.objectsPlanHash(mode, BASE_HASH, this.getJoined(), this.splitSize);
            }
        }
        throw new UnsupportedOperationException("Hash kind " + String.valueOf((Object)mode.getKind()) + " is not supported");
    }

    @Override
    public boolean equalsAtomic(AtomKeyExpression other) {
        return this.equals(other);
    }
}

