/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record.metadata.expressions;

import com.apple.foundationdb.annotation.API;
import com.apple.foundationdb.record.ObjectPlanHash;
import com.apple.foundationdb.record.PlanHashable;
import com.apple.foundationdb.record.RecordCoreException;
import com.apple.foundationdb.record.expressions.RecordKeyExpressionProto;
import com.apple.foundationdb.record.metadata.Key;
import com.apple.foundationdb.record.metadata.expressions.BaseKeyExpression;
import com.apple.foundationdb.record.metadata.expressions.EmptyKeyExpression;
import com.apple.foundationdb.record.metadata.expressions.GroupingKeyExpression;
import com.apple.foundationdb.record.metadata.expressions.KeyExpression;
import com.apple.foundationdb.record.metadata.expressions.KeyExpressionWithChildren;
import com.apple.foundationdb.record.provider.foundationdb.FDBRecord;
import com.apple.foundationdb.record.query.plan.cascades.KeyExpressionVisitor;
import com.google.protobuf.Descriptors;
import com.google.protobuf.Message;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@API(value=API.Status.UNSTABLE)
public class ThenKeyExpression
extends BaseKeyExpression
implements KeyExpressionWithChildren {
    private static final ObjectPlanHash BASE_HASH = new ObjectPlanHash("Then-Key-Expression");
    @Nonnull
    private final List<KeyExpression> children;

    public ThenKeyExpression(@Nonnull List<KeyExpression> exprs) {
        this(exprs, 0, exprs.size());
    }

    public ThenKeyExpression(@Nonnull List<KeyExpression> exprs, int startIdx, int endIdx) {
        this.children = new ArrayList<KeyExpression>(endIdx - startIdx);
        for (int i = startIdx; i < endIdx; ++i) {
            ThenKeyExpression.add(this.children, exprs.get(i));
        }
        if (this.children.size() < 2) {
            throw new RecordCoreException("Then must have at least 2 children", new Object[0]);
        }
    }

    public ThenKeyExpression(@Nonnull KeyExpression first, @Nonnull KeyExpression second, KeyExpression ... rest) {
        this.children = new ArrayList<KeyExpression>(rest.length + 2);
        ThenKeyExpression.add(this.children, first);
        ThenKeyExpression.add(this.children, second);
        for (KeyExpression child : rest) {
            ThenKeyExpression.add(this.children, child);
        }
    }

    public ThenKeyExpression(@Nonnull RecordKeyExpressionProto.Then then) throws KeyExpression.DeserializationException {
        this.children = new ArrayList<KeyExpression>(then.getChildCount());
        for (RecordKeyExpressionProto.KeyExpression child : then.getChildList()) {
            KeyExpression expression = KeyExpression.fromProto(child);
            ThenKeyExpression.add(this.children, expression);
        }
        if (this.children.size() < 2) {
            throw new KeyExpression.DeserializationException("Then must have at least 2 children");
        }
    }

    @Override
    @Nonnull
    public <M extends Message> List<Key.Evaluated> evaluateMessage(@Nullable FDBRecord<M> record, @Nullable Message message) {
        ArrayList<List<Key.Evaluated>> childrenValues = new ArrayList<List<Key.Evaluated>>(this.children.size());
        int totalCount = 1;
        for (KeyExpression child : this.children) {
            List<Key.Evaluated> childValues = child.evaluateMessage(record, message);
            childrenValues.add(childValues);
            totalCount *= childValues.size();
        }
        return this.combine(childrenValues, totalCount);
    }

    private List<Key.Evaluated> combine(@Nonnull List<List<Key.Evaluated>> childrenValues, int totalCount) {
        ArrayList<Key.Evaluated> combined = new ArrayList<Key.Evaluated>(totalCount);
        for (Key.Evaluated childValue : childrenValues.get(0)) {
            this.combine(combined, childValue, 1, childrenValues);
        }
        this.validateColumnCounts(combined);
        return combined;
    }

    private void combine(@Nonnull List<Key.Evaluated> combined, @Nonnull Key.Evaluated prefix, int valuesIndex, @Nonnull List<List<Key.Evaluated>> childrenValues) {
        if (valuesIndex == childrenValues.size()) {
            combined.add(prefix);
        } else {
            for (Key.Evaluated childValue : childrenValues.get(valuesIndex)) {
                this.combine(combined, prefix.append(childValue), valuesIndex + 1, childrenValues);
            }
        }
    }

    @Override
    public boolean createsDuplicates() {
        return this.createsDuplicatesAfter(0);
    }

    public boolean createsDuplicatesAfter(int index) {
        for (int i = index; i < this.children.size(); ++i) {
            if (!this.children.get(i).createsDuplicates()) continue;
            return true;
        }
        return false;
    }

    @Override
    public List<Descriptors.FieldDescriptor> validate(@Nonnull Descriptors.Descriptor descriptor) {
        return this.children.stream().flatMap(child -> child.validate(descriptor).stream()).collect(Collectors.toList());
    }

    @Override
    public int getColumnSize() {
        int columnSize = 0;
        for (KeyExpression child : this.children) {
            columnSize += child.getColumnSize();
        }
        return columnSize;
    }

    @Nonnull
    public GroupingKeyExpression ungrouped() {
        return new GroupingKeyExpression(this, this.getColumnSize());
    }

    @Nonnull
    public GroupingKeyExpression groupBy(@Nonnull KeyExpression groupByFirst, KeyExpression ... groupByRest) {
        return GroupingKeyExpression.of(this, groupByFirst, groupByRest);
    }

    @Nonnull
    public GroupingKeyExpression group(int count) {
        if (count < 0 || count > this.getColumnSize()) {
            throw new RecordCoreException("Grouped count out of range", new Object[0]);
        }
        return new GroupingKeyExpression(this, count);
    }

    @Override
    @Nonnull
    public RecordKeyExpressionProto.Then toProto() throws KeyExpression.SerializationException {
        RecordKeyExpressionProto.Then.Builder builder = RecordKeyExpressionProto.Then.newBuilder();
        for (KeyExpression child : this.children) {
            builder.addChild(child.toKeyExpression());
        }
        return builder.build();
    }

    @Override
    @Nonnull
    public RecordKeyExpressionProto.KeyExpression toKeyExpression() {
        return RecordKeyExpressionProto.KeyExpression.newBuilder().setThen(this.toProto()).build();
    }

    @Override
    @Nonnull
    public <S extends KeyExpressionVisitor.State, R> R expand(@Nonnull KeyExpressionVisitor<S, R> visitor) {
        return visitor.visitExpression(this);
    }

    @Override
    @Nonnull
    public List<KeyExpression> normalizeKeyForPositions() {
        ArrayList<KeyExpression> list = new ArrayList<KeyExpression>();
        for (KeyExpression k : this.getChildren()) {
            list.addAll(k.normalizeKeyForPositions());
        }
        return list;
    }

    @Override
    public boolean hasLosslessNormalization() {
        for (KeyExpression key : this.children) {
            if (key.hasLosslessNormalization()) continue;
            return false;
        }
        return true;
    }

    @Override
    public int versionColumns() {
        int versionColumns = 0;
        for (KeyExpression subkey : this.getChildren()) {
            versionColumns += subkey.versionColumns();
        }
        return versionColumns;
    }

    @Override
    public boolean hasRecordTypeKey() {
        for (KeyExpression subkey : this.getChildren()) {
            if (!subkey.hasRecordTypeKey()) continue;
            return true;
        }
        return false;
    }

    @Override
    public KeyExpression getSubKeyImpl(int start, int end) {
        int childEnd;
        ArrayList<KeyExpression> childrenForSubKey = new ArrayList<KeyExpression>(this.getChildren());
        int childStart = ThenKeyExpression.splitGroupingKeys(childrenForSubKey, start);
        if (childStart == (childEnd = ThenKeyExpression.splitGroupingKeys(childrenForSubKey, end))) {
            return EmptyKeyExpression.EMPTY;
        }
        if (childStart == childEnd - 1) {
            return (KeyExpression)childrenForSubKey.get(childStart);
        }
        return new ThenKeyExpression(childrenForSubKey.subList(childStart, childEnd));
    }

    @Override
    @Nonnull
    public List<KeyExpression> getChildren() {
        return this.children;
    }

    @Nonnull
    public List<KeyExpression> getChildrenRefs() {
        return this.children;
    }

    @Override
    public boolean needsCopyingToPartialRecord() {
        return this.getChildren().stream().anyMatch(KeyExpression::needsCopyingToPartialRecord);
    }

    private static void add(@Nonnull List<KeyExpression> children, @Nonnull KeyExpression child) {
        if (child instanceof ThenKeyExpression) {
            ThenKeyExpression then = (ThenKeyExpression)child;
            children.addAll(then.getChildrenRefs());
        } else {
            children.add(child);
        }
    }

    public String toString() {
        return this.getChildren().toString();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ThenKeyExpression that = (ThenKeyExpression)o;
        return this.getChildren().equals(that.getChildren());
    }

    public int hashCode() {
        return this.getChildren().hashCode();
    }

    @Override
    public int planHash(@Nonnull PlanHashable.PlanHashMode mode) {
        switch (mode.getKind()) {
            case LEGACY: {
                return PlanHashable.planHash(mode, this.getChildren());
            }
            case FOR_CONTINUATION: {
                return PlanHashable.objectsPlanHash(mode, BASE_HASH, this.getChildren());
            }
        }
        throw new UnsupportedOperationException("Hash kind " + String.valueOf((Object)mode.getKind()) + " is not supported");
    }

    private static int splitGroupingKeys(List<KeyExpression> keys, int pos) {
        int i = 0;
        int total = 0;
        while (i < keys.size() && total < pos) {
            KeyExpression key = keys.get(i);
            int count = key.getColumnSize();
            if (total + count <= pos) {
                ++i;
                total += count;
                continue;
            }
            int split = pos - total;
            KeyExpression left = key.getSubKey(0, split);
            KeyExpression right = key.getSubKey(split, count);
            keys.set(i++, left);
            keys.add(i, right);
            total += split;
        }
        return i;
    }
}

