/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record.metadata.expressions;

import com.apple.foundationdb.annotation.API;
import com.apple.foundationdb.record.RecordCoreArgumentException;
import com.apple.foundationdb.record.TupleFieldsProto;
import com.google.common.collect.ImmutableSet;
import com.google.protobuf.ByteString;
import com.google.protobuf.Descriptors;
import com.google.protobuf.Message;
import com.google.protobuf.ZeroCopyByteString;
import java.util.Set;
import java.util.UUID;
import javax.annotation.Nonnull;

@API(value=API.Status.INTERNAL)
public class TupleFieldsHelper {
    @Nonnull
    private static final Set<Descriptors.Descriptor> DESCRIPTORS = ImmutableSet.of(TupleFieldsProto.UUID.getDescriptor(), TupleFieldsProto.NullableDouble.getDescriptor(), TupleFieldsProto.NullableFloat.getDescriptor(), TupleFieldsProto.NullableInt32.getDescriptor(), TupleFieldsProto.NullableInt64.getDescriptor(), TupleFieldsProto.NullableBool.getDescriptor(), new Descriptors.Descriptor[]{TupleFieldsProto.NullableString.getDescriptor(), TupleFieldsProto.NullableBytes.getDescriptor()});

    public static boolean isTupleField(@Nonnull Descriptors.Descriptor descriptor) {
        return DESCRIPTORS.contains(descriptor);
    }

    @Nonnull
    public static Object fromProto(@Nonnull Message value, @Nonnull Descriptors.Descriptor descriptor) {
        if (descriptor == TupleFieldsProto.UUID.getDescriptor()) {
            return TupleFieldsHelper.fromProto(value instanceof TupleFieldsProto.UUID ? (TupleFieldsProto.UUID)value : TupleFieldsProto.UUID.newBuilder().mergeFrom(value).build());
        }
        if (descriptor == TupleFieldsProto.NullableDouble.getDescriptor()) {
            return TupleFieldsHelper.fromProto(value instanceof TupleFieldsProto.NullableDouble ? (TupleFieldsProto.NullableDouble)value : TupleFieldsProto.NullableDouble.newBuilder().mergeFrom(value).build());
        }
        if (descriptor == TupleFieldsProto.NullableFloat.getDescriptor()) {
            return Float.valueOf(TupleFieldsHelper.fromProto(value instanceof TupleFieldsProto.NullableFloat ? (TupleFieldsProto.NullableFloat)value : TupleFieldsProto.NullableFloat.newBuilder().mergeFrom(value).build()));
        }
        if (descriptor == TupleFieldsProto.NullableInt32.getDescriptor()) {
            return TupleFieldsHelper.fromProto(value instanceof TupleFieldsProto.NullableInt32 ? (TupleFieldsProto.NullableInt32)value : TupleFieldsProto.NullableInt32.newBuilder().mergeFrom(value).build());
        }
        if (descriptor == TupleFieldsProto.NullableInt64.getDescriptor()) {
            return TupleFieldsHelper.fromProto(value instanceof TupleFieldsProto.NullableInt64 ? (TupleFieldsProto.NullableInt64)value : TupleFieldsProto.NullableInt64.newBuilder().mergeFrom(value).build());
        }
        if (descriptor == TupleFieldsProto.NullableBool.getDescriptor()) {
            return TupleFieldsHelper.fromProto(value instanceof TupleFieldsProto.NullableBool ? (TupleFieldsProto.NullableBool)value : TupleFieldsProto.NullableBool.newBuilder().mergeFrom(value).build());
        }
        if (descriptor == TupleFieldsProto.NullableString.getDescriptor()) {
            return TupleFieldsHelper.fromProto(value instanceof TupleFieldsProto.NullableString ? (TupleFieldsProto.NullableString)value : TupleFieldsProto.NullableString.newBuilder().mergeFrom(value).build());
        }
        if (descriptor == TupleFieldsProto.NullableBytes.getDescriptor()) {
            return TupleFieldsHelper.fromProto(value instanceof TupleFieldsProto.NullableBytes ? (TupleFieldsProto.NullableBytes)value : TupleFieldsProto.NullableBytes.newBuilder().mergeFrom(value).build());
        }
        throw new RecordCoreArgumentException("value is not of a known message type", new Object[0]);
    }

    @Nonnull
    public static UUID fromProto(@Nonnull TupleFieldsProto.UUID proto) {
        return new UUID(proto.getMostSignificantBits(), proto.getLeastSignificantBits());
    }

    public static double fromProto(@Nonnull TupleFieldsProto.NullableDouble proto) {
        return proto.getValue();
    }

    public static float fromProto(@Nonnull TupleFieldsProto.NullableFloat proto) {
        return proto.getValue();
    }

    public static int fromProto(@Nonnull TupleFieldsProto.NullableInt32 proto) {
        return proto.getValue();
    }

    public static long fromProto(@Nonnull TupleFieldsProto.NullableInt64 proto) {
        return proto.getValue();
    }

    public static boolean fromProto(@Nonnull TupleFieldsProto.NullableBool proto) {
        return proto.getValue();
    }

    @Nonnull
    public static String fromProto(@Nonnull TupleFieldsProto.NullableString proto) {
        return proto.getValue();
    }

    @Nonnull
    public static ByteString fromProto(@Nonnull TupleFieldsProto.NullableBytes proto) {
        return proto.getValue();
    }

    @Nonnull
    public static Message toProto(@Nonnull Object value, @Nonnull Descriptors.Descriptor descriptor) {
        if (descriptor == TupleFieldsProto.UUID.getDescriptor()) {
            return TupleFieldsHelper.toProto((UUID)value);
        }
        if (descriptor == TupleFieldsProto.NullableDouble.getDescriptor()) {
            return TupleFieldsHelper.toProto((Double)value);
        }
        if (descriptor == TupleFieldsProto.NullableFloat.getDescriptor()) {
            return TupleFieldsHelper.toProto(((Float)value).floatValue());
        }
        if (descriptor == TupleFieldsProto.NullableInt32.getDescriptor()) {
            return TupleFieldsHelper.toProto((Integer)value);
        }
        if (descriptor == TupleFieldsProto.NullableInt64.getDescriptor()) {
            return TupleFieldsHelper.toProto((Long)value);
        }
        if (descriptor == TupleFieldsProto.NullableBool.getDescriptor()) {
            return TupleFieldsHelper.toProto((Boolean)value);
        }
        if (descriptor == TupleFieldsProto.NullableString.getDescriptor()) {
            return TupleFieldsHelper.toProto((String)value);
        }
        if (descriptor == TupleFieldsProto.NullableBytes.getDescriptor()) {
            return TupleFieldsHelper.toProto(value instanceof byte[] ? ZeroCopyByteString.wrap((byte[])value) : (ByteString)value);
        }
        throw new RecordCoreArgumentException("value is not of a known message type", new Object[0]);
    }

    @Nonnull
    public static TupleFieldsProto.UUID toProto(@Nonnull UUID uuid) {
        return TupleFieldsProto.UUID.newBuilder().setMostSignificantBits(uuid.getMostSignificantBits()).setLeastSignificantBits(uuid.getLeastSignificantBits()).build();
    }

    @Nonnull
    public static TupleFieldsProto.NullableDouble toProto(double value) {
        return TupleFieldsProto.NullableDouble.newBuilder().setValue(value).build();
    }

    @Nonnull
    public static TupleFieldsProto.NullableFloat toProto(float value) {
        return TupleFieldsProto.NullableFloat.newBuilder().setValue(value).build();
    }

    @Nonnull
    public static TupleFieldsProto.NullableInt32 toProto(int value) {
        return TupleFieldsProto.NullableInt32.newBuilder().setValue(value).build();
    }

    @Nonnull
    public static TupleFieldsProto.NullableInt64 toProto(long value) {
        return TupleFieldsProto.NullableInt64.newBuilder().setValue(value).build();
    }

    @Nonnull
    public static TupleFieldsProto.NullableBool toProto(boolean value) {
        return TupleFieldsProto.NullableBool.newBuilder().setValue(value).build();
    }

    @Nonnull
    public static TupleFieldsProto.NullableString toProto(@Nonnull String value) {
        return TupleFieldsProto.NullableString.newBuilder().setValue(value).build();
    }

    @Nonnull
    public static TupleFieldsProto.NullableBytes toProto(@Nonnull ByteString value) {
        return TupleFieldsProto.NullableBytes.newBuilder().setValue(value).build();
    }

    private TupleFieldsHelper() {
    }
}

