/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record.provider.common;

import com.apple.foundationdb.record.provider.common.MappedPool;
import java.security.GeneralSecurityException;
import javax.annotation.Nonnull;
import javax.crypto.Cipher;

public class CipherPool {
    public static final String DEFAULT_CIPHER = "AES/CBC/PKCS5Padding";
    public static final int IV_SIZE = 16;
    public static final MappedPool<String, Cipher, GeneralSecurityException> MAPPED_POOL = new MappedPool(Cipher::getInstance);

    private CipherPool() {
    }

    public static Cipher borrowCipher() throws GeneralSecurityException {
        return CipherPool.borrowCipher(DEFAULT_CIPHER);
    }

    public static Cipher borrowCipher(@Nonnull String cipherName) throws GeneralSecurityException {
        return MAPPED_POOL.poll(cipherName);
    }

    public static void returnCipher(@Nonnull Cipher cipher) {
        MAPPED_POOL.offer(cipher.getAlgorithm(), cipher);
    }

    public static void invalidateAll() {
        MAPPED_POOL.invalidateAll();
    }
}

