/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record.provider.common;

import com.apple.foundationdb.annotation.API;
import com.apple.foundationdb.annotation.SpotBugsSuppressWarnings;
import com.apple.foundationdb.record.RecordMetaData;
import com.apple.foundationdb.record.logging.KeyValueLogMessage;
import com.apple.foundationdb.record.logging.LogMessageKeys;
import com.apple.foundationdb.record.metadata.RecordType;
import com.apple.foundationdb.record.provider.common.RecordSerializationException;
import com.apple.foundationdb.record.provider.common.RecordSerializer;
import com.apple.foundationdb.record.provider.common.StoreTimer;
import com.apple.foundationdb.record.util.pair.Pair;
import com.apple.foundationdb.tuple.Tuple;
import com.google.protobuf.Descriptors;
import com.google.protobuf.DynamicMessage;
import com.google.protobuf.InvalidProtocolBufferException;
import com.google.protobuf.Message;
import com.google.protobuf.UnknownFieldSet;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@API(value=API.Status.UNSTABLE)
public class DynamicMessageRecordSerializer
implements RecordSerializer<Message> {
    private static final Logger LOGGER = LoggerFactory.getLogger(DynamicMessageRecordSerializer.class);
    private static final DynamicMessageRecordSerializer INSTANCE = new DynamicMessageRecordSerializer();

    @Nonnull
    public static RecordSerializer<Message> instance() {
        return INSTANCE;
    }

    @SpotBugsSuppressWarnings(value={"SING_SINGLETON_HAS_NONPRIVATE_CONSTRUCTOR"}, justification="Singleton is optimization as base class has no state. Subclasses are allowed and may not be singletons")
    protected DynamicMessageRecordSerializer() {
    }

    @Override
    @Nonnull
    public RecordSerializer<Message> widen() {
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nonnull
    public byte[] serialize(@Nonnull RecordMetaData metaData, @Nonnull RecordType recordType, @Nonnull Message rec, @Nullable StoreTimer timer) {
        long startTime = System.nanoTime();
        try {
            Message storedRecord = rec;
            Descriptors.Descriptor unionDescriptor = metaData.getUnionDescriptor();
            if (unionDescriptor != null) {
                DynamicMessage.Builder unionBuilder = DynamicMessage.newBuilder(unionDescriptor);
                Descriptors.FieldDescriptor unionField = metaData.getUnionFieldForRecordType(recordType);
                unionBuilder.setField(unionField, rec);
                storedRecord = unionBuilder.build();
            }
            byte[] byArray = this.serializeToBytes(storedRecord);
            return byArray;
        }
        finally {
            if (timer != null) {
                timer.recordSinceNanoTime(RecordSerializer.Events.SERIALIZE_PROTOBUF_RECORD, startTime);
            }
        }
    }

    @Nonnull
    protected byte[] serializeToBytes(@Nonnull Message storedRecord) {
        return storedRecord.toByteArray();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nonnull
    @SpotBugsSuppressWarnings(value={"RCN_REDUNDANT_NULLCHECK_OF_NONNULL_VALUE"})
    public Message deserialize(@Nonnull RecordMetaData metaData, @Nonnull Tuple primaryKey, @Nonnull byte[] serialized, @Nullable StoreTimer timer) {
        long startTime = System.nanoTime();
        try {
            Descriptors.Descriptor unionDescriptor = metaData.getUnionDescriptor();
            DynamicMessage unionMessage = this.deserializeUnion(unionDescriptor, primaryKey, serialized, metaData.getVersion());
            Message message = this.getUnionField(unionMessage, primaryKey).getValue();
            return message;
        }
        finally {
            if (timer != null) {
                timer.recordSinceNanoTime(RecordSerializer.Events.DESERIALIZE_PROTOBUF_RECORD, startTime);
            }
        }
    }

    @Nonnull
    protected DynamicMessage deserializeUnion(@Nonnull Descriptors.Descriptor unionDescriptor, @Nonnull Tuple primaryKey, @Nonnull byte[] serialized, int metaDataVersion) {
        DynamicMessage unionMessage = this.deserializeFromBytes(unionDescriptor, serialized);
        Map<Descriptors.FieldDescriptor, Object> allFields = unionMessage.getAllFields();
        Map<Integer, UnknownFieldSet.Field> unknownFields = unionMessage.getUnknownFields().asMap();
        if (allFields.size() != 1 || !unknownFields.isEmpty()) {
            String detailedMessage = !unknownFields.isEmpty() ? " because there are unknown fields" : (allFields.size() > 1 ? " because there are extra known fields" : " because there are no fields");
            String message = "Could not deserialize union message" + detailedMessage;
            RecordSerializationException ex = new RecordSerializationException(message, new Object[0]).addLogInfo("unknownFields", unknownFields.keySet()).addLogInfo("fields", this.getFieldNames(allFields.keySet())).addLogInfo("primaryKey", (Object)primaryKey).addLogInfo("metaDataVersion", (Object)metaDataVersion);
            throw ex;
        }
        return unionMessage;
    }

    @Nonnull
    protected DynamicMessage deserializeFromBytes(@Nonnull Descriptors.Descriptor storedDescriptor, @Nonnull byte[] serialized) {
        try {
            return DynamicMessage.parseFrom(storedDescriptor, serialized);
        }
        catch (InvalidProtocolBufferException ex) {
            throw new RecordSerializationException("Error reading from byte array", ex).addLogInfo("recordType", (Object)storedDescriptor.getName());
        }
    }

    @Nonnull
    protected Map.Entry<Descriptors.FieldDescriptor, DynamicMessage> getUnionField(@Nonnull DynamicMessage unionMessage, @Nonnull Tuple primaryKey) {
        Map.Entry<Descriptors.FieldDescriptor, Object> entry = unionMessage.getAllFields().entrySet().iterator().next();
        DynamicMessage message = (DynamicMessage)entry.getValue();
        if (!message.getUnknownFields().asMap().isEmpty() && LOGGER.isWarnEnabled()) {
            LOGGER.warn(KeyValueLogMessage.of("Deserialized message has unknown fields", new Object[]{LogMessageKeys.PRIMARY_KEY, primaryKey, LogMessageKeys.RECORD_TYPE, message.getDescriptorForType().getName(), LogMessageKeys.UNKNOWN_FIELDS, message.getUnknownFields().asMap().keySet()}));
        }
        return Pair.of(entry.getKey(), message);
    }

    @Nonnull
    private Set<String> getFieldNames(Set<Descriptors.FieldDescriptor> fieldDescriptors) {
        return fieldDescriptors.stream().map(Descriptors.FieldDescriptor::getName).collect(Collectors.toSet());
    }
}

