/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record.provider.common;

import com.apple.foundationdb.record.provider.common.RecordSerializationException;
import com.apple.foundationdb.record.provider.common.SerializationKeyManager;
import java.security.Key;
import java.security.SecureRandom;
import java.util.Random;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class FixedZeroKeyManager
implements SerializationKeyManager {
    private final Key encryptionKey;
    private final String cipherName;
    private final SecureRandom secureRandom;

    public FixedZeroKeyManager(@Nonnull Key encryptionKey, @Nullable String cipherName, @Nullable SecureRandom secureRandom) {
        if (cipherName == null) {
            cipherName = "AES/CBC/PKCS5Padding";
        }
        if (secureRandom == null) {
            secureRandom = new SecureRandom();
        }
        this.encryptionKey = encryptionKey;
        this.cipherName = cipherName;
        this.secureRandom = secureRandom;
    }

    @Override
    public int getSerializationKey() {
        return 0;
    }

    @Override
    public Key getKey(int keyNumber) {
        if (keyNumber != 0) {
            throw new RecordSerializationException("only provide key number 0", new Object[0]);
        }
        return this.encryptionKey;
    }

    @Override
    public String getCipher(int keyNumber) {
        if (keyNumber != 0) {
            throw new RecordSerializationException("only provide key number 0", new Object[0]);
        }
        return this.cipherName;
    }

    @Override
    public Random getRandom(int keyNumber) {
        if (keyNumber != 0) {
            throw new RecordSerializationException("only provide key number 0", new Object[0]);
        }
        return this.secureRandom;
    }
}

