/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record.provider.common;

import com.apple.foundationdb.annotation.API;
import com.apple.foundationdb.record.RecordCoreArgumentException;
import com.apple.foundationdb.record.provider.common.RecordSerializationException;
import com.apple.foundationdb.record.provider.common.SerializationKeyManager;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.Key;
import java.security.KeyStore;
import java.security.SecureRandom;
import java.util.List;
import java.util.Random;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@API(value=API.Status.EXPERIMENTAL)
public class KeyStoreSerializationKeyManager
implements SerializationKeyManager {
    @Nonnull
    private final KeyStore keyStore;
    @Nonnull
    private final KeyStore.ProtectionParameter keyEntryPassword;
    @Nonnull
    private final List<String> keyEntryAliases;
    private final int defaultKeyNumber;
    @Nonnull
    private final String cipherName;
    @Nonnull
    private final SecureRandom secureRandom;

    protected KeyStoreSerializationKeyManager(@Nonnull KeyStore keyStore, @Nonnull KeyStore.ProtectionParameter keyEntryPassword, @Nonnull List<String> keyEntryAliases, int defaultKeyNumber, @Nonnull String cipherName, @Nonnull SecureRandom secureRandom) {
        this.keyStore = keyStore;
        this.keyEntryPassword = keyEntryPassword;
        this.keyEntryAliases = List.copyOf(keyEntryAliases);
        this.defaultKeyNumber = defaultKeyNumber;
        this.cipherName = cipherName;
        this.secureRandom = secureRandom;
    }

    @Override
    public int getSerializationKey() {
        return this.defaultKeyNumber;
    }

    @Override
    public Key getKey(int keyNumber) {
        KeyStore.SecretKeyEntry entry;
        if (keyNumber < 0 || keyNumber >= this.keyEntryAliases.size()) {
            throw new RecordSerializationException("key number out of range", new Object[0]);
        }
        String keyEntryAlias = this.keyEntryAliases.get(keyNumber);
        try {
            entry = (KeyStore.SecretKeyEntry)this.keyStore.getEntry(keyEntryAlias, this.keyEntryPassword);
        }
        catch (GeneralSecurityException ex) {
            throw new RecordSerializationException("cannot load key", ex);
        }
        return entry.getSecretKey();
    }

    @Override
    public String getCipher(int keyNumber) {
        return this.cipherName;
    }

    @Override
    public Random getRandom(int keyNumber) {
        return this.secureRandom;
    }

    @Nonnull
    public static Builder newBuilder() {
        return new Builder();
    }

    public static class Builder {
        @Nullable
        String keyStoreFileName;
        @Nullable
        String keyStorePassword;
        @Nullable
        String keyEntryPassword;
        @Nullable
        String defaultKeyEntryAlias;
        @Nullable
        List<String> keyEntryAliases;
        @Nonnull
        String cipherName = "AES/CBC/PKCS5Padding";
        @Nullable
        SecureRandom secureRandom;

        protected Builder() {
        }

        @Nullable
        public String getKeyStoreFileName() {
            return this.keyStoreFileName;
        }

        public void setKeyStoreFileName(@Nonnull String keyStoreFileName) {
            this.keyStoreFileName = keyStoreFileName;
        }

        @Nullable
        public String getKeyStorePassword() {
            return this.keyStorePassword;
        }

        public void setKeyStorePassword(@Nonnull String keyStorePassword) {
            this.keyStorePassword = keyStorePassword;
        }

        @Nullable
        public String getKeyEntryPassword() {
            return this.keyEntryPassword;
        }

        public void setKeyEntryPassword(@Nonnull String keyEntryPassword) {
            this.keyEntryPassword = keyEntryPassword;
        }

        @Nullable
        public String getDefaultKeyEntryAlias() {
            return this.defaultKeyEntryAlias;
        }

        public void setDefaultKeyEntryAlias(@Nonnull String defaultKeyEntryAlias) {
            this.defaultKeyEntryAlias = defaultKeyEntryAlias;
        }

        @Nullable
        public List<String> getKeyEntryAliases() {
            return this.keyEntryAliases;
        }

        public void setKeyEntryAliases(@Nonnull List<String> keyEntryAliases) {
            this.keyEntryAliases = keyEntryAliases;
        }

        @Nonnull
        public String getCipherName() {
            return this.cipherName;
        }

        public void setCipherName(@Nonnull String cipherName) {
            this.cipherName = cipherName;
        }

        @Nullable
        public SecureRandom getSecureRandom() {
            return this.secureRandom;
        }

        public void setSecureRandom(@Nonnull SecureRandom secureRandom) {
            this.secureRandom = secureRandom;
        }

        @Nonnull
        public KeyStoreSerializationKeyManager build() {
            int defaultKeyNumber;
            KeyStore keyStore;
            if (this.keyStoreFileName == null) {
                throw new RecordCoreArgumentException("must specify key store file name", new Object[0]);
            }
            if (this.keyStorePassword == null) {
                this.keyStorePassword = "";
            }
            try {
                keyStore = KeyStore.getInstance(new File(this.keyStoreFileName), this.keyStorePassword.toCharArray());
            }
            catch (FileNotFoundException ex) {
                throw new RecordCoreArgumentException("Key store not found", ex);
            }
            catch (IOException | GeneralSecurityException ex) {
                throw new RecordCoreArgumentException("Key store loading failed", ex);
            }
            if (this.keyEntryPassword == null) {
                this.keyEntryPassword = this.keyStorePassword;
            }
            KeyStore.PasswordProtection keyEntryProtection = new KeyStore.PasswordProtection(this.keyEntryPassword.toCharArray());
            if (this.keyEntryAliases == null && this.defaultKeyEntryAlias == null) {
                throw new RecordCoreArgumentException("must specify key alias list or single default alias", new Object[0]);
            }
            if (this.keyEntryAliases == null) {
                this.keyEntryAliases = List.of(this.defaultKeyEntryAlias);
                defaultKeyNumber = 0;
            } else if (this.defaultKeyEntryAlias == null) {
                if (this.keyEntryAliases.isEmpty()) {
                    throw new RecordCoreArgumentException("need at least one key alias", new Object[0]);
                }
                defaultKeyNumber = this.keyEntryAliases.size() - 1;
            } else {
                defaultKeyNumber = this.keyEntryAliases.indexOf(this.defaultKeyEntryAlias);
                if (defaultKeyNumber < 0) {
                    throw new RecordCoreArgumentException("default key alias not in key alias list", new Object[0]);
                }
            }
            if (this.secureRandom == null) {
                this.secureRandom = new SecureRandom();
            }
            return new KeyStoreSerializationKeyManager(keyStore, keyEntryProtection, this.keyEntryAliases, defaultKeyNumber, this.cipherName, this.secureRandom);
        }
    }
}

