/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record.provider.common;

import com.apple.foundationdb.annotation.API;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import javax.annotation.Nonnull;

@API(value=API.Status.EXPERIMENTAL)
public class MappedPool<K, V, E extends Exception> {
    protected static final int DEFAULT_POOL_SIZE = 64;
    protected static final int DEFAULT_MAX_ENTRIES = 64;
    protected final Cache<K, Queue<V>> pool;
    protected Callable<Queue<V>> loader;
    private final MappedPoolProvider<K, V, E> mappedPoolProvider;

    public MappedPool(MappedPoolProvider<K, V, E> mappedPoolProvider) {
        this(mappedPoolProvider, 64);
    }

    public MappedPool(MappedPoolProvider<K, V, E> mappedPoolProvider, int poolSize) {
        this(mappedPoolProvider, poolSize, 64);
    }

    public MappedPool(MappedPoolProvider<K, V, E> mappedPoolProvider, int defaultPoolSize, int maxEntries) {
        this.pool = CacheBuilder.newBuilder().maximumSize(maxEntries).build();
        this.loader = () -> new ArrayBlockingQueue(defaultPoolSize);
        this.mappedPoolProvider = mappedPoolProvider;
    }

    public V poll(@Nonnull K key) throws E {
        try {
            V next = this.pool.get(key, this.loader).poll();
            return next == null ? this.mappedPoolProvider.get(key) : next;
        }
        catch (ExecutionException ee) {
            return this.mappedPoolProvider.get(key);
        }
    }

    public boolean offer(@Nonnull K key, @Nonnull V value) {
        try {
            return this.pool.get(key, this.loader).offer(value);
        }
        catch (Exception e) {
            return false;
        }
    }

    public Set<K> getKeys() {
        return this.pool.asMap().keySet();
    }

    public int getPoolSize(K key) {
        Queue<V> queue = this.pool.getIfPresent(key);
        return queue == null ? 0 : queue.size();
    }

    public void invalidateAll() {
        this.pool.invalidateAll();
    }

    public static interface MappedPoolProvider<K, V, E extends Exception> {
        public V get(K var1) throws E;
    }
}

