/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record.provider.common;

import com.apple.foundationdb.annotation.API;
import com.apple.foundationdb.record.RecordMetaData;
import com.apple.foundationdb.record.metadata.RecordType;
import com.apple.foundationdb.record.provider.common.MessageBuilderRecordSerializerBase;
import com.apple.foundationdb.record.provider.common.RecordSerializationException;
import com.apple.foundationdb.record.provider.common.RecordSerializer;
import com.google.protobuf.Descriptors;
import com.google.protobuf.Message;
import java.util.List;
import java.util.function.Supplier;
import javax.annotation.Nonnull;

@API(value=API.Status.UNSTABLE)
public class MessageBuilderRecordSerializer
extends MessageBuilderRecordSerializerBase<Message, Message, Message.Builder> {
    public MessageBuilderRecordSerializer(@Nonnull Supplier<Message.Builder> builderSupplier) {
        super(builderSupplier);
    }

    @Override
    protected void setUnionField(@Nonnull RecordMetaData metaData, @Nonnull RecordType recordType, @Nonnull Message.Builder unionBuilder, @Nonnull Message rec) {
        Descriptors.FieldDescriptor unionField = metaData.getUnionFieldForRecordType(recordType);
        unionBuilder.setField(unionField, rec);
    }

    @Override
    @Nonnull
    protected Message getUnionField(@Nonnull Descriptors.Descriptor unionDescriptor, @Nonnull Message storedRecord) {
        List<Descriptors.OneofDescriptor> oneofs = unionDescriptor.getOneofs();
        if (!oneofs.isEmpty()) {
            Descriptors.FieldDescriptor unionField = storedRecord.getOneofFieldDescriptor(oneofs.get(0));
            if (unionField != null) {
                return (Message)storedRecord.getField(unionField);
            }
        } else {
            for (Descriptors.FieldDescriptor unionField : unionDescriptor.getFields()) {
                if (!storedRecord.hasField(unionField)) continue;
                return (Message)storedRecord.getField(unionField);
            }
        }
        throw new RecordSerializationException("Union record does not have any fields", new Object[0]).addLogInfo("unionDescriptorFullName", (Object)unionDescriptor.getFullName()).addLogInfo("recordType", (Object)storedRecord.getDescriptorForType().getName());
    }

    @Override
    @Nonnull
    public RecordSerializer<Message> widen() {
        return this;
    }
}

