/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record.provider.common;

import com.apple.foundationdb.annotation.API;
import com.apple.foundationdb.record.RecordMetaData;
import com.apple.foundationdb.record.logging.LogMessageKeys;
import com.apple.foundationdb.record.metadata.RecordType;
import com.apple.foundationdb.record.provider.common.MessageBuilderRecordSerializer;
import com.apple.foundationdb.record.provider.common.RecordSerializationException;
import com.apple.foundationdb.record.provider.common.RecordSerializer;
import com.apple.foundationdb.record.provider.common.StoreTimer;
import com.apple.foundationdb.tuple.Tuple;
import com.google.protobuf.Descriptors;
import com.google.protobuf.InvalidProtocolBufferException;
import com.google.protobuf.Message;
import com.google.protobuf.UninitializedMessageException;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@API(value=API.Status.UNSTABLE)
public abstract class MessageBuilderRecordSerializerBase<M extends Message, U extends Message, B extends Message.Builder>
implements RecordSerializer<M> {
    @Nonnull
    private final Supplier<B> builderSupplier;

    public MessageBuilderRecordSerializerBase(@Nonnull Supplier<B> builderSupplier) {
        this.builderSupplier = builderSupplier;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nonnull
    public byte[] serialize(@Nonnull RecordMetaData metaData, @Nonnull RecordType recordType, @Nonnull M rec, @Nullable StoreTimer timer) {
        long startTime = System.nanoTime();
        try {
            Descriptors.Descriptor unionDescriptor = metaData.getUnionDescriptor();
            Message.Builder unionBuilder = (Message.Builder)this.builderSupplier.get();
            if (unionBuilder.getDescriptorForType() != unionDescriptor) {
                throw new RecordSerializationException("Builder does not match union type", new Object[0]).addLogInfo("recordType", (Object)recordType.getName()).addLogInfo("unionDescriptorFullName", (Object)metaData.getUnionDescriptor().getFullName()).addLogInfo(new Object[]{LogMessageKeys.META_DATA_VERSION, metaData.getVersion()});
            }
            this.setUnionField(metaData, recordType, unionBuilder, rec);
            Message storedRecord = unionBuilder.build();
            byte[] byArray = storedRecord.toByteArray();
            return byArray;
        }
        finally {
            if (timer != null) {
                timer.recordSinceNanoTime(RecordSerializer.Events.SERIALIZE_PROTOBUF_RECORD, startTime);
            }
        }
    }

    protected abstract void setUnionField(@Nonnull RecordMetaData var1, @Nonnull RecordType var2, @Nonnull B var3, @Nonnull M var4);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nonnull
    public M deserialize(@Nonnull RecordMetaData metaData, @Nonnull Tuple primaryKey, @Nonnull byte[] serialized, @Nullable StoreTimer timer) {
        long startTime = System.nanoTime();
        try {
            Message storedRecord;
            Descriptors.Descriptor unionDescriptor = metaData.getUnionDescriptor();
            Message.Builder unionBuilder = (Message.Builder)this.builderSupplier.get();
            if (unionBuilder.getDescriptorForType() != unionDescriptor) {
                throw new RecordSerializationException("Builder does not match union type", new Object[0]).addLogInfo(new Object[]{LogMessageKeys.PRIMARY_KEY, primaryKey}).addLogInfo("unionDescriptorFullName", (Object)metaData.getUnionDescriptor().getFullName()).addLogInfo(new Object[]{LogMessageKeys.META_DATA_VERSION, metaData.getVersion()});
            }
            try {
                storedRecord = unionBuilder.mergeFrom(serialized).build();
            }
            catch (InvalidProtocolBufferException | UninitializedMessageException ex) {
                InvalidProtocolBufferException iex = ex instanceof InvalidProtocolBufferException ? (InvalidProtocolBufferException)ex : ((UninitializedMessageException)ex).asInvalidProtocolBufferException();
                throw new RecordSerializationException("Error reading from byte array", iex).addLogInfo(new Object[]{LogMessageKeys.PRIMARY_KEY, primaryKey}).addLogInfo(new Object[]{LogMessageKeys.META_DATA_VERSION, metaData.getVersion()});
            }
            M m4 = this.getUnionField(unionDescriptor, storedRecord);
            return m4;
        }
        finally {
            if (timer != null) {
                timer.recordSinceNanoTime(RecordSerializer.Events.DESERIALIZE_PROTOBUF_RECORD, startTime);
            }
        }
    }

    @Nonnull
    protected abstract M getUnionField(@Nonnull Descriptors.Descriptor var1, @Nonnull U var2);

    @Override
    @Nonnull
    public RecordSerializer<Message> widen() {
        return new MessageBuilderRecordSerializer(this.builderSupplier::get);
    }
}

