/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record.provider.common;

import com.apple.foundationdb.annotation.API;
import com.apple.foundationdb.record.RecordMetaData;
import com.apple.foundationdb.record.metadata.RecordType;
import com.apple.foundationdb.record.provider.common.RecordSerializationValidationException;
import com.apple.foundationdb.record.provider.common.StoreTimer;
import com.apple.foundationdb.record.provider.foundationdb.FDBStoredRecord;
import com.apple.foundationdb.record.provider.foundationdb.FDBStoredRecordBuilder;
import com.apple.foundationdb.tuple.Tuple;
import com.google.protobuf.Message;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@API(value=API.Status.UNSTABLE)
public interface RecordSerializer<M extends Message> {
    @Nonnull
    public byte[] serialize(@Nonnull RecordMetaData var1, @Nonnull RecordType var2, @Nonnull M var3, @Nullable StoreTimer var4);

    @Nonnull
    public M deserialize(@Nonnull RecordMetaData var1, @Nonnull Tuple var2, @Nonnull byte[] var3, @Nullable StoreTimer var4);

    @Nonnull
    public RecordSerializer<Message> widen();

    default public void validateSerialization(@Nonnull RecordMetaData metaData, @Nonnull RecordType recordType, @Nonnull M rec, @Nonnull byte[] serialized, @Nullable StoreTimer timer) {
        M deserialized;
        Tuple primaryKey = null;
        try {
            FDBStoredRecordBuilder recordBuilder = FDBStoredRecord.newBuilder().setRecordType(recordType).setRecord(rec);
            primaryKey = recordType.getPrimaryKey().evaluateMessageSingleton(recordBuilder, (Message)rec).toTuple();
            deserialized = this.deserialize(metaData, primaryKey, serialized, timer);
        }
        catch (Exception e) {
            throw new RecordSerializationValidationException("cannot deserialize record", recordType, primaryKey, e);
        }
        if (!Objects.equals(rec, deserialized)) {
            throw new RecordSerializationValidationException("record serialization mismatch", recordType, primaryKey);
        }
    }

    @API(value=API.Status.UNSTABLE)
    public static enum Counts implements StoreTimer.Count
    {
        ESCHEW_RECORD_COMPRESSION("eschew record compression"),
        RECORD_BYTES_BEFORE_COMPRESSION("record bytes before compression"),
        RECORD_BYTES_AFTER_COMPRESSION("record bytes after compression");

        private final String title;
        private final boolean isSize;
        private final String logKey;

        private Counts(String title, boolean isSize, String logKey) {
            this.title = title;
            this.isSize = false;
            this.logKey = logKey != null ? logKey : StoreTimer.Count.super.logKey();
        }

        private Counts(String title, boolean isSize) {
            this(title, isSize, null);
        }

        private Counts(String title) {
            this(title, false, null);
        }

        @Override
        public String title() {
            return this.title;
        }

        @Override
        @Nonnull
        public String logKey() {
            return this.logKey;
        }

        @Override
        public boolean isSize() {
            return this.isSize;
        }
    }

    @API(value=API.Status.UNSTABLE)
    public static enum Events implements StoreTimer.DetailEvent
    {
        SERIALIZE_PROTOBUF_RECORD("serialize protobuf record"),
        DESERIALIZE_PROTOBUF_RECORD("deserialize protobuf record"),
        COMPRESS_SERIALIZED_RECORD("compress serialized record"),
        DECOMPRESS_SERIALIZED_RECORD("decompress serialized record"),
        ENCRYPT_SERIALIZED_RECORD("encrypt serialized record"),
        DECRYPT_SERIALIZED_RECORD("decrypt serialized record");

        private final String title;
        private final String logKey;

        private Events(String title, String logKey) {
            this.title = title;
            this.logKey = logKey != null ? logKey : StoreTimer.DetailEvent.super.logKey();
        }

        private Events(String title) {
            this(title, null);
        }

        @Override
        public String title() {
            return this.title;
        }

        @Override
        @Nonnull
        public String logKey() {
            return this.logKey;
        }
    }
}

