/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record.provider.common;

import com.apple.foundationdb.annotation.API;
import com.apple.foundationdb.record.RecordCoreArgumentException;
import com.apple.foundationdb.record.RecordCoreException;
import com.apple.foundationdb.record.RecordCursor;
import com.apple.foundationdb.record.RecordCursorResult;
import com.apple.foundationdb.record.RecordCursorVisitor;
import com.apple.foundationdb.record.provider.common.StoreTimerSnapshot;
import com.apple.foundationdb.record.util.MapUtils;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@API(value=API.Status.UNSTABLE)
public class StoreTimer {
    @Nonnull
    private static final Counter ZERO_COUNTER = new Counter(true);
    @Nonnull
    protected final Map<Event, Counter> counters = new ConcurrentHashMap<Event, Counter>();
    @Nonnull
    protected final Map<Event, Counter> timeoutCounters = new ConcurrentHashMap<Event, Counter>();
    protected long lastReset = System.nanoTime();
    @Nonnull
    protected final UUID uuid = UUID.randomUUID();

    public static void checkEventNameUniqueness(@Nonnull Stream<Event> events) {
        HashSet seen = new HashSet();
        Set duplicates = events.map(Event::name).filter(n -> !seen.add(n)).collect(Collectors.toSet());
        if (!duplicates.isEmpty()) {
            throw new RecordCoreException("Duplicate event names: " + String.valueOf(duplicates), new Object[0]);
        }
    }

    @Nonnull
    public static StoreTimer getDifference(@Nonnull StoreTimer timer, @Nonnull StoreTimerSnapshot timerSnapshot) {
        if (!timerSnapshot.derivedFrom(timer)) {
            throw new RecordCoreArgumentException("Invalid to subtract a snapshot timer from a timer it was not derived from.", new Object[0]);
        }
        if (!timerSnapshot.takenAfterReset(timer)) {
            throw new RecordCoreArgumentException("Invalid to substract a snapshot timer from a timer that has been reset after the snapshot was taken", new Object[0]);
        }
        StoreTimer resultTimer = new StoreTimer();
        StoreTimer.computeDifference(timer.counters, timerSnapshot.getCounters(), resultTimer.counters);
        StoreTimer.computeDifference(timer.timeoutCounters, timerSnapshot.getTimeoutCounters(), resultTimer.timeoutCounters);
        timerSnapshot.setResetTime(resultTimer);
        return resultTimer;
    }

    private static void computeDifference(@Nonnull Map<Event, Counter> timerCounters, @Nonnull Map<Event, StoreTimerSnapshot.CounterSnapshot> snapShotCounters, @Nonnull Map<Event, Counter> differenceCounters) {
        for (Map.Entry<Event, Counter> entry : timerCounters.entrySet()) {
            Event event = entry.getKey();
            Counter counter = entry.getValue();
            StoreTimerSnapshot.CounterSnapshot snapShotCounter = snapShotCounters.get(event);
            if (snapShotCounter == null) {
                differenceCounters.put(event, new Counter(counter));
                continue;
            }
            int count = counter.getCount() - snapShotCounter.getCount();
            if (count <= 0) continue;
            differenceCounters.put(event, new Counter(count, counter.getCumulativeValue() - snapShotCounter.getCumulativeValue()));
        }
    }

    @Nullable
    public Counter getCounter(@Nonnull Event event) {
        return this.getCounter(event, false);
    }

    @Nullable
    protected Counter getCounter(@Nonnull Event event, boolean createIfNotExists) {
        if (event instanceof Aggregate) {
            Counter counter = ((Aggregate)event).compute(this);
            if (counter == null && createIfNotExists) {
                return ZERO_COUNTER;
            }
            return counter;
        }
        if (createIfNotExists) {
            return MapUtils.computeIfAbsent(this.counters, event, evignore -> new Counter());
        }
        return this.counters.get(event);
    }

    @Nullable
    public Counter getTimeoutCounter(@Nonnull Event event) {
        return this.getTimeoutCounter(event, false);
    }

    @Nullable
    protected Counter getTimeoutCounter(@Nonnull Event event, boolean createIfNotExists) {
        if (createIfNotExists) {
            return MapUtils.computeIfAbsent(this.timeoutCounters, event, evignore -> new Counter());
        }
        return this.timeoutCounters.get(event);
    }

    @Nonnull
    public UUID geUUID() {
        return this.uuid;
    }

    public void record(Set<Event> events, long timeDifferenceNanos) {
        for (Event event : events) {
            this.record(event, timeDifferenceNanos);
        }
    }

    public void record(Event event, long timeDifferenceNanos) {
        this.getCounter(event, true).record(timeDifferenceNanos);
    }

    public void recordSize(SizeEvent event, long size) {
        this.getCounter(event, true).record(size);
    }

    public void recordSinceNanoTime(@Nonnull Event event, long startTime) {
        this.record(event, System.nanoTime() - startTime);
    }

    public void recordTimeout(Wait event, long startTime) {
        this.getTimeoutCounter(event, true).record(System.nanoTime() - startTime);
    }

    public void increment(@Nonnull Set<Count> events) {
        for (Count event : events) {
            this.increment(event);
        }
    }

    public void increment(@Nonnull Count event) {
        this.increment(event, 1);
    }

    public void increment(@Nonnull Set<Count> events, int amount) {
        for (Count event : events) {
            this.increment(event, amount);
        }
    }

    public void increment(@Nonnull Count event, int amount) {
        this.getCounter(event, true).increment(amount);
    }

    public long getTimeNanos(Event event) {
        Counter counter = this.getCounter(event, false);
        return counter == null ? 0L : counter.getCumulativeValue();
    }

    public int getCount(Event event) {
        Counter counter = this.getCounter(event, false);
        return counter == null ? 0 : counter.getCount();
    }

    public long getSize(SizeEvent event) {
        Counter counter = this.getCounter(event, false);
        return counter == null ? 0L : counter.getCumulativeValue();
    }

    public long getTimeoutTimeNanos(Event event) {
        Counter counter = this.getTimeoutCounter(event, false);
        return counter == null ? 0L : counter.getCumulativeValue();
    }

    public int getTimeoutCount(Event event) {
        Counter counter = this.getTimeoutCounter(event, false);
        return counter == null ? 0 : counter.getCount();
    }

    @Nonnull
    public Set<Aggregate> getAggregates() {
        return Collections.emptySet();
    }

    public Collection<Event> getEvents() {
        return this.counters.keySet();
    }

    public Collection<Event> getTimeoutEvents() {
        return this.timeoutCounters.keySet();
    }

    public void add(StoreTimer other) {
        Counter thisCounter;
        for (Map.Entry<Event, Counter> entry : other.counters.entrySet()) {
            thisCounter = Objects.requireNonNull(this.getCounter(entry.getKey(), true));
            thisCounter.add(entry.getValue());
        }
        for (Map.Entry<Event, Counter> entry : other.timeoutCounters.entrySet()) {
            thisCounter = Objects.requireNonNull(this.getTimeoutCounter(entry.getKey(), true));
            thisCounter.add(entry.getValue());
        }
    }

    public Map<String, Number> getKeysAndValues() {
        Collection<Event> timeoutEvents = this.getTimeoutEvents();
        HashMap<String, Number> result = new HashMap<String, Number>((this.counters.size() + timeoutEvents.size()) * 2);
        for (Map.Entry<Event, Counter> entry : this.counters.entrySet()) {
            Event event = entry.getKey();
            Counter counter = entry.getValue();
            result.put(event.logKeyWithSuffix("_count"), counter.count.get());
            if (event instanceof SizeEvent) {
                result.put(event.logKeyWithSuffix("_size"), counter.getCumulativeValue());
                continue;
            }
            if (event instanceof Count) continue;
            result.put(event.logKeyWithSuffix("_micros"), counter.getTimeNanos() / 1000L);
        }
        for (Event timeoutEvent : timeoutEvents) {
            result.put(timeoutEvent.logKeyWithSuffix("_timeout_micros"), this.getTimeoutTimeNanos(timeoutEvent) / 1000L);
            result.put(timeoutEvent.logKeyWithSuffix("_timeout_count"), this.getTimeoutCount(timeoutEvent));
        }
        for (Aggregate aggregate : this.getAggregates()) {
            Counter counter = aggregate.compute(this);
            if (counter == null) continue;
            result.put(aggregate.logKeyWithSuffix("_count"), counter.count.get());
            if (aggregate instanceof Count) continue;
            result.put(aggregate.logKeyWithSuffix("_micros"), counter.getTimeNanos() / 1000L);
        }
        return result;
    }

    public void reset() {
        this.counters.clear();
        this.timeoutCounters.clear();
        this.lastReset = System.nanoTime();
    }

    public <T> CompletableFuture<T> instrument(Event event, CompletableFuture<T> future) {
        return this.instrument(event, future, null);
    }

    public <T> CompletableFuture<T> instrument(Event event, CompletableFuture<T> future, Executor executor) {
        if (future.isDone()) {
            this.record(event, 0L);
            return future;
        }
        return this.instrumentAsync(Collections.singleton(event), future, System.nanoTime());
    }

    public <T> CompletableFuture<T> instrument(Set<Event> events, CompletableFuture<T> future, Executor executor) {
        if (future.isDone()) {
            for (Event event : events) {
                this.record(event, 0L);
            }
            return future;
        }
        return this.instrumentAsync(events, future, System.nanoTime());
    }

    public <T> CompletableFuture<T> instrument(Event event, CompletableFuture<T> future, Executor executor, long startTime) {
        if (future.isDone()) {
            this.record(event, System.nanoTime() - startTime);
            return future;
        }
        return this.instrumentAsync(Collections.singleton(event), future, startTime);
    }

    public <T> CompletableFuture<T> instrument(Set<Event> events, CompletableFuture<T> future, Executor executor, long startTime) {
        if (future.isDone()) {
            long timeDifference = System.nanoTime() - startTime;
            for (Event event : events) {
                this.record(event, timeDifference);
            }
            return future;
        }
        return this.instrumentAsync(events, future, startTime);
    }

    public <T> RecordCursor<T> instrument(final Event event, final RecordCursor<T> inner) {
        return new RecordCursor<T>(){
            RecordCursorResult<T> nextResult;

            @Override
            @Nonnull
            public CompletableFuture<RecordCursorResult<T>> onNext() {
                return StoreTimer.this.instrument(event, inner.onNext(), inner.getExecutor()).thenApply(result -> {
                    this.nextResult = result;
                    return this.nextResult;
                });
            }

            @Override
            public void close() {
                inner.close();
            }

            @Override
            public boolean isClosed() {
                return inner.isClosed();
            }

            @Override
            @Nonnull
            public Executor getExecutor() {
                return inner.getExecutor();
            }

            @Override
            public boolean accept(@Nonnull RecordCursorVisitor visitor) {
                if (visitor.visitEnter(this)) {
                    inner.accept(visitor);
                }
                return visitor.visitLeave(this);
            }
        };
    }

    protected <T> CompletableFuture<T> instrumentAsync(Set<Event> events, CompletableFuture<T> future, long startTime) {
        return future.whenComplete((result, exception) -> {
            long timeDifference = System.nanoTime() - startTime;
            for (Event event : events) {
                this.record(event, timeDifference);
            }
        });
    }

    public static interface Event {
        public static final Map<String, Map<Event, String>> LOG_KEY_SUFFIX_CACHE = new ConcurrentHashMap<String, Map<Event, String>>();

        public String name();

        public String title();

        default public boolean isDelayedUntilCommit() {
            return false;
        }

        default public String logKey() {
            return this.name().toLowerCase(Locale.ROOT);
        }

        default public String logKeyWithSuffix(@Nonnull String suffix) {
            return MapUtils.computeIfAbsent(MapUtils.computeIfAbsent(LOG_KEY_SUFFIX_CACHE, suffix, ignoredPostfix -> new ConcurrentHashMap()), this, event -> event.logKey() + suffix);
        }
    }

    public static class Counter {
        private final AtomicLong cumulativeValue;
        private final AtomicInteger count;
        private boolean immutable;

        private Counter() {
            this(false);
        }

        private Counter(Counter counter) {
            this(counter, false);
        }

        private Counter(Counter counter, boolean immutable) {
            this(counter.getCount(), counter.getCumulativeValue(), immutable);
        }

        public Counter(boolean immutable) {
            this(0, 0L, immutable);
        }

        public Counter(int count, long timeNanos) {
            this(count, timeNanos, false);
        }

        public Counter(int count, long cumulativeValue, boolean immutable) {
            this.count = new AtomicInteger(count);
            this.cumulativeValue = new AtomicLong(cumulativeValue);
            this.immutable = immutable;
        }

        public int getCount() {
            return this.count.get();
        }

        public long getTimeNanos() {
            return this.getCumulativeValue();
        }

        public long getCumulativeValue() {
            return this.cumulativeValue.get();
        }

        public void record(long occurrenceValue) {
            this.checkImmutable();
            this.cumulativeValue.addAndGet(occurrenceValue);
            this.count.incrementAndGet();
        }

        public void increment(int amount) {
            this.checkImmutable();
            this.count.addAndGet(amount);
        }

        public void add(@Nonnull Counter counter) {
            this.checkImmutable();
            this.cumulativeValue.addAndGet(counter.getCumulativeValue());
            this.count.addAndGet(counter.getCount());
        }

        protected Counter makeImmutable() {
            this.immutable = true;
            return this;
        }

        private void checkImmutable() {
            if (this.immutable) {
                throw new RecordCoreException("immutable counter", new Object[0]);
            }
        }
    }

    public static interface Aggregate
    extends Event {
        public Set<? extends Event> getComponentEvents();

        default public <T extends Event> T[] validate(T ... events) {
            return this.validate((a, b) -> {}, (Event[])events);
        }

        default public <T extends Event> T[] validate(@Nonnull BiConsumer<T, T> extraCheck, T ... events) {
            if (events.length == 0) {
                throw new RecordCoreArgumentException("At least one event must be supplied to aggregate", new Object[0]);
            }
            if (events.length > 1) {
                T firstEvent = events[0];
                for (int i = 1; i < events.length; ++i) {
                    T event = events[i];
                    extraCheck.accept(firstEvent, event);
                    if (!firstEvent.getClass().isInstance(event)) {
                        throw new RecordCoreArgumentException("All events must be of the same type", new Object[0]);
                    }
                    if (!(event instanceof Aggregate)) continue;
                    throw new RecordCoreArgumentException("Aggregates may not be constructed from other aggregates", new Object[0]);
                }
            }
            return events;
        }

        @Nullable
        public Counter compute(@Nonnull StoreTimer var1);

        @Nullable
        default public Counter compute(@Nonnull StoreTimer storeTimer, @Nonnull Set<? extends Event> events) {
            Counter counter = null;
            for (Event event : events) {
                Counter value = storeTimer.counters.get(event);
                if (value == null) continue;
                if (counter == null) {
                    counter = new Counter();
                }
                counter.add(value);
            }
            return counter == null ? null : counter.makeImmutable();
        }
    }

    public static interface Count
    extends Event {
        public boolean isSize();
    }

    public static interface SizeEvent
    extends Event {
    }

    public static interface Wait
    extends Event {
    }

    public static interface DetailEvent
    extends Event {
    }
}

