/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record.provider.common;

import com.apple.foundationdb.annotation.API;
import com.apple.foundationdb.record.provider.common.StoreTimer;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@API(value=API.Status.UNSTABLE)
public final class StoreTimerSnapshot {
    @Nonnull
    private final ImmutableMap<StoreTimer.Event, CounterSnapshot> counters;
    @Nonnull
    private final ImmutableMap<StoreTimer.Event, CounterSnapshot> timeoutCounters;
    @Nonnull
    private final UUID fromUUID;
    private final long createTime;

    private StoreTimerSnapshot(@Nonnull StoreTimer timer) {
        ImmutableMap.Builder counters = new ImmutableMap.Builder();
        ImmutableMap.Builder timeoutCounters = new ImmutableMap.Builder();
        timer.counters.forEach((key, value) -> counters.put(key, CounterSnapshot.from(value)));
        timer.timeoutCounters.forEach((key, value) -> timeoutCounters.put(key, CounterSnapshot.from(value)));
        this.counters = counters.build();
        this.timeoutCounters = timeoutCounters.build();
        this.fromUUID = timer.geUUID();
        this.createTime = System.nanoTime();
    }

    @Nonnull
    public static StoreTimerSnapshot from(@Nonnull StoreTimer timer) {
        return new StoreTimerSnapshot(timer);
    }

    public Map<StoreTimer.Event, CounterSnapshot> getCounters() {
        return this.counters;
    }

    public Map<StoreTimer.Event, CounterSnapshot> getTimeoutCounters() {
        return this.timeoutCounters;
    }

    @Nullable
    public CounterSnapshot getCounterSnapshot(@Nonnull StoreTimer.Event event) {
        return this.counters.get(event);
    }

    public boolean containsCounter(@Nonnull StoreTimer.Event event) {
        return this.counters.containsKey(event);
    }

    @Nullable
    public CounterSnapshot getTimeoutCounterSnapshot(@Nonnull StoreTimer.Event event) {
        return this.timeoutCounters.get(event);
    }

    public boolean containsTimeoutCounter(@Nonnull StoreTimer.Event event) {
        return this.timeoutCounters.containsKey(event);
    }

    public boolean derivedFrom(StoreTimer timer) {
        return timer.geUUID() == this.fromUUID;
    }

    public boolean takenAfterReset(StoreTimer timer) {
        return timer.lastReset <= this.createTime;
    }

    public void setResetTime(StoreTimer timer) {
        timer.lastReset = this.createTime;
    }

    public static class CounterSnapshot {
        private final long cumulativeValue;
        private final int count;

        private CounterSnapshot(@Nonnull StoreTimer.Counter c) {
            this.cumulativeValue = c.getCumulativeValue();
            this.count = c.getCount();
        }

        @Nonnull
        public static CounterSnapshot from(@Nonnull StoreTimer.Counter counter) {
            return new CounterSnapshot(counter);
        }

        public int getCount() {
            return this.count;
        }

        public long getTimeNanos() {
            return this.getCumulativeValue();
        }

        public long getCumulativeValue() {
            return this.cumulativeValue;
        }
    }
}

