/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record.provider.common;

import com.apple.foundationdb.annotation.API;
import com.apple.foundationdb.record.RecordCoreArgumentException;
import com.apple.foundationdb.record.RecordCoreException;
import com.apple.foundationdb.record.RecordMetaData;
import com.apple.foundationdb.record.logging.LogMessageKeys;
import com.apple.foundationdb.record.metadata.RecordType;
import com.apple.foundationdb.record.provider.common.DynamicMessageRecordSerializer;
import com.apple.foundationdb.record.provider.common.RecordSerializationException;
import com.apple.foundationdb.record.provider.common.RecordSerializer;
import com.apple.foundationdb.record.provider.common.StoreTimer;
import com.apple.foundationdb.record.provider.common.TransformedRecordSerializerPrefix;
import com.apple.foundationdb.record.provider.common.TransformedRecordSerializerState;
import com.apple.foundationdb.tuple.Tuple;
import com.google.protobuf.Message;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.security.GeneralSecurityException;
import java.util.concurrent.ThreadLocalRandom;
import java.util.zip.DataFormatException;
import java.util.zip.Deflater;
import java.util.zip.Inflater;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@API(value=API.Status.UNSTABLE)
public class TransformedRecordSerializer<M extends Message>
implements RecordSerializer<M> {
    protected static final int DEFAULT_COMPRESSION_LEVEL = 9;
    protected static final int MIN_COMPRESSION_VERSION = 1;
    protected static final int MAX_COMPRESSION_VERSION = 1;
    @Nonnull
    protected final RecordSerializer<M> inner;
    protected final boolean compressWhenSerializing;
    protected final int compressionLevel;
    protected final boolean encryptWhenSerializing;
    protected final double writeValidationRatio;

    protected TransformedRecordSerializer(@Nonnull RecordSerializer<M> inner, boolean compressWhenSerializing, int compressionLevel, boolean encryptWhenSerializing, double writeValidationRatio) {
        this.inner = inner;
        this.compressWhenSerializing = compressWhenSerializing;
        this.compressionLevel = compressionLevel;
        this.encryptWhenSerializing = encryptWhenSerializing;
        this.writeValidationRatio = writeValidationRatio;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void compress(@Nonnull TransformedRecordSerializerState state, @Nullable StoreTimer timer) {
        long startTime = System.nanoTime();
        this.increment(timer, RecordSerializer.Counts.RECORD_BYTES_BEFORE_COMPRESSION, state.getLength());
        if (state.getLength() > 5) {
            int compressedLength;
            byte[] compressed = new byte[state.getLength()];
            Deflater compressor = new Deflater(this.compressionLevel);
            try {
                compressor.setInput(state.getData(), state.getOffset(), state.getLength());
                compressor.finish();
                compressedLength = compressor.deflate(compressed, 5, compressed.length - 5, 3);
            }
            finally {
                compressor.end();
            }
            if (compressedLength == compressed.length - 5) {
                this.increment(timer, RecordSerializer.Counts.RECORD_BYTES_AFTER_COMPRESSION, state.getLength());
                state.setCompressed(false);
            } else {
                compressed[0] = 1;
                ByteBuffer.wrap(compressed, 1, 4).order(ByteOrder.BIG_ENDIAN).putInt(state.getLength());
                state.setCompressed(true);
                this.increment(timer, RecordSerializer.Counts.RECORD_BYTES_AFTER_COMPRESSION, compressedLength + 5);
                state.setDataArray(compressed, 0, compressedLength + 5);
            }
        } else {
            this.increment(timer, RecordSerializer.Counts.RECORD_BYTES_AFTER_COMPRESSION, state.getLength());
        }
        if (timer != null) {
            timer.recordSinceNanoTime(RecordSerializer.Events.COMPRESS_SERIALIZED_RECORD, startTime);
            if (!state.isCompressed()) {
                timer.increment(RecordSerializer.Counts.ESCHEW_RECORD_COMPRESSION);
            }
        }
    }

    private void increment(@Nullable StoreTimer timer, StoreTimer.Count counter, int amount) {
        if (timer != null) {
            timer.increment(counter, amount);
        }
    }

    protected void encrypt(@Nonnull TransformedRecordSerializerState state, @Nullable StoreTimer timer) throws GeneralSecurityException {
        throw new RecordSerializationException("this serializer cannot encrypt", new Object[0]);
    }

    private boolean shouldValidateSerialization() {
        return this.writeValidationRatio >= 1.0 || this.writeValidationRatio > 0.0 && ThreadLocalRandom.current().nextDouble() < this.writeValidationRatio;
    }

    @Override
    @Nonnull
    public byte[] serialize(@Nonnull RecordMetaData metaData, @Nonnull RecordType recordType, @Nonnull M rec, @Nullable StoreTimer timer) {
        byte[] innerSerialized = this.inner.serialize(metaData, recordType, rec, timer);
        TransformedRecordSerializerState state = new TransformedRecordSerializerState(innerSerialized);
        if (this.compressWhenSerializing) {
            this.compress(state, timer);
        }
        if (this.encryptWhenSerializing) {
            try {
                this.encrypt(state, timer);
            }
            catch (GeneralSecurityException ex) {
                throw new RecordSerializationException("encryption error", ex).addLogInfo("recordType", (Object)recordType.getName()).addLogInfo(new Object[]{LogMessageKeys.META_DATA_VERSION, metaData.getVersion()});
            }
        }
        TransformedRecordSerializerPrefix.encodePrefix(state);
        if (this.shouldValidateSerialization()) {
            this.validateSerialization(metaData, recordType, rec, state.getDataArray(), timer);
        }
        return state.getDataArray();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void decompress(@Nonnull TransformedRecordSerializerState state, @Nullable StoreTimer timer) throws DataFormatException {
        long startTime = System.nanoTime();
        byte compressionVersion = state.getData()[state.getOffset()];
        if (compressionVersion < 1 || compressionVersion > 1) {
            throw new RecordSerializationException("unknown compression version", new Object[0]).addLogInfo("compressionVersion", (Object)compressionVersion);
        }
        int decompressedLength = ByteBuffer.wrap(state.getData(), state.getOffset() + 1, 4).order(ByteOrder.BIG_ENDIAN).getInt();
        byte[] decompressed = new byte[decompressedLength];
        Inflater decompressor = new Inflater();
        try {
            decompressor.setInput(state.getData(), state.getOffset() + 5, state.getLength() - 5);
            int actualDecompressedSize = decompressor.inflate(decompressed);
            if (actualDecompressedSize < decompressedLength) {
                throw new RecordSerializationException("decompressed record too small", new Object[0]).addLogInfo(new Object[]{LogMessageKeys.EXPECTED, decompressedLength}).addLogInfo(new Object[]{LogMessageKeys.ACTUAL, actualDecompressedSize});
            }
            if (decompressor.getRemaining() > 0) {
                throw new RecordSerializationException("decompressed record too large", new Object[0]).addLogInfo(new Object[]{LogMessageKeys.EXPECTED, decompressedLength});
            }
        }
        finally {
            decompressor.end();
        }
        state.setDataArray(decompressed);
        if (timer != null) {
            timer.recordSinceNanoTime(RecordSerializer.Events.DECOMPRESS_SERIALIZED_RECORD, startTime);
        }
    }

    protected void decrypt(@Nonnull TransformedRecordSerializerState state, @Nullable StoreTimer timer) throws GeneralSecurityException {
        throw new RecordSerializationException("this serializer cannot decrypt", new Object[0]);
    }

    @Override
    @Nonnull
    public M deserialize(@Nonnull RecordMetaData metaData, @Nonnull Tuple primaryKey, @Nonnull byte[] serialized, @Nullable StoreTimer timer) {
        TransformedRecordSerializerState state = new TransformedRecordSerializerState(serialized);
        if (!TransformedRecordSerializerPrefix.decodePrefix(state, primaryKey)) {
            return this.inner.deserialize(metaData, primaryKey, serialized, timer);
        }
        if (state.isEncrypted()) {
            try {
                this.decrypt(state, timer);
            }
            catch (RecordCoreException ex) {
                throw ex.addLogInfo(new Object[]{LogMessageKeys.META_DATA_VERSION, metaData.getVersion()}).addLogInfo(new Object[]{LogMessageKeys.PRIMARY_KEY, primaryKey});
            }
            catch (GeneralSecurityException ex) {
                throw new RecordSerializationException("decryption error", ex).addLogInfo(new Object[]{LogMessageKeys.META_DATA_VERSION, metaData.getVersion()}).addLogInfo(new Object[]{LogMessageKeys.PRIMARY_KEY, primaryKey});
            }
        }
        if (state.isCompressed()) {
            try {
                this.decompress(state, timer);
            }
            catch (RecordCoreException ex) {
                throw ex.addLogInfo(new Object[]{LogMessageKeys.META_DATA_VERSION, metaData.getVersion()}).addLogInfo(new Object[]{LogMessageKeys.PRIMARY_KEY, primaryKey});
            }
            catch (DataFormatException ex) {
                throw new RecordSerializationException("decompression error", ex).addLogInfo(new Object[]{LogMessageKeys.META_DATA_VERSION, metaData.getVersion()}).addLogInfo(new Object[]{LogMessageKeys.PRIMARY_KEY, primaryKey});
            }
        }
        return this.inner.deserialize(metaData, primaryKey, state.getDataArray(), timer);
    }

    @Override
    @Nonnull
    public RecordSerializer<Message> widen() {
        return new TransformedRecordSerializer<Message>(this.inner.widen(), this.compressWhenSerializing, this.compressionLevel, this.encryptWhenSerializing, this.writeValidationRatio);
    }

    @Nonnull
    public RecordSerializer<M> untransformed() {
        return this.inner;
    }

    public static Builder<Message> newDefaultBuilder() {
        return TransformedRecordSerializer.newBuilder(DynamicMessageRecordSerializer.instance());
    }

    public static <M extends Message> Builder<M> newBuilder(@Nonnull RecordSerializer<M> inner) {
        return new Builder<M>(inner);
    }

    public static class Builder<M extends Message> {
        @Nonnull
        protected final RecordSerializer<M> inner;
        protected boolean compressWhenSerializing;
        protected int compressionLevel = 9;
        protected boolean encryptWhenSerializing;
        protected double writeValidationRatio;

        protected Builder(@Nonnull RecordSerializer<M> inner) {
            this.inner = inner;
        }

        @Nonnull
        public Builder<M> setCompressWhenSerializing(boolean compressWhenSerializing) {
            this.compressWhenSerializing = compressWhenSerializing;
            return this;
        }

        @Nonnull
        public Builder<M> setCompressionLevel(int level) {
            this.compressionLevel = level;
            return this;
        }

        @Nonnull
        public Builder<M> setEncryptWhenSerializing(boolean encryptWhenSerializing) {
            this.encryptWhenSerializing = encryptWhenSerializing;
            return this;
        }

        @Nonnull
        public Builder<M> setWriteValidationRatio(double writeValidationRatio) {
            this.writeValidationRatio = writeValidationRatio;
            return this;
        }

        public TransformedRecordSerializer<M> build() {
            if (this.encryptWhenSerializing) {
                throw new RecordCoreArgumentException("cannot encrypt when serializing using this class", new Object[0]);
            }
            return new TransformedRecordSerializer<M>(this.inner, this.compressWhenSerializing, this.compressionLevel, this.encryptWhenSerializing, this.writeValidationRatio);
        }
    }
}

