/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record.provider.common;

import com.apple.foundationdb.annotation.API;
import com.apple.foundationdb.record.RecordCoreArgumentException;
import com.apple.foundationdb.record.provider.common.CipherPool;
import com.apple.foundationdb.record.provider.common.DynamicMessageRecordSerializer;
import com.apple.foundationdb.record.provider.common.FixedZeroKeyManager;
import com.apple.foundationdb.record.provider.common.RecordSerializationException;
import com.apple.foundationdb.record.provider.common.RecordSerializer;
import com.apple.foundationdb.record.provider.common.SerializationKeyManager;
import com.apple.foundationdb.record.provider.common.StoreTimer;
import com.apple.foundationdb.record.provider.common.TransformedRecordSerializer;
import com.apple.foundationdb.record.provider.common.TransformedRecordSerializerState;
import com.google.protobuf.Message;
import java.security.GeneralSecurityException;
import java.security.Key;
import java.security.SecureRandom;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.crypto.Cipher;
import javax.crypto.spec.IvParameterSpec;

@API(value=API.Status.UNSTABLE)
public class TransformedRecordSerializerJCE<M extends Message>
extends TransformedRecordSerializer<M> {
    @Nullable
    protected final SerializationKeyManager keyManager;

    protected TransformedRecordSerializerJCE(@Nonnull RecordSerializer<M> inner, boolean compressWhenSerializing, int compressionLevel, boolean encryptWhenSerializing, double writeValidationRatio, @Nullable SerializationKeyManager keyManager) {
        super(inner, compressWhenSerializing, compressionLevel, encryptWhenSerializing, writeValidationRatio);
        this.keyManager = keyManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void encrypt(@Nonnull TransformedRecordSerializerState state, @Nullable StoreTimer timer) throws GeneralSecurityException {
        if (this.keyManager == null) {
            throw new RecordSerializationException("attempted to encrypt without setting key manager (cipher name and key)", new Object[0]);
        }
        long startTime = System.nanoTime();
        int keyNumber = this.keyManager.getSerializationKey();
        state.setKeyNumber(keyNumber);
        byte[] ivData = new byte[16];
        this.keyManager.getRandom(keyNumber).nextBytes(ivData);
        IvParameterSpec iv = new IvParameterSpec(ivData);
        Cipher cipher = CipherPool.borrowCipher(this.keyManager.getCipher(keyNumber));
        try {
            cipher.init(1, this.keyManager.getKey(keyNumber), iv);
            byte[] plainText = state.getDataArray();
            byte[] cipherText = cipher.doFinal(plainText);
            int totalSize = 16 + cipherText.length;
            byte[] serialized = new byte[totalSize];
            System.arraycopy(iv.getIV(), 0, serialized, 0, 16);
            System.arraycopy(cipherText, 0, serialized, 16, cipherText.length);
            state.setEncrypted(true);
            state.setDataArray(serialized);
        }
        finally {
            CipherPool.returnCipher(cipher);
            if (timer != null) {
                timer.recordSinceNanoTime(RecordSerializer.Events.ENCRYPT_SERIALIZED_RECORD, startTime);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void decrypt(@Nonnull TransformedRecordSerializerState state, @Nullable StoreTimer timer) throws GeneralSecurityException {
        if (this.keyManager == null) {
            throw new RecordSerializationException("missing encryption key or provider during decryption", new Object[0]);
        }
        long startTime = System.nanoTime();
        byte[] ivData = new byte[16];
        System.arraycopy(state.getData(), state.getOffset(), ivData, 0, 16);
        IvParameterSpec iv = new IvParameterSpec(ivData);
        byte[] cipherText = new byte[state.getLength() - 16];
        System.arraycopy(state.getData(), state.getOffset() + 16, cipherText, 0, cipherText.length);
        Cipher cipher = CipherPool.borrowCipher(this.keyManager.getCipher(state.getKeyNumber()));
        try {
            cipher.init(2, this.keyManager.getKey(state.getKeyNumber()), iv);
            byte[] plainText = cipher.doFinal(cipherText);
            state.setDataArray(plainText);
        }
        finally {
            CipherPool.returnCipher(cipher);
            if (timer != null) {
                timer.recordSinceNanoTime(RecordSerializer.Events.DECRYPT_SERIALIZED_RECORD, startTime);
            }
        }
    }

    @Override
    @Nonnull
    public RecordSerializer<Message> widen() {
        return new TransformedRecordSerializerJCE<Message>(this.inner.widen(), this.compressWhenSerializing, this.compressionLevel, this.encryptWhenSerializing, this.writeValidationRatio, this.keyManager);
    }

    public static Builder<Message> newDefaultBuilder() {
        return TransformedRecordSerializerJCE.newBuilder(DynamicMessageRecordSerializer.instance());
    }

    public static <M extends Message> Builder<M> newBuilder(@Nonnull RecordSerializer<M> inner) {
        return new Builder<M>(inner);
    }

    public static class Builder<M extends Message>
    extends TransformedRecordSerializer.Builder<M> {
        @Nullable
        protected SerializationKeyManager keyManager;
        @Nullable
        protected String cipherName;
        @Nullable
        protected Key encryptionKey;
        @Nullable
        protected SecureRandom secureRandom;

        protected Builder(@Nonnull RecordSerializer<M> inner) {
            super(inner);
        }

        @Override
        @Nonnull
        public Builder<M> setCompressWhenSerializing(boolean compressWhenSerializing) {
            super.setCompressWhenSerializing(compressWhenSerializing);
            return this;
        }

        @Override
        @Nonnull
        public Builder<M> setCompressionLevel(int level) {
            super.setCompressionLevel(level);
            return this;
        }

        @Override
        @Nonnull
        public Builder<M> setEncryptWhenSerializing(boolean encryptWhenSerializing) {
            super.setEncryptWhenSerializing(encryptWhenSerializing);
            return this;
        }

        @Override
        @Nonnull
        public Builder<M> setWriteValidationRatio(double writeValidationRatio) {
            super.setWriteValidationRatio(writeValidationRatio);
            return this;
        }

        public Builder<M> setEncryptionKey(@Nonnull Key encryptionKey) {
            this.encryptionKey = encryptionKey;
            return this;
        }

        public Builder<M> setCipherName(@Nonnull String cipherName) {
            this.cipherName = cipherName;
            return this;
        }

        public Builder<M> clearEncryption() {
            this.cipherName = null;
            this.encryptionKey = null;
            return this;
        }

        public Builder<M> setSecureRandom(@Nonnull SecureRandom secureRandom) {
            this.secureRandom = secureRandom;
            return this;
        }

        public Builder<M> clearSecureRandom() {
            this.secureRandom = null;
            return this;
        }

        public Builder<M> setKeyManager(@Nonnull SerializationKeyManager keyManager) {
            this.keyManager = keyManager;
            return this;
        }

        public Builder<M> clearKeyManager() {
            this.keyManager = null;
            return this;
        }

        @Override
        public TransformedRecordSerializerJCE<M> build() {
            return new TransformedRecordSerializerJCE(this.inner, this.compressWhenSerializing, this.compressionLevel, this.encryptWhenSerializing, this.writeValidationRatio, this.resolveKeyManager());
        }

        @Nullable
        private SerializationKeyManager resolveKeyManager() {
            if (this.keyManager != null) {
                if (this.encryptionKey != null) {
                    throw new RecordCoreArgumentException("cannot specify both key manager and encryption key", new Object[0]);
                }
                if (this.cipherName != null) {
                    throw new RecordCoreArgumentException("cannot specify both key manager and cipher name", new Object[0]);
                }
                if (this.secureRandom != null) {
                    throw new RecordCoreArgumentException("cannot specify both key manager and secure random", new Object[0]);
                }
                return this.keyManager;
            }
            if (this.encryptionKey != null) {
                return new FixedZeroKeyManager(this.encryptionKey, this.cipherName, this.secureRandom);
            }
            if (!this.encryptWhenSerializing) {
                return null;
            }
            throw new RecordCoreArgumentException("cannot encrypt when serializing if encryption key is not set", new Object[0]);
        }
    }
}

