/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record.provider.common;

import com.apple.foundationdb.annotation.API;
import com.apple.foundationdb.record.logging.LogMessageKeys;
import com.apple.foundationdb.record.provider.common.RecordSerializationException;
import com.apple.foundationdb.record.provider.common.TransformedRecordSerializerState;
import com.apple.foundationdb.tuple.Tuple;
import javax.annotation.Nonnull;

@API(value=API.Status.INTERNAL)
class TransformedRecordSerializerPrefix {
    protected static final int PREFIX_ENCRYPTED = 1;
    protected static final int PREFIX_CLEAR = 2;
    protected static final int PREFIX_COMPRESSED = 4;
    protected static final int PREFIX_COMPRESSED_THEN_ENCRYPTED = 5;
    protected static final int TYPE_MASK = 7;
    protected static final int KEY_SHIFT = 3;

    TransformedRecordSerializerPrefix() {
    }

    public static boolean decodePrefix(@Nonnull TransformedRecordSerializerState state, @Nonnull Tuple primaryKey) {
        long prefix = TransformedRecordSerializerPrefix.readVarint(state, primaryKey);
        int type = (int)(prefix & 7L);
        long remaining = prefix >> 3;
        if (type == 2 && remaining != 0L) {
            return false;
        }
        boolean valid = true;
        switch (type) {
            case 2: {
                break;
            }
            case 5: {
                state.setEncrypted(true);
                state.setCompressed(true);
                break;
            }
            case 1: {
                state.setEncrypted(true);
                break;
            }
            case 4: {
                state.setCompressed(true);
                break;
            }
            default: {
                valid = false;
            }
        }
        if (state.isEncrypted()) {
            if (remaining < Integer.MIN_VALUE || remaining > Integer.MAX_VALUE) {
                valid = false;
            } else {
                state.setKeyNumber((int)remaining);
            }
        } else if (remaining != 0L) {
            valid = false;
        }
        if (!valid) {
            throw new RecordSerializationException("unrecognized transformation encoding", new Object[0]).addLogInfo(new Object[]{LogMessageKeys.PRIMARY_KEY, primaryKey}).addLogInfo("encoding", (Object)prefix);
        }
        return true;
    }

    public static void encodePrefix(@Nonnull TransformedRecordSerializerState state) {
        long prefix;
        if (!state.isCompressed() && !state.isEncrypted()) {
            prefix = 2L;
        } else {
            prefix = 0L;
            if (state.isCompressed()) {
                prefix |= 4L;
            }
            if (state.isEncrypted()) {
                prefix |= 1L;
                prefix |= (long)state.getKeyNumber() << 3;
            }
        }
        int size = state.getLength() + TransformedRecordSerializerPrefix.varintSize(prefix);
        byte[] serialized = new byte[size];
        int offset = TransformedRecordSerializerPrefix.writeVarint(serialized, prefix);
        System.arraycopy(state.getData(), state.getOffset(), serialized, offset, state.getLength());
        state.setDataArray(serialized);
    }

    protected static int varintSize(long varint) {
        int nbytes = 0;
        do {
            ++nbytes;
        } while ((varint >>>= 7) != 0L);
        return nbytes;
    }

    protected static long readVarint(@Nonnull TransformedRecordSerializerState state, @Nonnull Tuple primaryKey) {
        byte b;
        long varint = 0L;
        int nbytes = 0;
        do {
            if (nbytes >= state.getLength()) {
                throw new RecordSerializationException("transformation prefix malformed", new Object[0]).addLogInfo(new Object[]{LogMessageKeys.PRIMARY_KEY, primaryKey});
            }
            b = state.getData()[state.getOffset() + nbytes];
            if (nbytes == 9 && (b & 0xFE) != 0) {
                throw new RecordSerializationException("transformation prefix too long", new Object[0]).addLogInfo(new Object[]{LogMessageKeys.PRIMARY_KEY, primaryKey});
            }
            varint |= (long)(b & 0x7F) << nbytes * 7;
            ++nbytes;
        } while ((b & 0x80) != 0);
        state.setOffset(state.getOffset() + nbytes);
        state.setLength(state.getLength() - nbytes);
        return varint;
    }

    protected static int writeVarint(@Nonnull byte[] into, long varint) {
        int nbytes = 0;
        do {
            byte b = (byte)(varint & 0x7FL);
            if ((varint >>>= 7) != 0L) {
                b = (byte)(b | 0xFFFFFF80);
            }
            into[nbytes] = b;
            ++nbytes;
        } while (varint != 0L);
        return nbytes;
    }
}

