/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record.provider.common;

import com.apple.foundationdb.annotation.API;
import com.apple.foundationdb.annotation.SpotBugsSuppressWarnings;
import com.apple.foundationdb.record.provider.common.CompressedAndEncryptedSerializerState;
import java.util.Arrays;
import javax.annotation.Nonnull;

@API(value=API.Status.INTERNAL)
@SpotBugsSuppressWarnings(value={"EI_EXPOSE_REP"})
class TransformedRecordSerializerState
extends CompressedAndEncryptedSerializerState {
    @Nonnull
    private byte[] data;
    private int offset;
    private int length;

    public TransformedRecordSerializerState(@Nonnull byte[] data) {
        this(data, 0, data.length);
    }

    public TransformedRecordSerializerState(@Nonnull byte[] data, int offset, int length) {
        this.data = data;
        this.offset = offset;
        this.length = length;
    }

    @Nonnull
    public byte[] getData() {
        return this.data;
    }

    public int getOffset() {
        return this.offset;
    }

    public void setOffset(int offset) {
        this.offset = offset;
    }

    public int getLength() {
        return this.length;
    }

    public void setLength(int length) {
        this.length = length;
    }

    @Nonnull
    public byte[] getDataArray() {
        if (this.getOffset() == 0 && this.getLength() == this.getData().length) {
            return this.getData();
        }
        byte[] newData = Arrays.copyOfRange(this.getData(), this.getOffset(), this.getOffset() + this.getLength());
        this.offset = 0;
        this.length = newData.length;
        this.data = newData;
        return newData;
    }

    public void setDataArray(@Nonnull byte[] data) {
        this.setDataArray(data, 0, data.length);
    }

    public void setDataArray(@Nonnull byte[] data, int offset, int length) {
        this.data = data;
        this.offset = offset;
        this.length = length;
    }
}

