/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record.provider.common;

import com.apple.foundationdb.annotation.API;
import com.apple.foundationdb.record.RecordCoreArgumentException;
import com.apple.foundationdb.record.RecordMetaData;
import com.apple.foundationdb.record.metadata.RecordType;
import com.apple.foundationdb.record.provider.common.MessageBuilderRecordSerializerBase;
import com.apple.foundationdb.record.provider.common.RecordSerializationException;
import com.google.protobuf.Descriptors;
import com.google.protobuf.Message;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import javax.annotation.Nonnull;

@API(value=API.Status.UNSTABLE)
public class TypedRecordSerializer<M extends Message, U extends Message, B extends Message.Builder>
extends MessageBuilderRecordSerializerBase<M, U, B> {
    @Nonnull
    private final Descriptors.FieldDescriptor fieldDescriptor;
    @Nonnull
    private final Predicate<U> tester;
    @Nonnull
    private final Function<U, M> getter;
    @Nonnull
    private final BiConsumer<B, M> setter;
    @Nonnull
    private final AtomicReference<String> validRecordType = new AtomicReference();

    public TypedRecordSerializer(@Nonnull Descriptors.FieldDescriptor fieldDescriptor, @Nonnull Supplier<B> builderSupplier, @Nonnull Predicate<U> tester, @Nonnull Function<U, M> getter, @Nonnull BiConsumer<B, M> setter) {
        super(builderSupplier);
        this.fieldDescriptor = fieldDescriptor;
        this.tester = tester;
        this.getter = getter;
        this.setter = setter;
        Message.Builder builder = (Message.Builder)builderSupplier.get();
        Message empty = builder.buildPartial();
        if (tester.test(empty)) {
            throw new RecordCoreArgumentException("tester is satisfied by empty union", new Object[0]);
        }
        Message rec = (Message)getter.apply(empty);
        if (rec != empty.getField(fieldDescriptor)) {
            throw new RecordCoreArgumentException("fieldDescriptor and getter do not match", new Object[0]);
        }
        setter.accept(builder, rec);
        Message full = builder.buildPartial();
        if (!tester.test(full)) {
            throw new RecordCoreArgumentException("tester not satisfied by full union", new Object[0]);
        }
    }

    @Override
    protected void setUnionField(@Nonnull RecordMetaData metaData, @Nonnull RecordType recordType, @Nonnull B unionBuilder, @Nonnull M rec) {
        String valid;
        String typeName = recordType.getName();
        if (!typeName.equals(valid = this.validRecordType.get())) {
            if (this.fieldDescriptor != metaData.getUnionFieldForRecordType(recordType)) {
                throw new RecordSerializationException("fieldDescriptor does not match recordType", new Object[0]).addLogInfo("fieldDescriptor", (Object)this.fieldDescriptor.getName()).addLogInfo("recordType", (Object)recordType.getName()).addLogInfo("metaDataVersion", (Object)metaData.getVersion());
            }
            this.validRecordType.compareAndSet(valid, typeName);
        }
        this.setter.accept(unionBuilder, rec);
    }

    @Override
    @Nonnull
    protected M getUnionField(@Nonnull Descriptors.Descriptor unionDescriptor, @Nonnull U storedRecord) {
        if (!this.tester.test(storedRecord)) {
            throw new RecordSerializationException("Specified union field was not set", new Object[0]).addLogInfo("unionDescriptorFullName", (Object)unionDescriptor.getFullName()).addLogInfo("recordType", (Object)storedRecord.getDescriptorForType().getName());
        }
        return (M)((Message)this.getter.apply(storedRecord));
    }
}

