/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record.provider.common.text;

import com.apple.foundationdb.annotation.API;
import com.apple.foundationdb.record.provider.common.text.TextCollator;
import com.apple.foundationdb.record.provider.common.text.TextCollatorRegistry;
import com.apple.foundationdb.record.util.MapUtils;
import com.apple.foundationdb.record.util.pair.NonnullPair;
import com.google.protobuf.ByteString;
import com.google.protobuf.ZeroCopyByteString;
import java.text.Collator;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.Nonnull;

@API(value=API.Status.EXPERIMENTAL)
public class TextCollatorRegistryJRE
implements TextCollatorRegistry {
    public static final TextCollatorRegistryJRE INSTANCE = new TextCollatorRegistryJRE();
    private static final String DEFAULT_LOCALE = "";
    private Map<NonnullPair<String, Integer>, TextCollatorJRE> collators = new ConcurrentHashMap<NonnullPair<String, Integer>, TextCollatorJRE>();

    public static TextCollatorRegistry instance() {
        return INSTANCE;
    }

    private TextCollatorRegistryJRE() {
    }

    @Override
    @Nonnull
    public String getName() {
        return "jre";
    }

    @Override
    @Nonnull
    public TextCollator getTextCollator(int strength) {
        return this.getTextCollator(DEFAULT_LOCALE, strength);
    }

    @Override
    @Nonnull
    public TextCollator getTextCollator(@Nonnull String locale, int strength) {
        return MapUtils.computeIfAbsent(this.collators, NonnullPair.of(locale, strength), key -> {
            Collator collator = DEFAULT_LOCALE.equals(locale) ? Collator.getInstance(Locale.ROOT) : Collator.getInstance(Locale.forLanguageTag(locale.replace("_", "-")));
            collator.setStrength(strength);
            return new TextCollatorJRE(collator);
        });
    }

    protected static class TextCollatorJRE
    implements TextCollator {
        @Nonnull
        private final Collator collator;

        protected TextCollatorJRE(@Nonnull Collator collator) {
            this.collator = collator;
        }

        @Override
        public int compare(@Nonnull String str1, @Nonnull String str2) {
            return this.collator.compare(str1, str2);
        }

        @Override
        @Nonnull
        public ByteString getKey(@Nonnull String str) {
            return ZeroCopyByteString.wrap(this.collator.getCollationKey(str).toByteArray());
        }
    }
}

