/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record.provider.common.text;

import com.apple.foundationdb.annotation.API;
import com.apple.foundationdb.record.metadata.MetaDataException;
import com.apple.foundationdb.record.util.MapUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;

@API(value=API.Status.EXPERIMENTAL)
public interface TextTokenizer {
    public static final int GLOBAL_MIN_VERSION = 0;

    @Nonnull
    public Iterator<? extends CharSequence> tokenize(@Nonnull String var1, int var2, @Nonnull TokenizerMode var3);

    @Nonnull
    default public Map<String, List<Integer>> tokenizeToMap(@Nonnull String text, int version, @Nonnull TokenizerMode mode) {
        Iterator<? extends CharSequence> tokens = this.tokenize(text, version, mode);
        HashMap<String, List<Integer>> offsetMap = new HashMap<String, List<Integer>>();
        int offset = 0;
        while (tokens.hasNext()) {
            String token = tokens.next().toString();
            if (!token.isEmpty()) {
                MapUtils.computeIfAbsent(offsetMap, token, ignore -> new ArrayList()).add(offset);
            }
            ++offset;
        }
        return offsetMap;
    }

    default public List<String> tokenizeToList(@Nonnull String text, int version, @Nonnull TokenizerMode mode) {
        Iterator<? extends CharSequence> tokens = this.tokenize(text, version, mode);
        ArrayList<String> tokenList = new ArrayList<String>();
        while (tokens.hasNext()) {
            tokenList.add(tokens.next().toString());
        }
        return tokenList;
    }

    default public int getMinVersion() {
        return 0;
    }

    public int getMaxVersion();

    @Nonnull
    public String getName();

    default public void validateVersion(int version) {
        if (version < this.getMinVersion() || version > this.getMaxVersion()) {
            throw new MetaDataException("unknown tokenizer version", new Object[0]).addLogInfo("textTokenizerName", (Object)this.getName()).addLogInfo("textTokenizerVersion", (Object)version).addLogInfo("minVersion", (Object)this.getMinVersion()).addLogInfo("maxVersion", (Object)this.getMaxVersion());
        }
    }

    public static enum TokenizerMode {
        INDEX,
        QUERY;

    }
}

