/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record.provider.common.text;

import com.apple.foundationdb.annotation.API;
import com.apple.foundationdb.record.RecordCoreArgumentException;
import com.apple.foundationdb.record.logging.KeyValueLogMessage;
import com.apple.foundationdb.record.logging.LogMessageKeys;
import com.apple.foundationdb.record.metadata.MetaDataException;
import com.apple.foundationdb.record.provider.common.text.DefaultTextTokenizer;
import com.apple.foundationdb.record.provider.common.text.TextTokenizer;
import com.apple.foundationdb.record.provider.common.text.TextTokenizerFactory;
import com.apple.foundationdb.record.provider.common.text.TextTokenizerRegistry;
import com.apple.foundationdb.record.util.ServiceLoaderProvider;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@API(value=API.Status.EXPERIMENTAL)
public class TextTokenizerRegistryImpl
implements TextTokenizerRegistry {
    @Nonnull
    private static final Logger LOGGER = LoggerFactory.getLogger(TextTokenizerRegistryImpl.class);
    @Nonnull
    private static final TextTokenizerRegistryImpl INSTANCE = new TextTokenizerRegistryImpl();
    @Nonnull
    private Map<String, TextTokenizerFactory> registry = TextTokenizerRegistryImpl.initRegistry();

    @Nonnull
    private static Map<String, TextTokenizerFactory> initRegistry() {
        HashMap<String, TextTokenizerFactory> registry = new HashMap<String, TextTokenizerFactory>();
        for (TextTokenizerFactory factory : ServiceLoaderProvider.load(TextTokenizerFactory.class)) {
            String name = factory.getName();
            if (registry.containsKey(name)) {
                if (!LOGGER.isWarnEnabled()) continue;
                LOGGER.warn(KeyValueLogMessage.of("duplicate text tokenizer", new Object[]{LogMessageKeys.TOKENIZER_NAME, name}));
                continue;
            }
            if (LOGGER.isInfoEnabled()) {
                LOGGER.info(KeyValueLogMessage.of("found text tokenizer", new Object[]{LogMessageKeys.TOKENIZER_NAME, name}));
            }
            registry.put(name, factory);
        }
        return registry;
    }

    @Nonnull
    public static TextTokenizerRegistry instance() {
        return INSTANCE;
    }

    private TextTokenizerRegistryImpl() {
    }

    @Override
    @Nonnull
    public Map<String, TextTokenizerFactory> getRegistry() {
        return Collections.unmodifiableMap(this.registry);
    }

    @Override
    @Nonnull
    public TextTokenizer getTokenizer(@Nullable String name) {
        if (name == null) {
            return DefaultTextTokenizer.instance();
        }
        TextTokenizerFactory tokenizerFactory = this.registry.get(name);
        if (tokenizerFactory == null) {
            throw new MetaDataException("unrecognized text tokenizer", new Object[]{LogMessageKeys.TOKENIZER_NAME, name});
        }
        return tokenizerFactory.getTokenizer();
    }

    @Override
    public synchronized void register(@Nonnull TextTokenizerFactory tokenizerFactory) {
        String name = tokenizerFactory.getName();
        TextTokenizerFactory oldFactory = this.registry.putIfAbsent(name, tokenizerFactory);
        if (oldFactory != null && oldFactory != tokenizerFactory) {
            throw new RecordCoreArgumentException("attempted to register duplicate tokenizer", new Object[]{LogMessageKeys.TOKENIZER_NAME, name});
        }
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info(KeyValueLogMessage.of("registered tokenizer", new Object[]{LogMessageKeys.TOKENIZER_NAME, name}));
        }
    }

    @Override
    public void reset() {
        this.registry = TextTokenizerRegistryImpl.initRegistry();
    }
}

