/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record.provider.foundationdb;

import com.apple.foundationdb.annotation.API;
import com.apple.foundationdb.record.RecordCoreArgumentException;
import javax.annotation.Nonnull;

@API(value=API.Status.EXPERIMENTAL)
public enum APIVersion {
    API_VERSION_6_3(630),
    API_VERSION_7_0(700),
    API_VERSION_7_1(710);

    private final int versionNumber;

    private APIVersion(int versionNumber) {
        this.versionNumber = versionNumber;
    }

    public int getVersionNumber() {
        return this.versionNumber;
    }

    public boolean isAtLeast(@Nonnull APIVersion other) {
        return this.versionNumber >= other.getVersionNumber();
    }

    public static APIVersion getDefault() {
        return API_VERSION_6_3;
    }

    public static APIVersion fromVersionNumber(int versionNumber) {
        for (APIVersion version : APIVersion.values()) {
            if (version.getVersionNumber() != versionNumber) continue;
            return version;
        }
        throw new RecordCoreArgumentException("api version not supported", new Object[0]);
    }
}

