/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record.provider.foundationdb;

import com.apple.foundationdb.async.TaskNotifyingExecutor;
import java.util.Map;
import java.util.concurrent.Executor;
import javax.annotation.Nonnull;
import org.slf4j.MDC;

class ContextRestoringExecutor
extends TaskNotifyingExecutor {
    @Nonnull
    private final Map<String, String> mdcContext;

    public ContextRestoringExecutor(@Nonnull Executor delegate, @Nonnull Map<String, String> mdcContext) {
        super(delegate);
        this.mdcContext = mdcContext;
    }

    @Override
    public void beforeTask() {
        ContextRestoringExecutor.restoreMdc(this.mdcContext);
    }

    @Override
    public void afterTask() {
        ContextRestoringExecutor.clearMdc(this.mdcContext);
    }

    @Nonnull
    public Map<String, String> getMdcContext() {
        return this.mdcContext;
    }

    static void restoreMdc(@Nonnull Map<String, String> mdcContext) {
        MDC.setContextMap(mdcContext);
    }

    static void clearMdc(@Nonnull Map<String, String> mdcContext) {
        Map<String, String> map = MDC.getMDCAdapter().getCopyOfContextMap();
        for (String key : mdcContext.keySet()) {
            map.remove(key);
        }
        MDC.setContextMap(map);
    }
}

