/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record.provider.foundationdb;

import com.apple.foundationdb.EventKeeper;
import com.apple.foundationdb.annotation.SpotBugsSuppressWarnings;
import com.apple.foundationdb.record.provider.common.StoreTimer;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.Nullable;

class EventKeeperTranslator
implements EventKeeper {
    private static final Map<EventKeeper.Event, StoreTimer.Event> eventKeeperMap = new ConcurrentHashMap<EventKeeper.Event, StoreTimer.Event>();
    @Nullable
    private final StoreTimer underlying;

    public EventKeeperTranslator(@Nullable StoreTimer underlying) {
        this.underlying = underlying;
    }

    @Override
    public void count(EventKeeper.Event event, long amount) {
        if (this.underlying != null) {
            StoreTimer.Event storeTimerEvent = EventKeeperTranslator.getEvent(event);
            if (storeTimerEvent instanceof Count) {
                this.underlying.increment((StoreTimer.Count)storeTimerEvent, (int)amount);
            } else {
                this.underlying.record(storeTimerEvent, amount);
            }
        }
    }

    @Override
    public void timeNanos(EventKeeper.Event event, long nanos) {
        this.count(event, nanos);
    }

    @Override
    public long getCount(EventKeeper.Event event) {
        if (this.underlying == null) {
            return 0L;
        }
        return this.underlying.getCount(EventKeeperTranslator.getEvent(event));
    }

    @Override
    public long getTimeNanos(EventKeeper.Event event) {
        if (this.underlying == null) {
            return 0L;
        }
        return this.underlying.getTimeNanos(EventKeeperTranslator.getEvent(event));
    }

    private static StoreTimer.Event getEvent(EventKeeper.Event event) {
        return eventKeeperMap.computeIfAbsent(event, keeperEvent -> {
            String name = event.name();
            String title = event.name().toLowerCase(Locale.ROOT).replace('_', ' ');
            if (event.isTimeEvent()) {
                return new Event(name, title);
            }
            return new Count(name, title, false);
        });
    }

    static {
        eventKeeperMap.put(EventKeeper.Events.JNI_CALL, new Count("JNI_CALLS", "jni calls", false));
        eventKeeperMap.put(EventKeeper.Events.RANGE_QUERY_FETCHES, new Count("RANGE_FETCHES", "range fetches", false));
        eventKeeperMap.put(EventKeeper.Events.RANGE_QUERY_RECORDS_FETCHED, new Count("RANGE_KEYVALUES_FETCHED", "range key-values ", false));
        eventKeeperMap.put(EventKeeper.Events.RANGE_QUERY_CHUNK_FAILED, new Count("CHUNK_READ_FAILURES", "read fails", false));
        eventKeeperMap.put(EventKeeper.Events.RANGE_QUERY_FETCH_TIME_NANOS, new Event("FETCHES", "fetches"));
    }

    @SpotBugsSuppressWarnings(value={"EQ_DOESNT_OVERRIDE_EQUALS"})
    private static class Count
    extends BaseEvent
    implements StoreTimer.Count {
        protected final boolean isSize;

        public Count(String name, String title, boolean isSize) {
            super(name, title);
            this.isSize = isSize;
        }

        @Override
        public boolean isSize() {
            return this.isSize;
        }
    }

    private static class Event
    extends BaseEvent
    implements StoreTimer.Event {
        public Event(String name, String title) {
            super(name, title);
        }
    }

    private static class BaseEvent {
        protected final String name;
        protected final String title;
        protected final String logKey;

        public BaseEvent(String name, String title) {
            this.name = name;
            this.title = title;
            this.logKey = name.toLowerCase(Locale.ROOT);
        }

        public String name() {
            return this.name;
        }

        public String title() {
            return this.title;
        }

        public String logKey() {
            return this.logKey;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            BaseEvent baseEvent = (BaseEvent)o;
            return Objects.equals(this.name, baseEvent.name);
        }

        public int hashCode() {
            return this.name.hashCode();
        }

        public String toString() {
            return this.name;
        }
    }
}

